/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="receive")
public class ReceiveBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIncomeContractApi incomApi;
    @Autowired
    private IReceiveService receiveService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        if (entity.getContractId() != null) {
            this.incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), Boolean.valueOf(true));
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        if (!this.validateCreateTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u5b58\u5728\u540e\u7eed\u5355\u636e,\u4e0d\u80fd\u5f03\u5ba1!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u652f\u51fa\u5355\u636e\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u64a4\u56de\u64cd\u4f5c!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        if (entity.getContractId() != null) {
            this.incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), Boolean.valueOf(false));
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private boolean validateEffective(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.receiveService.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateCreateTime(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        Date createTime = entity.getCreateTime();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.gt((Object)"create_time", (Object)createTime);
        List list = this.receiveService.list((Wrapper)wrapper);
        return list.isEmpty();
    }
}

