/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayReimburseServiceImpl
extends BaseServiceImpl<PayReimburseMapper, PayReimburseEntity>
implements IPayReimburseService {
    private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private FeignUtil feignUtil;

    @Override
    public PayReimburseVO insertOrUpdate(PayReimburseVO vo) {
        PayReimburseEntity entity = (PayReimburseEntity)((Object)BeanMapper.map((Object)vo, PayReimburseEntity.class));
        this.autoSetBillCode(entity);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        if (StringUtils.isEmpty((String)entity.getInvoiceFlag())) {
            entity.setInvoiceFlag("3");
        }
        super.saveOrUpdate((Object)entity);
        if (2 == vo.getPayStatus()) {
            PayReimburseEntity payReimburseEntity = (PayReimburseEntity)((Object)super.selectById((Serializable)entity.getId()));
            this.costPush(payReimburseEntity);
        }
        Long id = entity.getId();
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        PayReimburseVO backVO = (PayReimburseVO)BeanMapper.map((Object)super.getById((Serializable)id), PayReimburseVO.class);
        backVO.setInvoiceVOList(invoiceVOList);
        return backVO;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PayReimburseVO vo, Long id) {
        List voList = vo.getInvoiceVOList();
        ArrayList<InvoiceReceiveFlagVO> flagVOS = new ArrayList<InvoiceReceiveFlagVO>();
        ArrayList<Long> receiveIds = new ArrayList<Long>();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u6536\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()).booleanValue()) {
                    throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(invoiceVO.getInvoiceId());
                flagVO.setFlag(Integer.valueOf(1));
                flagVOS.add(flagVO);
                receiveIds.add(invoiceVO.getInvoiceId());
                invoiceVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayInvoiceVO.class);
        }
        List voIds = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List dataList = this.invoiceService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)id));
        List dataIds = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        dataIds.removeAll(voIds);
        List delIds = dataIds;
        if (!delIds.isEmpty()) {
            this.invoiceService.remove((Wrapper)new QueryWrapper().in((Object)"id", delIds), false);
        }
        for (PayInvoiceEntity data : dataList) {
            if (!delIds.contains(data.getId()) || receiveIds.contains(data.getInvoiceId())) continue;
            InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
            flagVO.setId(data.getInvoiceId());
            flagVO.setFlag(Integer.valueOf(0));
            flagVOS.add(flagVO);
        }
        if (!flagVOS.isEmpty()) {
            this.invoiceApi.updateFlag(flagVOS);
        }
        return voList;
    }

    @Override
    public PayReimburseVO queryDetail(Long id) {
        PayReimburseEntity entity = (PayReimburseEntity)((Object)((PayReimburseMapper)this.baseMapper).selectById(id));
        PayReimburseVO vo = (PayReimburseVO)BeanMapper.map((Object)((Object)entity), PayReimburseVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, PayInvoiceVO.class));
        return vo;
    }

    @Override
    public List<PayReimburseVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(324875125018329093L);
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PayReimburseVO vo = (PayReimburseVO)resVos.get(i);
                vo.setFeeTypeName(defdocMap.get(vo.getFeeType()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.removeByIds(ids, false);
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().in((Object)"payapply_id", ids);
            List invoiceList = this.invoiceService.list((Wrapper)wrapper);
            this.invoiceService.remove((Wrapper)wrapper, false);
            ArrayList<InvoiceReceiveFlagVO> flagVOS = new ArrayList<InvoiceReceiveFlagVO>();
            for (PayInvoiceEntity data : invoiceList) {
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(data.getInvoiceId());
                flagVO.setFlag(Integer.valueOf(0));
                flagVOS.add(flagVO);
            }
            if (!flagVOS.isEmpty()) {
                this.invoiceApi.updateFlag(flagVOS);
            }
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(pages, wrapper, flag);
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        queryWrapper.select(new String[]{"ifnull(sum(pay_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"pay_status", (Object)2);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public CommonResponse<PayReimburseVO> pushCost(PayReimburseVO payReimburseVO) {
        PayReimburseEntity payReimburseEntity = (PayReimburseEntity)((Object)((PayReimburseMapper)this.baseMapper).selectById(payReimburseVO.getId()));
        payReimburseEntity.setSubjectId(payReimburseVO.getSubjectId());
        payReimburseEntity.setSubjectName(payReimburseVO.getSubjectName());
        super.saveOrUpdate((Object)payReimburseEntity, false);
        this.costPush(payReimburseEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)payReimburseEntity), PayReimburseVO.class));
    }

    @Override
    public void costPush(PayReimburseEntity payReimburseEntity) {
        if (!"1".equals(payReimburseEntity.getDependOnProject())) {
            return;
        }
        Long subjectId = payReimburseEntity.getSubjectId();
        boolean newRelationFlag = true;
        if (null == subjectId) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{payReimburseEntity.getId()});
        updateWrapper.set(PayReimburseEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = payReimburseEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(payReimburseEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(payReimburseEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && newRelationFlag) {
            this.saveCost(payReimburseEntity);
        }
    }

    private void saveCost(PayReimburseEntity payReimburseEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(payReimburseEntity.getSubjectId());
        costDetailVO.setSourceId(payReimburseEntity.getId());
        costDetailVO.setSourceDetailId(payReimburseEntity.getId());
        costDetailVO.setHappenTaxMny(payReimburseEntity.getPayMny());
        costDetailVO.setHappenMny(payReimburseEntity.getPayMny());
        costDetailVO.setHappenDate(payReimburseEntity.getApplyTime());
        costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(REIM_PAYAPPLY_BILL_CODE);
        costDetailVO.setSourceTabType(REIM_PAYAPPLY_BILL_CODE);
        costDetailVO.setProjectId(payReimburseEntity.getProjectId());
        costDetailVOList.add(costDetailVO);
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            ((Object)costDetailVOList).toString();
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    private void autoSetBillCode(PayReimburseEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayReimburseEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(PayReimburseEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }
}

