/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.bean.ReceiveInvoiceEntity;
import com.ejianc.business.finance.mapper.ReceiveMapper;
import com.ejianc.business.finance.service.IReceiveInvoiceService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.vo.ReceiveInvoiceVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceiveServiceImpl
extends BaseServiceImpl<ReceiveMapper, ReceiveEntity>
implements IReceiveService {
    private static final String RECEIVE_BILL_CODE = "FINANCE_RECEIVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IReceiveInvoiceService invoiceService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private FeignUtil feignUtil;

    @Override
    public ReceiveVO insertOrUpdate(ReceiveVO vo) {
        ReceiveEntity entity = (ReceiveEntity)((Object)BeanMapper.map((Object)vo, ReceiveEntity.class));
        this.validateBeforeSave(entity);
        if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(vo.getContractId()), (String)BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c.getBillTypeCode(), (Integer)vo.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        this.autoSetBillCode(entity);
        super.saveOrUpdate((Object)entity);
        List<ReceiveInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, entity.getId());
        ReceiveVO backVO = (ReceiveVO)BeanMapper.map((Object)super.getById((Serializable)entity.getId()), ReceiveVO.class);
        backVO.setInvoiceVOList(invoiceVOList);
        return backVO;
    }

    private List<ReceiveInvoiceVO> updateInvoiceVOS(ReceiveVO receiveVO, Long id) {
        List voList = receiveVO.getInvoiceVOList();
        if (voList != null && !voList.isEmpty()) {
            for (ReceiveInvoiceVO invoiceVO : voList) {
                if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u5f00\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()).booleanValue()) {
                    throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                invoiceVO.setReceiveId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, ReceiveInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, ReceiveInvoiceVO.class);
        }
        List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"receive_id", (Object)id);
        wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        this.invoiceService.remove((Wrapper)wrapper, false);
        return voList;
    }

    @Override
    public ReceiveVO queryDetail(Long id) {
        ReceiveEntity entity = (ReceiveEntity)((Object)((ReceiveMapper)this.baseMapper).selectById(id));
        ReceiveVO vo = (ReceiveVO)BeanMapper.map((Object)((Object)entity), ReceiveVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("receiveId", new Parameter("eq", (Object)vo.getId()));
        param.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(param, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, ReceiveInvoiceVO.class));
        return vo;
    }

    @Override
    public List<ReceiveVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(330358772148207658L);
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                ReceiveVO vo = (ReceiveVO)resVos.get(i);
                vo.setReceiveTypeName(defdocMap.get(vo.getReceiveType()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.removeByIds(ids, false);
            this.invoiceService.remove((Wrapper)new QueryWrapper().in((Object)"receive_id", ids), false);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        IPage pageData = super.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ReceiveVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return page;
    }

    @Override
    public SumReceiveVO getSumReceiveVOList(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("createTime", "desc");
        List entityList = super.queryList(param, false);
        BigDecimal sumReceiveMny = null;
        for (ReceiveEntity entity : entityList) {
            sumReceiveMny = MathUtil.safeAdd(sumReceiveMny, (BigDecimal)entity.getReceiveMny());
        }
        SumReceiveVO vo = new SumReceiveVO();
        vo.setContractId(contractId);
        vo.setSumReceiveMny(sumReceiveMny);
        vo.setReceiveVOList(BeanMapper.mapList((Iterable)entityList, ReceiveVO.class));
        return vo;
    }

    @Override
    public Map<String, Object> countRecAmt(Long tenantId, List<Long> projectIds, boolean isWithContract, List<Long> orgIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        if (isWithContract) {
            queryWrapper.isNotNull((Object)"contract_id");
        }
        queryWrapper.select(new String[]{" round(ifnull(sum(receive_mny),0) / 10000, 2) as amt "});
        return super.getMap((Wrapper)queryWrapper);
    }

    private void validateBeforeSave(ReceiveEntity entity) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ReceiveEntity::getContractId, (Object)entity.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        lambda.notIn(ReceiveEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e,\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
    }

    private void autoSetBillCode(ReceiveEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RECEIVE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ReceiveEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }
}

