package com.ejianc.business.finance.controller.api;

import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.vo.BlocKanBanVo;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.sub.api.ISubBlocKanBanApi;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName: BlocKanBanApi
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/9/7 9:52
 */
@RestController
@RequestMapping("/api/blocKanBan/")
public class FinanceBlocKanBanApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ISubBlocKanBanApi subBlocKanBanApi;

    @Autowired
    private IPayContractService payContractService;



    /**
     * 集团看板分包供应商top5
     * @param orgId
     * @param mnyFlag 0-支付金额(默认)，1-合同总金额，2-欠付金额
     * @param yearFlag 0-今年(默认)，1-全年
     * @return
     */
    @GetMapping(value = "querySupplierPayMny")
    @ResponseBody
    public CommonResponse<List<BlocKanBanVo>> querySupplierPayMny(@RequestParam(value = "orgId", required = false) Long orgId
            , @RequestParam(value = "mnyFlag") Integer mnyFlag, @RequestParam(value = "yearFlag") Integer yearFlag) {

        if (orgId == null) {
            Long tenantid = InvocationInfoProxy.getTenantid();
            CommonResponse<OrgVO> orgByTenantId = orgApi.findOrgByTenantId(tenantid);
            orgId = orgByTenantId.getData().getId();
        }

        // 本下组织
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        // 分包合同总金额
        CommonResponse<Map<Long, ContractVO>> mapCommonResponse = subBlocKanBanApi.queryExternalSupplierAndMny(null, yearFlag);
        if (!mapCommonResponse.isSuccess()) {
            return CommonResponse.error("查询分包数据失败");
        }
        Map<Long, ContractVO> map = mapCommonResponse.getData();
        List<ContractVO> contractVOList = new ArrayList<>(map.values());
        List<Long> supplierIds = contractVOList.stream().map(ContractVO::getSupplierId).collect(Collectors.toList());

        // 查询外部供应商对应的支付金额
        List<PayContractVO> payContractVOList = payContractService.querySupplierPayMny(orgIds, supplierIds, yearFlag);
        Map<Long, PayContractVO> payContractVOMap = payContractVOList.stream().collect(Collectors.toMap(PayContractVO::getReceiveUnitId, Function.identity()));

        Set<Long> set = new HashSet<>(map.keySet());
        set.addAll(payContractVOMap.keySet());

        List<BlocKanBanVo> voList = new ArrayList<>();
        for (Long supplierId : set) {
            BlocKanBanVo vo = new BlocKanBanVo();
            vo.setReceiveUnitId(supplierId);
            if (map.containsKey(supplierId)) {
                vo.setReceiveUnitName(map.get(supplierId).getSupplierName());
                BigDecimal contractTaxMny = map.get(supplierId).getContractTaxMny();
                contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
                vo.setTotalContractTaxMny(contractTaxMny);
            }else {
                vo.setTotalContractTaxMny(BigDecimal.ZERO);
            }

            if (payContractVOMap.containsKey(supplierId)) {
                vo.setReceiveUnitName(payContractVOMap.get(supplierId).getReceiveUnitName());
                BigDecimal payMny = payContractVOMap.get(supplierId).getPayMny();
                payMny = payMny == null ? BigDecimal.ZERO : payMny;
                vo.setTotalPayMny(payMny);
            }else {
                vo.setTotalPayMny(BigDecimal.ZERO);
            }

            vo.setOwedMny(ComputeUtil.safeSub(vo.getTotalContractTaxMny(), vo.getTotalPayMny()));
            if (vo.getOwedMny().compareTo(new BigDecimal("0E-8")) == 0) {
                vo.setOwedMny(BigDecimal.ZERO);
            }

            voList.add(vo);
        }

        if (mnyFlag == 0) {
            // 默认 支付金额 降序
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalPayMny).reversed()).limit(5).collect(Collectors.toList());
            BigDecimal sunMny = voList.stream().map(BlocKanBanVo::getTotalPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo vo : voList) {
                vo.setSupplierRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalPayMny(), sunMny), new BigDecimal("100")));
            }
        }else if (mnyFlag == 1) {
            // 合同总金额 降序
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalContractTaxMny).reversed()).limit(5).collect(Collectors.toList());
            BigDecimal sunMny = voList.stream().map(BlocKanBanVo::getTotalContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo vo : voList) {
                vo.setSupplierRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalContractTaxMny(), sunMny), new BigDecimal("100")));
            }
        }else {
            // 欠付金额 降序
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getOwedMny).reversed()).limit(5).collect(Collectors.toList());
            BigDecimal sunMny = voList.stream().map(BlocKanBanVo::getOwedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo vo : voList) {
                vo.setSupplierRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getOwedMny(), sunMny), new BigDecimal("100")));
            }
        }

        return CommonResponse.success("查询分包供应商top5成功", voList);
    }



}
