/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpDealMapper;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BondUpDealServiceImpl
extends BaseServiceImpl<BondUpDealMapper, BondUpDealEntity>
implements IBondUpDealService {
    private static final String BONGUP_DEAL = "BONGUP_DEAL";
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public BondUpDealVO insertOrUpdate(BondUpDealVO bondUpDealVO) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondUpDealVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGUP_DEAL, tenantId);
            if (billCode.isSuccess()) {
                bondUpDealVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondUpDealEntity entity = (BondUpDealEntity)((Object)BeanMapper.map((Object)bondUpDealVO, BondUpDealEntity.class));
        if (null != bondUpDealVO.getId() && bondUpDealVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondUpDealEntity::getBillCode, (Object)bondUpDealVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondUpDealVO.getId());
            entities = super.list((Wrapper)lambda);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(BondUpDealEntity::getDealStatus, (Object)"2");
            super.update((Wrapper)updateWrapper);
            entity.setId(null);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondUpDealEntity::getBillCode, (Object)bondUpDealVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondUpEntity::getBondStatus, (Object)"1");
        updateWrapper.set(BondUpEntity::getBeginDate, (Object)entity.getBeginDate());
        updateWrapper.set(BondUpEntity::getEndDate, (Object)entity.getEndDate());
        updateWrapper.set(BondUpEntity::getEmployeeId, (Object)entity.getEmployeeId());
        updateWrapper.set(BondUpEntity::getEmployeeName, (Object)entity.getEmployeeName());
        updateWrapper.set(BondUpEntity::getPayMny, (Object)entity.getBondMny());
        updateWrapper.set(BondUpEntity::getBondType, (Object)entity.getBondType());
        updateWrapper.set(BondUpEntity::getDealTime, (Object)entity.getDealTime());
        this.bondUpService.update((Wrapper)updateWrapper);
        return (BondUpDealVO)BeanMapper.map((Object)((Object)entity), BondUpDealVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = (BondUpEntity)((Object)this.bondUpService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondUpDealEntity::getBondId, (Object)id);
        lambda.orderBy(true, true, (Object[])new SFunction[]{BondUpDealEntity::getDealStatus});
        List list = super.list((Wrapper)lambda);
        vo = (BondUpDealRentVO)BeanMapper.map((Object)((Object)upEntity), BondUpDealRentVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setDealRecord(BeanMapper.mapList((Iterable)list, BondUpDealVO.class));
        }
        return vo;
    }
}

