/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller.api;

import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.vo.BlocKanBanVo;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.sub.api.ISubBlocKanBanApi;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/blocKanBan/"})
public class FinanceBlocKanBanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISubBlocKanBanApi subBlocKanBanApi;
    @Autowired
    private IPayContractService payContractService;

    @GetMapping(value={"querySupplierPayMny"})
    @ResponseBody
    public CommonResponse<List<BlocKanBanVo>> querySupplierPayMny(@RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="mnyFlag") Integer mnyFlag, @RequestParam(value="yearFlag") Integer yearFlag) {
        BigDecimal sunMny;
        if (orgId == null) {
            Long tenantid = InvocationInfoProxy.getTenantid();
            CommonResponse orgByTenantId = this.orgApi.findOrgByTenantId(tenantid);
            orgId = ((OrgVO)orgByTenantId.getData()).getId();
        }
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        CommonResponse mapCommonResponse = this.subBlocKanBanApi.queryExternalSupplierAndMny(null, yearFlag);
        if (!mapCommonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5206\u5305\u6570\u636e\u5931\u8d25");
        }
        Map map = (Map)mapCommonResponse.getData();
        ArrayList contractVOList = new ArrayList(map.values());
        List<Long> supplierIds = contractVOList.stream().map(ContractVO::getSupplierId).collect(Collectors.toList());
        List<PayContractVO> payContractVOList = this.payContractService.querySupplierPayMny(orgIds, supplierIds, yearFlag);
        Map payContractVOMap = payContractVOList.stream().collect(Collectors.toMap(PayContractVO::getReceiveUnitId, Function.identity()));
        HashSet set = new HashSet(map.keySet());
        set.addAll(payContractVOMap.keySet());
        List<Object> voList = new ArrayList();
        for (Long supplierId : set) {
            BlocKanBanVo blocKanBanVo = new BlocKanBanVo();
            blocKanBanVo.setReceiveUnitId(supplierId);
            if (map.containsKey(supplierId)) {
                blocKanBanVo.setReceiveUnitName(((ContractVO)map.get(supplierId)).getSupplierName());
                BigDecimal contractTaxMny = ((ContractVO)map.get(supplierId)).getContractTaxMny();
                contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
                blocKanBanVo.setTotalContractTaxMny(contractTaxMny);
            } else {
                blocKanBanVo.setTotalContractTaxMny(BigDecimal.ZERO);
            }
            if (payContractVOMap.containsKey(supplierId)) {
                blocKanBanVo.setReceiveUnitName(((PayContractVO)payContractVOMap.get(supplierId)).getReceiveUnitName());
                BigDecimal payMny = ((PayContractVO)payContractVOMap.get(supplierId)).getPayMny();
                payMny = payMny == null ? BigDecimal.ZERO : payMny;
                blocKanBanVo.setTotalPayMny(payMny);
            } else {
                blocKanBanVo.setTotalPayMny(BigDecimal.ZERO);
            }
            blocKanBanVo.setOwedMny(ComputeUtil.safeSub((BigDecimal)blocKanBanVo.getTotalContractTaxMny(), (BigDecimal)blocKanBanVo.getTotalPayMny()));
            if (blocKanBanVo.getOwedMny().compareTo(new BigDecimal("0E-8")) == 0) {
                blocKanBanVo.setOwedMny(BigDecimal.ZERO);
            }
            voList.add(blocKanBanVo);
        }
        if (mnyFlag == 0) {
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalPayMny).reversed()).limit(5L).collect(Collectors.toList());
            sunMny = voList.stream().map(BlocKanBanVo::getTotalPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo blocKanBanVo : voList) {
                blocKanBanVo.setSupplierRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)blocKanBanVo.getTotalPayMny(), (BigDecimal)sunMny), (BigDecimal)new BigDecimal("100")));
            }
        } else if (mnyFlag == 1) {
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalContractTaxMny).reversed()).limit(5L).collect(Collectors.toList());
            sunMny = voList.stream().map(BlocKanBanVo::getTotalContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo blocKanBanVo : voList) {
                blocKanBanVo.setSupplierRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)blocKanBanVo.getTotalContractTaxMny(), (BigDecimal)sunMny), (BigDecimal)new BigDecimal("100")));
            }
        } else {
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getOwedMny).reversed()).limit(5L).collect(Collectors.toList());
            sunMny = voList.stream().map(BlocKanBanVo::getOwedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo blocKanBanVo : voList) {
                blocKanBanVo.setSupplierRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)blocKanBanVo.getOwedMny(), (BigDecimal)sunMny), (BigDecimal)new BigDecimal("100")));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u4f9b\u5e94\u5546top5\u6210\u529f", voList);
    }
}

