/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayForegiftRecordEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.enums.ConstantTypeEnum;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadBackService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayForegiftRecordService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.util.CountCallable;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.ExpenditureVO;
import com.ejianc.business.finance.vo.IncomeVO;
import com.ejianc.business.finance.vo.ProjectLedgerVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/api/project/"})
public class ProjectBoardApi {
    private static Logger logger = LoggerFactory.getLogger(ProjectBoardApi.class);
    private static Calendar calendar = Calendar.getInstance();
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    @Autowired
    private IPayForegiftService foregiftService;
    @Autowired
    private IPayForegiftRecordService foregiftRecordService;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private ILoadBackService loadBackService;
    @Autowired
    private IBondDownService bondDownService;
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IReceiveService receiveService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"queryPayAndReceiveByProjectId"})
    CommonResponse<JSONObject> queryPayAndReceiveByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String authority = request.getHeader("authority");
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        QueryParam queryParam = this.getNewQueryParam(projectId);
        Future<JSONObject> future1 = this.excute(threadPool, queryParam, this.receiveService);
        Future<JSONObject> future2 = this.excute(threadPool, authority, "ejc-income-web/contract/pageList", queryParam);
        BigDecimal payMoney = this.getPayMny(projectId);
        BigDecimal receiveMoney = null;
        BigDecimal contractMoney = null;
        try {
            receiveMoney = this.getSumMny(future1.get(), "receiveMny");
            contractMoney = this.getSumMny(future2.get(), "contractTaxMny");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9879\u76ee\u6536\u4ed8\u6b3e\u4ee5\u53ca\u5408\u540c\u91d1\u989d\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        JSONObject resp = new JSONObject();
        resp.put("receiveMoney", (Object)this.roundTwoPre(receiveMoney));
        resp.put("payMoney", (Object)this.roundTwoPre(payMoney));
        resp.put("contractMoney", (Object)this.roundTwoPre(contractMoney));
        long endTime = System.currentTimeMillis();
        logger.info("queryPayAndReceiveByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"queryReceiveInfoByProjectId"})
    CommonResponse<JSONObject> queryReceiveInfoByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String authority = request.getHeader("authority");
        JSONObject latestCollection = this.getLatestCollection(projectId);
        JSONObject paymentBalance = this.getPaymentBalance(projectId, authority);
        JSONObject monthlyIncomeAndExpenditure = this.getMonthlyIncomeAndExpenditure(projectId);
        JSONObject depositLoanMargin = this.getDepositLoanMargin(projectId);
        JSONObject underInvoice = this.getUnderInvoice(projectId);
        JSONObject resp = new JSONObject();
        resp.put("latestCollection", (Object)latestCollection);
        resp.put("paymentBalance", (Object)paymentBalance);
        resp.put("monthlyIncomeAndExpenditure", (Object)monthlyIncomeAndExpenditure);
        resp.put("depositLoanMargin", (Object)depositLoanMargin);
        resp.put("underInvoice", (Object)underInvoice);
        long endTime = System.currentTimeMillis();
        logger.info("queryReceiveInfoByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"queryCostByProjectId"})
    public CommonResponse<JSONObject> queryCostByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String authority = request.getHeader("authority");
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam queryParam = this.getNewQueryParam(projectId);
        Future<JSONObject> future1 = this.excute(threadPool, authority, "ejc-cost-web/budgetProject/queryList", queryParam);
        Future<JSONObject> future2 = this.excute(threadPool, authority, "ejc-income-web/quote/pageList", queryParam);
        Future<JSONObject> future3 = this.excute(threadPool, authority, "ejc-sub-web/settle/queryList", queryParam);
        Future<JSONObject> future4 = this.excute(threadPool, authority, "ejc-sub-web/finish/queryList", queryParam);
        Future<JSONObject> future5 = this.excute(threadPool, authority, "ejc-material-web/purchaseSettlement/queryList", queryParam);
        Future<JSONObject> future6 = this.excute(threadPool, authority, "ejc-equipment-web/purchaseSettlement/pageList", queryParam);
        Future<JSONObject> future7 = this.excute(threadPool, authority, "ejc-equipment-web/rentSettlement/pageList", queryParam);
        Future<JSONObject> future12 = this.excute(threadPool, authority, "ejc-rmat-web/rentSettlement/pageList", queryParam);
        Future<JSONObject> future13 = this.excute(threadPool, authority, "ejc-other-web/otherSettle/pageList", queryParam);
        QueryParam queryParam2 = this.getNewQueryParam(projectId);
        queryParam2.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam2.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        Future<JSONObject> future9 = this.excute(threadPool, queryParam2, this.sporadicService);
        Future<JSONObject> future10 = this.excute(threadPool, queryParam2, this.reimburseService);
        QueryParam queryParam3 = this.getNewQueryParam(projectId);
        queryParam3.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        Future<JSONObject> future11 = this.excute(threadPool, queryParam3, this.loadReimburseService);
        BigDecimal generalBudget = null;
        BigDecimal settlementToParta = null;
        BigDecimal subcontractingCost = null;
        BigDecimal materialCost = null;
        BigDecimal mechanicsCost = null;
        BigDecimal indirectExpense = null;
        BigDecimal otherCost = null;
        LinkedHashMap<String, Map<String, BigDecimal>> monthMap = new LinkedHashMap<String, Map<String, BigDecimal>>();
        try {
            generalBudget = this.getSumMny(future1.get(), "budgetMny");
            settlementToParta = this.getSumMny(future2.get(), "quoteTaxMny");
            BigDecimal subSettleMny = this.getSumMny(future3.get(), "settleTaxMny");
            BigDecimal subFinishMny = this.getSumMny(future4.get(), "shouldPayTaxMny");
            BigDecimal materialMny = this.getSumMny(future5.get(), "currentSettlementAmountTax");
            BigDecimal equipmentMny = this.getSumMny(future6.get(), "settlementTaxMny");
            BigDecimal rentMny = this.getSumMny(future7.get(), "settlementTaxMny");
            BigDecimal sporadicMny = this.getSumMny(future9.get(), "payMny");
            BigDecimal reimburseMny = this.getSumMny(future10.get(), "payMny");
            BigDecimal loadReimburseMny = this.getSumMny(future11.get(), "reimburseMny");
            BigDecimal rmatMny = this.getSumMny(future12.get(), "settlementTaxMny");
            BigDecimal otherMny = this.getSumMny(future13.get(), "settleTaxMny");
            subcontractingCost = MathUtil.safeAdd((BigDecimal)subSettleMny, (BigDecimal)subFinishMny);
            materialCost = MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd((BigDecimal)materialMny, (BigDecimal)sporadicMny), (BigDecimal)rmatMny);
            mechanicsCost = MathUtil.safeAdd((BigDecimal)equipmentMny, (BigDecimal)rentMny);
            indirectExpense = MathUtil.safeAdd((BigDecimal)reimburseMny, (BigDecimal)loadReimburseMny);
            otherCost = otherMny;
            this.calculateCallableMny(monthMap, future3.get(), "settleDate", "shouldPayTaxMny");
            this.calculateCallableMny(monthMap, future4.get(), "settleDate", "settleTaxMny");
            this.calculateCallableMny(monthMap, future5.get(), "settlementDate", "currentSettlementAmountTax");
            this.calculateCallableMny(monthMap, future6.get(), "settlementDate", "settlementTaxMny");
            this.calculateCallableMny(monthMap, future7.get(), "settlementDate", "settlementTaxMny");
            this.calculateCallableMny(monthMap, future9.get(), "confirmTime", "payMny");
            this.calculateCallableMny(monthMap, future10.get(), "confirmTime", "payMny");
            this.calculateCallableMny(monthMap, future11.get(), "applyTime", "reimburseMny");
            this.calculateCallableMny(monthMap, future12.get(), "settlementDate", "settlementTaxMny");
            this.calculateCallableMny(monthMap, future13.get(), "signDate", "settleTaxMny");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        BigDecimal totalCost = MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd(subcontractingCost, materialCost), mechanicsCost), indirectExpense), otherCost);
        JSONObject data = new JSONObject();
        JSONObject target = new JSONObject();
        target.put("generalBudget", (Object)MathUtil.roundTwoPre((BigDecimal)generalBudget));
        target.put("settlementToParta", (Object)MathUtil.roundTwoPre((BigDecimal)settlementToParta));
        target.put("totalCost", (Object)MathUtil.roundTwoPre((BigDecimal)totalCost));
        JSONObject firstProcess = new JSONObject();
        firstProcess.put("process", (Object)MathUtil.roundTwoPre((BigDecimal)MathUtil.safeDiv((BigDecimal)totalCost, (BigDecimal)settlementToParta)));
        firstProcess.put("settlementBenefit", (Object)MathUtil.roundTwoPre((BigDecimal)MathUtil.safeSub((BigDecimal)settlementToParta, (BigDecimal)totalCost)));
        target.put("firstProcess", (Object)firstProcess);
        JSONObject secondProcess = new JSONObject();
        secondProcess.put("process", (Object)MathUtil.roundTwoPre((BigDecimal)MathUtil.safeDiv((BigDecimal)totalCost, (BigDecimal)generalBudget)));
        secondProcess.put("managementBenefit", (Object)MathUtil.roundTwoPre((BigDecimal)MathUtil.safeSub((BigDecimal)generalBudget, (BigDecimal)totalCost)));
        target.put("secondProcess", (Object)secondProcess);
        JSONObject costAnalysis = new JSONObject();
        costAnalysis.put("subcontractingCost", (Object)MathUtil.roundTwoPre((BigDecimal)subcontractingCost));
        costAnalysis.put("materialCost", (Object)MathUtil.roundTwoPre((BigDecimal)materialCost));
        costAnalysis.put("mechanicsCost", (Object)MathUtil.roundTwoPre((BigDecimal)mechanicsCost));
        costAnalysis.put("indirectExpense", (Object)MathUtil.roundTwoPre((BigDecimal)indirectExpense));
        costAnalysis.put("otherCost", (Object)MathUtil.roundTwoPre((BigDecimal)otherCost));
        target.put("costAnalysis", (Object)costAnalysis);
        JSONObject monthlyCost = new JSONObject();
        LinkedList<String> labelList = new LinkedList<String>();
        for (Object key : monthMap.keySet()) {
            labelList.add((String)key);
        }
        Collections.sort(labelList, new Comparator<String>(){

            @Override
            public int compare(String u1, String u2) {
                int diff = Integer.valueOf(u1.substring(0, u1.length() - 1)) - Integer.valueOf(u2.substring(0, u2.length() - 1));
                if (diff > 0) {
                    return 1;
                }
                if (diff < 0) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedList<BigDecimal> incomeList = new LinkedList<BigDecimal>();
        for (String key : labelList) {
            Map map = (Map)monthMap.get(key);
            incomeList.add(map.get("income") != null ? this.roundTwoPre((BigDecimal)map.get("income")) : new BigDecimal("0.00"));
        }
        monthlyCost.put("label", labelList);
        monthlyCost.put("income", incomeList);
        target.put("monthlyCost", (Object)monthlyCost);
        data.put("target", (Object)target);
        long endTime = System.currentTimeMillis();
        logger.info("queryCostByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)data);
    }

    private QueryParam getNewQueryParam(@RequestParam(value="projectId") Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        return queryParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"queryIncoemAndExpendByProjectId"})
    CommonResponse<JSONObject> queryIncoemAndExpendByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String authority = request.getHeader("authority");
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam queryParam = this.getNewQueryParam(projectId);
        queryParam.getOrderMap().put("createTime", "desc");
        Future<JSONObject> future1 = this.excute(threadPool, authority, "ejc-income-web/contract/pageList", queryParam);
        QueryParam queryParam2 = this.getNewQueryParam(projectId);
        Future<JSONObject> future2 = this.excute(threadPool, queryParam2, this.receiveService);
        Future<JSONObject> future3 = this.excute(threadPool, authority, "ejc-tax-web/invoiceOpen/pageList", queryParam2);
        QueryParam queryParam3 = this.getNewQueryParam(projectId);
        queryParam3.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        Future<JSONObject> future4 = this.excute(threadPool, authority, "ejc-tax-web/invoiceReceive/pageList", queryParam3);
        BigDecimal payMoney = this.getPayMny(projectId);
        BigDecimal receiveMoney = null;
        BigDecimal incomeContractTaxMny = null;
        BigDecimal incomeContractMny = null;
        BigDecimal incomeTaxRate = null;
        BigDecimal financeEngineReceiveMny = null;
        BigDecimal financeOtherReceiveMny = null;
        BigDecimal openInvoiceTaxMny = null;
        BigDecimal openInvoiceMny = null;
        BigDecimal openTaxMny = null;
        BigDecimal receiveSpecialInvoiceTaxMny = null;
        BigDecimal receiveSpecialInvoiceMny = null;
        BigDecimal receiveSpecialTaxMny = null;
        BigDecimal receiveGeneralInvoiceTaxMny = null;
        BigDecimal receiveGeneralInvoiceMny = null;
        BigDecimal receiveGeneralTaxMny = null;
        try {
            incomeContractTaxMny = this.getSumMny(future1.get(), "contractTaxMny");
            incomeContractMny = this.getSumMny(future1.get(), "contractMny");
            JSONArray jsonArray = future1.get().getJSONArray("records");
            if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
                JSONObject obj = jsonArray.getJSONObject(0);
                incomeTaxRate = obj.getBigDecimal("taxRate");
            }
            receiveMoney = this.getSumMny(future2.get(), "receiveMny");
            JSONArray receiveArray = future2.get().getJSONArray("records");
            if (CollectionUtils.isNotEmpty((Collection)receiveArray)) {
                for (int i = 0; i < receiveArray.size(); ++i) {
                    JSONObject obj = receiveArray.getJSONObject(i);
                    if (Long.valueOf("1275321308270993409").equals(obj.getLong("receiveType"))) {
                        financeEngineReceiveMny = MathUtil.safeAdd(financeEngineReceiveMny, (BigDecimal)obj.getBigDecimal("receiveMny"));
                    }
                    if (!Long.valueOf("1275321354706132993").equals(obj.getLong("receiveType"))) continue;
                    financeOtherReceiveMny = MathUtil.safeAdd(financeOtherReceiveMny, (BigDecimal)obj.getBigDecimal("receiveMny"));
                }
            }
            openInvoiceTaxMny = this.getSumMny(future3.get(), "invoiceTaxMny");
            openInvoiceMny = this.getSumMny(future3.get(), "invoiceMny");
            openTaxMny = this.getSumMny(future3.get(), "taxMny");
            JSONArray invoiceArray = future4.get().getJSONArray("records");
            if (CollectionUtils.isNotEmpty((Collection)invoiceArray)) {
                for (int i = 0; i < invoiceArray.size(); ++i) {
                    JSONObject obj = invoiceArray.getJSONObject(i);
                    if (Long.valueOf("1277537516768632833").equals(obj.getLong("invoiceType"))) {
                        receiveSpecialInvoiceTaxMny = MathUtil.safeAdd(receiveSpecialInvoiceTaxMny, (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                        receiveSpecialInvoiceMny = MathUtil.safeAdd(receiveSpecialInvoiceMny, (BigDecimal)obj.getBigDecimal("invoiceMny"));
                        receiveSpecialTaxMny = MathUtil.safeAdd(receiveSpecialTaxMny, (BigDecimal)obj.getBigDecimal("taxMny"));
                    }
                    if (!Long.valueOf("1277537563879055362").equals(obj.getLong("invoiceType"))) continue;
                    receiveGeneralInvoiceTaxMny = MathUtil.safeAdd(receiveGeneralInvoiceTaxMny, (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                    receiveGeneralInvoiceMny = MathUtil.safeAdd(receiveGeneralInvoiceMny, (BigDecimal)obj.getBigDecimal("invoiceMny"));
                    receiveGeneralTaxMny = MathUtil.safeAdd(receiveGeneralTaxMny, (BigDecimal)obj.getBigDecimal("taxMny"));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9879\u76ee\u6536\u4ed8\u6b3e\u4ee5\u53ca\u5408\u540c\u91d1\u989d\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        JSONObject resp = new JSONObject();
        resp.put("receiveMoney", receiveMoney);
        resp.put("payMoney", (Object)payMoney);
        resp.put("incomeContractTaxMny", (Object)incomeContractTaxMny);
        resp.put("incomeContractMny", (Object)incomeContractMny);
        resp.put("incomeTaxRate", (Object)incomeTaxRate);
        resp.put("financeEngineReceiveMny", financeEngineReceiveMny);
        resp.put("financeOtherReceiveMny", financeOtherReceiveMny);
        resp.put("openInvoiceTaxMny", (Object)openInvoiceTaxMny);
        resp.put("openInvoiceMny", (Object)openInvoiceMny);
        resp.put("openTaxMny", (Object)openTaxMny);
        resp.put("receiveSpecialInvoiceTaxMny", receiveSpecialInvoiceTaxMny);
        resp.put("receiveSpecialInvoiceMny", receiveSpecialInvoiceMny);
        resp.put("receiveSpecialTaxMny", receiveSpecialTaxMny);
        resp.put("receiveGeneralInvoiceTaxMny", receiveGeneralInvoiceTaxMny);
        resp.put("receiveGeneralInvoiceMny", receiveGeneralInvoiceMny);
        resp.put("receiveGeneralTaxMny", receiveGeneralTaxMny);
        long endTime = System.currentTimeMillis();
        logger.info("queryIncoemAndExpendByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"getProjectLedgerVO"})
    public CommonResponse<ProjectLedgerVO> getProjectLedgerVO(@RequestBody QueryParam param) throws ExecutionException, InterruptedException {
        ProjectLedgerVO projectLedgerVO = new ProjectLedgerVO();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.setPageIndex(0);
        param.setPageSize(-1);
        Parameter startDay = (Parameter)param.getParams().get("startDay");
        Parameter endDay = (Parameter)param.getParams().get("endDay");
        param.getParams().remove("startDay");
        param.getParams().remove("endDay");
        List expenditureList = this.queryExpenditureList(param, startDay, endDay).stream().filter(vo -> vo.getApplyTime() != null).sorted(Comparator.comparing(ExpenditureVO::getApplyTime).reversed()).collect(Collectors.toList());
        BigDecimal sumPayMny = expenditureList.stream().filter(vo -> vo.getPayMny() != null).map(ExpenditureVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<IncomeVO> incomeList = this.queryIncomeList(param, startDay, endDay);
        BigDecimal sumReceiveMny = incomeList.stream().filter(vo -> vo.getReceiveMny() != null).map(IncomeVO::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal bookFunds = sumReceiveMny.subtract(sumPayMny);
        projectLedgerVO.setProjectId(Long.getLong(((Parameter)param.getParams().get("projectId")).getValue().toString()));
        projectLedgerVO.setSumReceiveMny(sumReceiveMny);
        projectLedgerVO.setSumPayMny(sumPayMny);
        projectLedgerVO.setBookFunds(bookFunds);
        projectLedgerVO.setExpenditureList(expenditureList);
        projectLedgerVO.setIncomeList(incomeList);
        if (CollectionUtils.isNotEmpty(expenditureList) && CollectionUtils.isNotEmpty(incomeList)) {
            projectLedgerVO.setProjectName(((ExpenditureVO)expenditureList.get(0)).getProjectName());
        } else if (CollectionUtils.isNotEmpty(expenditureList)) {
            projectLedgerVO.setProjectName(((ExpenditureVO)expenditureList.get(0)).getProjectName());
        } else if (CollectionUtils.isNotEmpty(incomeList)) {
            projectLedgerVO.setProjectName(incomeList.get(0).getProjectName());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)projectLedgerVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExpenditureVO> queryExpenditureList(QueryParam param, Parameter startDay, Parameter endDay) {
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        if (startDay != null && endDay != null) {
            param.getParams().put("applyTime", new Parameter("between", (Object)(startDay.getValue() + "," + endDay.getValue())));
        } else if (startDay != null) {
            param.getParams().put("applyTime", new Parameter("ge", startDay.getValue()));
        } else if (endDay != null) {
            param.getParams().put("applyTime", new Parameter("le", endDay.getValue()));
        }
        QueryParam queryParam = (QueryParam)Utils.deepCopy((Object)param);
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        Future<JSONObject> future1 = this.excute(threadPool, queryParam, this.contractService);
        Future<JSONObject> future2 = this.excute(threadPool, queryParam, this.sporadicService);
        Future<JSONObject> future3 = this.excute(threadPool, queryParam, this.reimburseService);
        QueryParam queryParam2 = (QueryParam)Utils.deepCopy((Object)param);
        queryParam2.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        Future<JSONObject> future4 = this.excute(threadPool, queryParam2, this.loadReimburseService);
        ArrayList list = new ArrayList();
        try {
            JSONArray sporadicJsonArray;
            List sporadicEntityList;
            List sporadicList;
            List payContList = BeanMapper.mapList((Iterable)future1.get().getJSONArray("records"), ExpenditureVO.class);
            if (CollectionUtils.isNotEmpty((Collection)payContList)) {
                payContList.forEach(vo -> vo.setFeeTypeName("\u5408\u540c\u4ed8\u6b3e-" + ConstantTypeEnum.getEnumByCode(vo.getFeeType()).getName()));
                list.addAll(payContList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(sporadicList = BeanMapper.mapList((Iterable)(sporadicEntityList = JSONObject.parseArray((String)(sporadicJsonArray = future2.get().getJSONArray("records")).toJSONString(), PaySporadicEntity.class)), ExpenditureVO.class)))) {
                sporadicList.forEach(vo -> {
                    vo.setFeeTypeName("\u96f6\u661f\u91c7\u8d2d");
                    sporadicEntityList.forEach(entity -> {
                        if (StringUtils.equals((String)vo.getBillCode(), (String)entity.getBillCode())) {
                            vo.setAccountName(entity.getAccountName());
                        }
                    });
                });
                list.addAll(sporadicList);
            }
            List reimburseList = BeanMapper.mapList((Iterable)future3.get().getJSONArray("records"), ExpenditureVO.class);
            list.addAll(reimburseList);
            JSONArray loadReimburseJsonArray = future4.get().getJSONArray("records");
            List loadReimburseEntityList = JSONObject.parseArray((String)loadReimburseJsonArray.toJSONString(), LoadReimburseEntity.class);
            List loadReimburseList = BeanMapper.mapList((Iterable)loadReimburseEntityList, ExpenditureVO.class);
            if (CollectionUtils.isNotEmpty((Collection)loadReimburseList)) {
                loadReimburseList.forEach(vo -> {
                    vo.setFeeTypeName("\u501f\u6b3e\u62a5\u9500");
                    loadReimburseEntityList.forEach(entity -> {
                        if (StringUtils.equals((String)vo.getBillCode(), (String)entity.getBillCode())) {
                            vo.setPayMny(entity.getReimburseMny());
                            vo.setApplyUserName(entity.getApplyEmployeeName());
                        }
                    });
                });
                list.addAll(loadReimburseList);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        return list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ExpenditureVO>(Comparator.comparing(ExpenditureVO::getBillCode))), ArrayList::new));
    }

    private List<IncomeVO> queryIncomeList(QueryParam param, Parameter startDay, Parameter endDay) {
        param.getParams().remove("applyTime");
        param.getOrderMap().put("confirmTime", "desc");
        if (startDay != null && endDay != null) {
            param.getParams().put("confirmTime", new Parameter("between", (Object)(startDay.getValue() + "," + endDay.getValue())));
        } else if (startDay != null) {
            param.getParams().put("confirmTime", new Parameter("ge", startDay.getValue()));
        } else if (endDay != null) {
            param.getParams().put("confirmTime", new Parameter("le", endDay.getValue()));
        }
        List list = this.receiveService.queryList(param, false);
        return BeanMapper.mapList((Iterable)list, IncomeVO.class);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) throws ExecutionException, InterruptedException {
        CommonResponse<ProjectLedgerVO> commonResponse = this.getProjectLedgerVO(param);
        if (commonResponse.isSuccess() && commonResponse.getData() != null) {
            HashMap<String, List> beans = new HashMap<String, List>();
            ProjectLedgerVO data = (ProjectLedgerVO)commonResponse.getData();
            List expenditureList = data.getExpenditureList();
            List incomeList = data.getIncomeList();
            beans.put("expend", expenditureList);
            beans.put("income", incomeList);
            ExcelExport.getInstance().export("expend-income-export.xlsx", beans, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getPayMny(Long projectId) {
        QueryParam queryParam = this.getNewQueryParam(projectId);
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        Future<JSONObject> future1 = this.excute(threadPool, queryParam, this.contractService);
        Future<JSONObject> future2 = this.excute(threadPool, queryParam, this.sporadicService);
        Future<JSONObject> future3 = this.excute(threadPool, queryParam, this.reimburseService);
        QueryParam param = (QueryParam)Utils.deepCopy((Object)queryParam);
        param.getParams().remove("payStatus");
        Future<JSONObject> future4 = this.excute(threadPool, param, this.loadReimburseService);
        BigDecimal payMoney = null;
        try {
            JSONObject c1 = future1.get();
            BigDecimal payContMny = this.getSumMny(c1, "payMny");
            JSONObject c2 = future2.get();
            BigDecimal sporadicMny = this.getSumMny(c2, "payMny");
            JSONObject c3 = future3.get();
            BigDecimal reimburseMny = this.getSumMny(c3, "payMny");
            JSONObject c4 = future4.get();
            BigDecimal loadReimburseMny = this.getSumMny(c4, "reimburseMny");
            payMoney = MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd((BigDecimal)payContMny, (BigDecimal)sporadicMny), (BigDecimal)reimburseMny), (BigDecimal)loadReimburseMny);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        return payMoney;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getPaymentBalance(Long projectId, String authority) {
        ExecutorService threadPool = Executors.newFixedThreadPool(3);
        QueryParam queryParam = this.getNewQueryParam(projectId);
        Future<JSONObject> future1 = this.excute(threadPool, queryParam, this.receiveService);
        Future<JSONObject> future2 = this.excute(threadPool, authority, "ejc-tax-web/invoiceOpen/pageList", queryParam);
        QueryParam queryParam2 = this.getNewQueryParam(projectId);
        queryParam2.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        Future<JSONObject> future3 = this.excute(threadPool, authority, "ejc-tax-web/invoiceReceive/pageList", queryParam2);
        BigDecimal salesInvoice = null;
        BigDecimal inputInvoice = null;
        BigDecimal receiveMoney = null;
        BigDecimal payMoney = this.getPayMny(projectId);
        BigDecimal balanceMny = null;
        try {
            receiveMoney = this.getSumMny(future1.get(), "receiveMny");
            balanceMny = MathUtil.safeSub((BigDecimal)receiveMoney, (BigDecimal)payMoney);
            salesInvoice = this.getSumMny(future2.get(), "invoiceTaxMny");
            inputInvoice = this.getSumMny(future3.get(), "invoiceTaxMny");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        JSONObject paymentBalance = new JSONObject();
        paymentBalance.put("paymentBalance", (Object)this.roundTwoPre(balanceMny));
        paymentBalance.put("projectCollection", (Object)this.roundTwoPre(receiveMoney));
        paymentBalance.put("projectExpenditure", (Object)this.roundTwoPre(payMoney));
        paymentBalance.put("salesInvoice", (Object)this.roundTwoPre(salesInvoice));
        paymentBalance.put("inputInvoice", (Object)this.roundTwoPre(inputInvoice));
        return paymentBalance;
    }

    private JSONObject getLatestCollection(Long projectId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ReceiveEntity::getProjectId, (Object)projectId);
        lambda.in(ReceiveEntity::getBillState, new Object[]{1, 3});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List list = this.receiveService.list((Wrapper)lambda);
        String collectionDate = null;
        String collectionType = null;
        BigDecimal money = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ReceiveEntity entity = (ReceiveEntity)((Object)list.get(0));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            collectionDate = sdf.format(entity.getConfirmTime());
            CommonResponse defResp = this.defdocApi.getDefDocByDefId(Long.valueOf(330358772148207658L));
            if (!defResp.isSuccess()) {
                logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6863\u6848\u5217\u8868\u5931\u8d25\uff1a{}", (Object)defResp.getMsg());
            }
            for (DefdocDetailVO vo : (List)defResp.getData()) {
                if (!vo.getId().equals(entity.getReceiveType())) continue;
                collectionType = vo.getName();
            }
            money = entity.getReceiveMny();
        }
        JSONObject latestCollection = new JSONObject();
        latestCollection.put("collectionDate", collectionDate);
        latestCollection.put("collectionType", collectionType);
        latestCollection.put("money", (Object)MathUtil.roundTwoPre(money));
        return latestCollection;
    }

    public JSONObject getMonthlyIncomeAndExpenditure(Long projectId) {
        QueryParam queryParam = this.getNewQueryParam(projectId);
        List receiveEntities = this.receiveService.queryList(queryParam, false);
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        List contractEntities = this.contractService.queryList(queryParam, false);
        List paySporadicEntities = this.sporadicService.queryList(queryParam, false);
        List reimburseEntities = this.reimburseService.queryList(queryParam, false);
        queryParam.getParams().remove("payStatus");
        List loadReimburseEntities = this.loadReimburseService.queryList(queryParam, false);
        LinkedHashMap<String, Map<String, BigDecimal>> monthMap = new LinkedHashMap<String, Map<String, BigDecimal>>();
        if (ListUtil.isNotEmpty((List)receiveEntities)) {
            for (Object entity : receiveEntities) {
                this.calculateSumMny(monthMap, ((ReceiveEntity)((Object)entity)).getConfirmTime(), "income", ((ReceiveEntity)((Object)entity)).getReceiveMny());
            }
        }
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            Iterator mnyMap = new HashMap();
            for (Object entity : contractEntities) {
                this.calculateSumMny(monthMap, ((PayContractEntity)((Object)entity)).getConfirmTime(), "expenditure", ((PayContractEntity)((Object)entity)).getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)paySporadicEntities)) {
            for (Object entity : paySporadicEntities) {
                this.calculateSumMny(monthMap, ((PaySporadicEntity)((Object)entity)).getConfirmTime(), "expenditure", ((PaySporadicEntity)((Object)entity)).getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)reimburseEntities)) {
            for (Object entity : reimburseEntities) {
                this.calculateSumMny(monthMap, ((PayReimburseEntity)((Object)entity)).getConfirmTime(), "expenditure", ((PayReimburseEntity)((Object)entity)).getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)loadReimburseEntities)) {
            for (Object entity : loadReimburseEntities) {
                this.calculateSumMny(monthMap, ((LoadReimburseEntity)((Object)entity)).getApplyTime(), "expenditure", ((LoadReimburseEntity)((Object)entity)).getReimburseMny());
            }
        }
        JSONObject back = new JSONObject();
        LinkedList<String> labelList = new LinkedList<String>();
        for (String key : monthMap.keySet()) {
            labelList.add(key);
        }
        Collections.sort(labelList, new Comparator<String>(){

            @Override
            public int compare(String u1, String u2) {
                int diff = Integer.valueOf(u1.substring(0, u1.length() - 1)) - Integer.valueOf(u2.substring(0, u2.length() - 1));
                if (diff > 0) {
                    return 1;
                }
                if (diff < 0) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedList<BigDecimal> incomeList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> expenditureList = new LinkedList<BigDecimal>();
        for (String key : labelList) {
            Map map = (Map)monthMap.get(key);
            incomeList.add(map.get("income") != null ? this.roundTwoPre((BigDecimal)map.get("income")) : new BigDecimal("0.00"));
            expenditureList.add(map.get("expenditure") != null ? this.roundTwoPre((BigDecimal)map.get("expenditure")) : new BigDecimal("0.00"));
        }
        back.put("label", labelList);
        back.put("income", incomeList);
        back.put("expenditure", expenditureList);
        return back;
    }

    public JSONObject getDepositLoanMargin(Long projectId) {
        List foregiftRecordEntities;
        QueryParam queryParam = this.getNewQueryParam(projectId);
        List foregiftEntities = this.foregiftService.queryList(queryParam, false);
        BigDecimal sumPayMny = null;
        if (CollectionUtils.isNotEmpty((Collection)foregiftEntities)) {
            for (PayForegiftEntity vo : foregiftEntities) {
                sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)vo.getPayMny());
            }
        }
        List foregiftIds = foregiftEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        BigDecimal sumReturnMny = null;
        if (CollectionUtils.isNotEmpty(foregiftIds) && CollectionUtils.isNotEmpty((Collection)(foregiftRecordEntities = this.foregiftRecordService.list((Wrapper)new QueryWrapper().in((Object)"payapply_id", foregiftIds))))) {
            for (PayForegiftRecordEntity vo : foregiftRecordEntities) {
                sumReturnMny = MathUtil.safeAdd(sumReturnMny, (BigDecimal)vo.getReturnMny());
            }
        }
        BigDecimal uncollectedDeposit = MathUtil.safeSub((BigDecimal)sumPayMny, sumReturnMny);
        List loadApplyEntities = this.loadApplyService.queryList(queryParam, false);
        BigDecimal sumApplyMny = null;
        if (CollectionUtils.isNotEmpty((Collection)loadApplyEntities)) {
            for (LoadApplyEntity vo : loadApplyEntities) {
                sumApplyMny = MathUtil.safeAdd(sumApplyMny, (BigDecimal)vo.getApplyMny());
            }
        }
        List loadReimburseEntities = this.loadReimburseService.queryList(queryParam, false);
        BigDecimal sumReimburseMny = null;
        if (CollectionUtils.isNotEmpty((Collection)loadReimburseEntities)) {
            for (LoadReimburseEntity vo : loadReimburseEntities) {
                sumReimburseMny = MathUtil.safeAdd(sumReimburseMny, (BigDecimal)vo.getReimburseMny());
            }
        }
        List loadBackEntities = this.loadBackService.queryList(queryParam, false);
        BigDecimal sumBackMny = null;
        if (CollectionUtils.isNotEmpty((Collection)loadBackEntities)) {
            for (LoadBackEntity vo : loadBackEntities) {
                sumBackMny = MathUtil.safeAdd(sumBackMny, (BigDecimal)vo.getBackMny());
            }
        }
        BigDecimal uncollectedLoan = MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)sumApplyMny, sumReimburseMny), sumBackMny);
        List bondDownEntities = this.bondDownService.queryList(queryParam, false);
        BigDecimal depositReturned = null;
        if (CollectionUtils.isNotEmpty((Collection)bondDownEntities)) {
            for (BondDownEntity vo : bondDownEntities) {
                depositReturned = MathUtil.safeAdd(depositReturned, (BigDecimal)MathUtil.safeSub((BigDecimal)vo.getPayMny(), (BigDecimal)vo.getBackMny()));
            }
        }
        List bondUpEntities = this.bondUpService.queryList(queryParam, false);
        BigDecimal uncollectedMargin = null;
        if (CollectionUtils.isNotEmpty((Collection)bondUpEntities)) {
            for (BondUpEntity vo : bondUpEntities) {
                uncollectedMargin = MathUtil.safeAdd(uncollectedMargin, (BigDecimal)MathUtil.safeSub((BigDecimal)vo.getPayMny(), (BigDecimal)vo.getBackMny()));
            }
        }
        JSONObject back = new JSONObject();
        back.put("uncollectedDeposit", (Object)this.roundTwoPre(uncollectedDeposit));
        back.put("uncollectedLoan", (Object)this.roundTwoPre(uncollectedLoan));
        back.put("depositReturned", (Object)this.roundTwoPre(depositReturned));
        back.put("uncollectedMargin", (Object)this.roundTwoPre(uncollectedMargin));
        return back;
    }

    public JSONObject getUnderInvoice(Long projectId) {
        QueryParam queryParam = this.getNewQueryParam(projectId);
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("contractId", new Parameter("ne", null));
        CommonResponse resp = this.invoiceApi.getReceiveListByQueryParam(queryParam);
        JSONArray jsonArray = new JSONArray();
        if (!resp.isSuccess() || resp.getData() == null) {
            logger.error("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff1a{}", (Object)resp.getMsg());
        } else {
            jsonArray = ((JSONObject)resp.getData()).getJSONArray("records");
        }
        HashMap<Long, JSONObject> map = new HashMap<Long, JSONObject>();
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject vo = jsonArray.getJSONObject(i);
                BigDecimal invoiceTaxMny = vo.getBigDecimal("invoiceTaxMny");
                this.calculateSumMnyBySupplierId(map, vo.getLong("supplierId"), invoiceTaxMny, vo.getString("supplierName"), false);
            }
        }
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        List contractEntities = this.contractService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)contractEntities)) {
            for (PayContractEntity vo : contractEntities) {
                this.calculateSumMnyBySupplierId(map, vo.getReceiveUnitId(), vo.getPayMny(), vo.getReceiveUnitName(), true);
            }
        }
        Iterator it = map.entrySet().iterator();
        BigDecimal accumulatedUnderInvoice = null;
        while (it.hasNext()) {
            BigDecimal amountOwed = ((JSONObject)it.next().getValue()).getBigDecimal("amountOwed");
            BigDecimal bigDecimal = amountOwed = amountOwed != null ? amountOwed : BigDecimal.ZERO;
            if (amountOwed.compareTo(BigDecimal.ZERO) <= 0) {
                it.remove();
                continue;
            }
            accumulatedUnderInvoice = MathUtil.safeAdd(accumulatedUnderInvoice, (BigDecimal)amountOwed);
        }
        ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
        for (Long key : map.keySet()) {
            JSONObject value = (JSONObject)map.get(key);
            BigDecimal amountOwed = value.getBigDecimal("amountOwed") != null ? value.getBigDecimal("amountOwed") : BigDecimal.ZERO;
            BigDecimal proportion = MathUtil.safeDiv((BigDecimal)amountOwed, (BigDecimal)accumulatedUnderInvoice);
            value.put("amountOwed", (Object)this.roundTwoPre(amountOwed));
            value.put("proportion", (Object)(proportion == null ? new BigDecimal("0.0000") : proportion.setScale(4, 6)));
            dataList.add(value);
        }
        Collections.sort(dataList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                BigDecimal mny1 = o1.getBigDecimal("amountOwed");
                BigDecimal mny2 = o2.getBigDecimal("amountOwed");
                return mny1.compareTo(mny2);
            }
        });
        Collections.reverse(dataList);
        dataList = dataList.size() > 5 ? dataList.subList(0, 5) : dataList;
        JSONArray array = JSONArray.parseArray((String)JSON.toJSONString(dataList));
        JSONObject back = new JSONObject();
        back.put("accumulatedUnderInvoice", (Object)this.roundTwoPre(accumulatedUnderInvoice != null ? accumulatedUnderInvoice : BigDecimal.ZERO));
        back.put("list", (Object)array);
        return back;
    }

    private BigDecimal getSumMny(CommonResponse<JSONObject> resp, String records, String field) {
        JSONArray jsonArray = new JSONArray();
        if (!resp.isSuccess() || resp.getData() == null) {
            logger.error("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff1a{}", (Object)resp.getMsg());
        } else {
            logger.info("\u67e5\u8be2\u5217\u8868\u7ed3\u679c\uff1a{}", resp);
            jsonArray = ((JSONObject)resp.getData()).getJSONArray(records);
        }
        BigDecimal sumMny = null;
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                sumMny = MathUtil.safeAdd(sumMny, (BigDecimal)obj.getBigDecimal(field));
            }
        }
        return sumMny;
    }

    private BigDecimal getSumMny(JSONObject json, String field) {
        JSONArray jsonArray = json.getJSONArray("records");
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return null;
        }
        BigDecimal sumMny = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            sumMny = MathUtil.safeAdd(sumMny, (BigDecimal)obj.getBigDecimal(field));
        }
        return sumMny;
    }

    private void calculateCallableMny(Map<String, Map<String, BigDecimal>> monthMap, JSONObject json, String dateField, String mnyField) {
        JSONArray jsonArray = json.getJSONArray("records");
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                this.calculateSumMny(monthMap, obj.getDate(dateField), "income", obj.getBigDecimal(mnyField));
            }
        }
    }

    private void calculateSumMny(Map<String, Map<String, BigDecimal>> monthMap, Date date, String key, BigDecimal value) {
        calendar.setTime(date);
        String month = calendar.get(2) + 1 + "\u6708";
        Map<Object, Object> mnyMap = new HashMap();
        BigDecimal mny = null;
        if (monthMap.containsKey(month)) {
            mnyMap = monthMap.get(month);
            mny = MathUtil.safeAdd((BigDecimal)((BigDecimal)mnyMap.get(key)), (BigDecimal)value);
            mnyMap.put(key, mny);
        } else {
            mnyMap = new HashMap();
            mnyMap.put(key, value);
        }
        monthMap.put(month, mnyMap);
    }

    private void calculateSumMnyBySupplierId(Map<Long, JSONObject> map, Long supplierId, BigDecimal mny, String supplierName, Boolean flag) {
        JSONObject data = new JSONObject();
        BigDecimal amountOwed = null;
        if (map.containsKey(supplierId)) {
            data = map.get(supplierId);
            amountOwed = flag.booleanValue() ? MathUtil.safeAdd((BigDecimal)data.getBigDecimal("amountOwed"), (BigDecimal)mny) : MathUtil.safeSub((BigDecimal)data.getBigDecimal("amountOwed"), (BigDecimal)mny);
        } else {
            amountOwed = flag != false ? MathUtil.safeAdd((BigDecimal)BigDecimal.ZERO, (BigDecimal)mny) : MathUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)mny);
        }
        data.put("amountOwed", (Object)amountOwed);
        data.put("supplierName", (Object)supplierName);
        map.put(supplierId, data);
    }

    private Future<JSONObject> excute(ExecutorService threadPool, String authority, String url, QueryParam queryParam) {
        CountCallable callable = new CountCallable(RequestContextHolder.getRequestAttributes(), authority, this.BASE_HOST + url, queryParam, null);
        Future<JSONObject> future = threadPool.submit(callable);
        return future;
    }

    private Future<JSONObject> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        CountCallable callable = new CountCallable(RequestContextHolder.getRequestAttributes(), null, null, queryParam, service);
        Future<JSONObject> future = threadPool.submit(callable);
        return future;
    }

    public BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? new BigDecimal("0.00") : src.setScale(2, 6);
    }
}

