/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpBackMapper;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.RecBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.RecBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BondUpBackServiceImpl
extends BaseServiceImpl<BondUpBackMapper, BondUpBackEntity>
implements IBondUpBackService {
    private static final String BONGUP_BACK = "BONGUP_BACK";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private NCUtil ncUtil;

    @Override
    public BondUpBackVO insertOrUpdate(BondUpBackVO bondUpBackVO) {
        BigDecimal applyMny;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondUpBackVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGUP_BACK, tenantId);
            if (billCode.isSuccess()) {
                bondUpBackVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondUpBackEntity entity = (BondUpBackEntity)((Object)BeanMapper.map((Object)bondUpBackVO, BondUpBackEntity.class));
        if (null != bondUpBackVO.getId() && bondUpBackVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondUpBackEntity::getBillCode, (Object)bondUpBackVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondUpBackVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondUpBackEntity::getBillCode, (Object)bondUpBackVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBackTime(new Date());
        super.saveOrUpdate((Object)entity, false);
        BondUpEntity upentity = (BondUpEntity)((Object)this.bondUpService.selectById(bondUpBackVO.getBondId()));
        BigDecimal sumBackMny = upentity.getBackMny() == null ? BigDecimal.ZERO : upentity.getBackMny();
        BigDecimal bigDecimal = applyMny = upentity.getApplyMny() == null ? BigDecimal.ZERO : upentity.getApplyMny();
        if (applyMny.compareTo(sumBackMny.add(entity.getBackMny())) < 0) {
            throw new BusinessException("\u672c\u6b21\u9000\u8fd8\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u91d1\u989d!");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondUpEntity::getBackMny, (Object)sumBackMny.add(entity.getBackMny()));
        this.bondUpService.update((Wrapper)updateWrapper);
        this.pushToNC(upentity, entity);
        return (BondUpBackVO)BeanMapper.map((Object)((Object)entity), BondUpBackVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = (BondUpEntity)((Object)this.bondUpService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondUpBackEntity::getBondId, (Object)id);
        lambda.orderBy(true, false, (Object[])new SFunction[]{BondUpBackEntity::getBackTime});
        List list = super.list((Wrapper)lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny() == null ? BigDecimal.ZERO : upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny() == null ? BigDecimal.ZERO : upEntity.getContractTaxMny());
        vo.setBackMny(upEntity.getBackMny() == null ? BigDecimal.ZERO : upEntity.getBackMny());
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setBackRecord(BeanMapper.mapList((Iterable)list, BondUpBackVO.class));
        }
        return vo;
    }

    private void pushToNC(BondUpEntity entity, BondUpBackEntity bondUpBackEntity) {
        RecBillVO vo = this.transferToNCVO(entity, bondUpBackEntity);
        StringBuffer sb = new StringBuffer();
        if (entity.getApplyOrgId().equals(entity.getActualOrgId())) {
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            sb.append(sourceId);
        } else {
            String sourceId1 = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            vo.setPk_org(this.ncUtil.queryOrgById(entity.getActualOrgId()).getCode());
            BankAccountVO bankAccountVO2 = this.ncUtil.queryDefaultBankAccountById(entity.getActualOrgId(), "insideOrgId");
            RecBillDetailVO recBillDetailVO2 = (RecBillDetailVO)vo.getDetail().get(0);
            recBillDetailVO2.setBankaccount(bankAccountVO2.getBankCode());
            String sourceId2 = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            sb.append(sourceId1).append(",").append(sourceId2);
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(BondUpEntity::getSourceBackId, (Object)sb.toString());
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.bondUpService.update((Wrapper)wrapper);
    }

    private RecBillVO transferToNCVO(BondUpEntity entity, BondUpBackEntity bondUpBackEntity) {
        this.logger.info("----\u6536\u6b3e\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = this.ncUtil.queryOrgById(project.getOrgId());
        CustomerVO customerVO = this.ncUtil.queryCustomerById(bondUpBackEntity.getCustomerId());
        RecBillVO vo = new RecBillVO();
        vo.setBusitype("recbill");
        vo.setTradetype("F2-Cxx-002");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setPk_org(this.ncUtil.queryOrgById(entity.getActualOrgId()).getCode());
        vo.setPk_customer(String.valueOf(bondUpBackEntity.getCustomerId()));
        vo.setDef6(Boolean.valueOf(customerVO.getInsideOrgId() != null));
        DefdocDetailVO defDocById = this.ncUtil.getDefDocById(entity.getPaymentWay());
        vo.setBalatype(defDocById.getCode());
        ArrayList<RecBillDetailVO> detailVOS = new ArrayList<RecBillDetailVO>();
        RecBillDetailVO detailVO = new RecBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setLocal_mny(bondUpBackEntity.getBackMny());
        BankAccountVO bankAccountVO = this.ncUtil.queryDefaultBankAccountById(entity.getApplyOrgId(), "insideOrgId");
        detailVO.setBankaccount(bankAccountVO.getBankCode());
        detailVO.setCashitem(this.ncUtil.getDefDocById(entity.getCashItemId()).getCode());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }
}

