/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BondDownVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bondDown"})
public class BondDownController {
    @Autowired
    private IBondDownService bondDownService;
    @Autowired
    private IBondDownDealService bondDownDealService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BondDownVO> saveOrDowndate(@RequestBody BondDownVO bondDownVO) {
        return this.bondDownService.insertOrUpdate(bondDownVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BondDownVO> queryDetail(Long id) {
        BondDownVO backVO = this.bondDownService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = (Parameter)param.getParams().get("backType");
        Parameter payType = (Parameter)param.getParams().get("payType");
        param.getParams().remove("backType");
        param.getParams().remove("payType");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (null != backType && "1".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)", new Object[0]);
        } else if (null != backType && "2".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)", new Object[0]);
        }
        if (null != payType && "1".equals(payType.getValue())) {
            wrapper.apply("IFNULL(pay_mny,0) <= 0", new Object[0]);
        } else if (null != payType && "2".equals(payType.getValue())) {
            wrapper.apply("IFNULL(pay_mny,0) > 0", new Object[0]);
        }
        IPage<BondDownEntity> pageData = this.bondDownService.selectPage(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), BondDownVO.class));
        res.put("total", (Object)pageData.getTotal());
        res.put("current", (Object)pageData.getCurrent());
        res.put("size", (Object)pageData.getSize());
        res.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryListManage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListManage(@RequestBody QueryParam param) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", (Object)"1"));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = (Parameter)param.getParams().get("backType");
        Parameter bondState = (Parameter)param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        NCUtil.voucherParam(param);
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (null != backType && "1".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)", new Object[0]);
        } else if (null != backType && "2".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)", new Object[0]);
        }
        if (null != bondState && "1".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() <= end_date", new Object[0]);
        } else if (null != bondState && "2".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() > end_date", new Object[0]);
        }
        IPage<BondDownEntity> pageData = this.bondDownService.selectPage(page, wrapper);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), BondDownVO.class);
            list.forEach(vo -> {
                if (new Date().after(vo.getEndDate())) {
                    vo.setDealStatus("\u5df2\u5230\u671f");
                } else {
                    vo.setDealStatus("\u6709\u6548");
                }
            });
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)pageData.getTotal());
        res.put("current", (Object)pageData.getCurrent());
        res.put("size", (Object)pageData.getSize());
        res.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BondDownVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.bondDownService.removeByIds(ids, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = (Parameter)param.getParams().get("backType");
        Parameter payType = (Parameter)param.getParams().get("payType");
        param.getParams().remove("backType");
        param.getParams().remove("payType");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (null != backType && "1".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)", new Object[0]);
        } else if (null != backType && "2".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)", new Object[0]);
        }
        if (null != payType && "1".equals(payType.getValue())) {
            wrapper.apply("IFNULL(pay_mny,0) <= 0", new Object[0]);
        } else if (null != payType && "2".equals(payType.getValue())) {
            wrapper.apply("IFNULL(pay_mny,0) > 0", new Object[0]);
        }
        IPage<BondDownEntity> pageData = this.bondDownService.selectPage(page, wrapper);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), BondDownVO.class);
        }
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (new Date().after(vo.getEndDate())) {
                vo.setDealStatus("\u5df2\u5230\u671f");
            } else {
                vo.setDealStatus("\u6709\u6548");
            }
        });
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("bondDownExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExports"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExports(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", (Object)"1"));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = (Parameter)param.getParams().get("backType");
        Parameter bondState = (Parameter)param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        NCUtil.voucherParam(param);
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (null != backType && "1".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)", new Object[0]);
        } else if (null != backType && "2".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)", new Object[0]);
        }
        if (null != bondState && "1".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() <= end_date", new Object[0]);
        } else if (null != bondState && "2".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() > end_date", new Object[0]);
        }
        IPage<BondDownEntity> pageData = this.bondDownService.selectPage(page, wrapper);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), BondDownVO.class);
        }
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (new Date().after(vo.getEndDate())) {
                vo.setDealStatus("\u5df2\u5230\u671f");
            } else {
                vo.setDealStatus("\u6709\u6548");
            }
        });
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("bondDownManageExport.xlsx", beans, response);
    }
}

