/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.mapper.BondDownBackMapper;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BondDownBackVO;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.PayBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.PayBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BondDownBackServiceImpl
extends BaseServiceImpl<BondDownBackMapper, BondDownBackEntity>
implements IBondDownBackService {
    private static final String BONGDOWN_BACK = "BONGDOWN_BACK";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBondDownService bondDownService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private NCUtil ncUtil;

    @Override
    public BondDownBackVO insertOrUpdate(BondDownBackVO bondDownBackVO) {
        BigDecimal applyMny;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondDownBackVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGDOWN_BACK, tenantId);
            if (billCode.isSuccess()) {
                bondDownBackVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondDownBackEntity entity = (BondDownBackEntity)((Object)BeanMapper.map((Object)bondDownBackVO, BondDownBackEntity.class));
        if (null != bondDownBackVO.getId() && bondDownBackVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondDownBackEntity::getBillCode, (Object)bondDownBackVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondDownBackVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondDownBackEntity::getBillCode, (Object)bondDownBackVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBackTime(new Date());
        super.saveOrUpdate((Object)entity, false);
        BondDownEntity upentity = (BondDownEntity)((Object)this.bondDownService.selectById(bondDownBackVO.getBondId()));
        BigDecimal sumBackMny = upentity.getBackMny() == null ? BigDecimal.ZERO : upentity.getBackMny();
        BigDecimal bigDecimal = applyMny = upentity.getApplyMny() == null ? BigDecimal.ZERO : upentity.getApplyMny();
        if (applyMny.compareTo(sumBackMny.add(entity.getBackMny())) < 0) {
            throw new BusinessException("\u672c\u6b21\u9000\u8fd8\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u91d1\u989d!");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondDownEntity::getBackMny, (Object)sumBackMny.add(entity.getBackMny()));
        this.bondDownService.update((Wrapper)updateWrapper);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(upentity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())) {
            this.pushToNC(upentity, entity);
        }
        return (BondDownBackVO)BeanMapper.map((Object)((Object)entity), BondDownBackVO.class);
    }

    @Override
    public BondDownDealRentVO queryDetail(Long id) {
        BondDownDealRentVO vo = new BondDownDealRentVO();
        BondDownEntity upEntity = (BondDownEntity)((Object)this.bondDownService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondDownBackEntity::getBondId, (Object)id);
        lambda.orderBy(true, false, (Object[])new SFunction[]{BondDownBackEntity::getBackTime});
        List list = super.list((Wrapper)lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny() == null ? BigDecimal.ZERO : upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny() == null ? BigDecimal.ZERO : upEntity.getContractTaxMny());
        vo.setBackMny(upEntity.getBackMny() == null ? BigDecimal.ZERO : upEntity.getBackMny());
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setBackRecord(BeanMapper.mapList((Iterable)list, BondDownBackVO.class));
        }
        return vo;
    }

    private void pushToNC(BondDownEntity entity, BondDownBackEntity bondDownBackEntity) {
        Object sourceId;
        OrgVO orgVO;
        List<Long> orgIds;
        PayBillVO vo = this.transferToNCVO(entity, bondDownBackEntity);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        StringBuffer sb = new StringBuffer();
        if (entity.getPaymentOrgId().equals(entity.getActualOrgId())) {
            orgIds = this.ncUtil.validateDaoQiaoOrg(entity.getPaymentOrgId(), project.getInvoiceMainCategory());
            for (Long orgId : orgIds) {
                orgVO = this.ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append((String)sourceId).append(",");
            }
        } else {
            orgIds = this.ncUtil.validateDaoQiaoOrg(entity.getPaymentOrgId(), project.getInvoiceMainCategory());
            for (Long orgId : orgIds) {
                orgVO = this.ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append((String)sourceId).append(",");
            }
            BankAccountVO bankAccountVO2 = this.ncUtil.queryDefaultBankAccountById(entity.getActualOrgId(), "insideOrgId");
            PayBillDetailVO payBillDetailVO2 = (PayBillDetailVO)vo.getDetail().get(0);
            payBillDetailVO2.setBankaccount(bankAccountVO2.getBankCode());
            List<Long> orgIds2 = this.ncUtil.validateDaoQiaoOrg(entity.getActualOrgId(), project.getInvoiceMainCategory());
            for (Long orgId : orgIds2) {
                OrgVO orgVO2 = this.ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO2.getCode());
                String sourceId2 = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append(sourceId2).append(",");
            }
        }
        String sourceIds = sb.substring(0, sb.length() - 1);
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        BondDownEntity data = (BondDownEntity)((Object)this.bondDownService.getById(entity.getId()));
        String dataSourceIds = data.getSourceBackId();
        dataSourceIds = StringUtils.isNotEmpty((CharSequence)dataSourceIds) ? dataSourceIds + "," + sourceIds : sourceIds;
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(BondDownEntity::getSourceBackId, (Object)dataSourceIds);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.bondDownService.update((Wrapper)wrapper);
        LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
        lambda.set(BondDownBackEntity::getSourceBackId, (Object)sourceIds);
        lambda.eq(BaseEntity::getId, (Object)bondDownBackEntity.getId());
        this.update((Wrapper)lambda);
    }

    private PayBillVO transferToNCVO(BondDownEntity entity, BondDownBackEntity bondDownBackEntity) {
        this.logger.info("----\u4ed8\u6b3e\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = this.ncUtil.queryOrgById(project.getOrgId());
        SupplierVO supplierVO = this.ncUtil.querySupplierById(entity.getSupplierId());
        PayBillVO vo = new PayBillVO();
        vo.setBusitype("paybill");
        vo.setTradetype("F3-Cxx-007");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setDef19(bondDownBackEntity.getBillCode());
        vo.setDef1(Boolean.valueOf(false));
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));
        vo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
        vo.setBalatype(this.ncUtil.getDefDocById(entity.getPaymentWay()).getCode());
        vo.setDef20(this.ncUtil.getWebSite("ejc-finance-frontend/#/bondManageList/bondDownDetailManage?id=" + entity.getId()));
        vo.setDef21("BT200616000000004");
        ArrayList<PayBillDetailVO> detailVOS = new ArrayList<PayBillDetailVO>();
        PayBillDetailVO detailVO = new PayBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setLocal_mny(bondDownBackEntity.getBackMny());
        BankAccountVO bankAccountVO = this.ncUtil.queryDefaultBankAccountById(entity.getPaymentOrgId(), "insideOrgId");
        detailVO.setBankaccount(bankAccountVO.getBankCode());
        detailVO.setCashitem(this.ncUtil.getDefDocById(entity.getCashItemId()).getCode());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }
}

