/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.service.IPayForegiftRecordService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payForegift")
public class PayForegiftBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayForegiftService service;
    @Autowired
    private IPayForegiftRecordService recordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayForegiftEntity entity = (PayForegiftEntity)((Object)this.service.selectById(billId));
        entity.setApproveTime(new Date());
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayForegiftEntity entity = (PayForegiftEntity)((Object)this.service.selectById(billId));
        if (!this.validateApproveTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5728\u672c\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u540e\u7eed\u5ba1\u6279\u5355\u636e,\u4e0d\u80fd\u5f03\u5ba1!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u652f\u51fa\u5355\u636e\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u64a4\u56de\u64cd\u4f5c!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayForegiftEntity entity = (PayForegiftEntity)((Object)this.service.selectById(billId));
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        entity.setReturnMny(null);
        entity.setSurplusReturnMny(null);
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)billId);
        this.recordService.remove((Wrapper)wrapper, false);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private boolean validateEffective(PayForegiftEntity entity) {
        Long contractId = entity.getContractId();
        Long orgId = entity.getOrgId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)orgId);
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateApproveTime(PayForegiftEntity entity) {
        Long contractId = entity.getContractId();
        Long orgId = entity.getOrgId();
        Date approveTime = entity.getConfirmTime() != null ? entity.getConfirmTime() : entity.getApproveTime();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)orgId);
        wrapper.gt((Object)"approve_time", (Object)approveTime);
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }
}

