/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.ProjectCapitalSetEntity;
import com.ejianc.business.finance.mapper.ProjectCapitalSetMapper;
import com.ejianc.business.finance.service.IProjectCapitalSetService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.util.CountCallable;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.ProjectCapitalSetVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="projectCapitalSetService")
public class ProjectCapitalSetService
extends BaseServiceImpl<ProjectCapitalSetMapper, ProjectCapitalSetEntity>
implements IProjectCapitalSetService {
    private static Logger logger = LoggerFactory.getLogger(ProjectCapitalSetService.class);
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ProjectCapitalSetMapper projectCapitalSetMapper;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IIncomeContractApi incomeApi;

    @Override
    public IPage<ProjectCapitalSetVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), ProjectCapitalSetVO.class));
        }
        return voPage;
    }

    @Override
    public Map<Long, JSONObject> queryIncoemAndExpendByProjectIds(List<Long> projectIds, HttpServletRequest request) {
        BigDecimal sumMny;
        Long projectId2;
        Object obj;
        int i;
        long startTime = System.currentTimeMillis();
        HashMap<Long, BigDecimal> payMoneyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> incomeContractTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> incomeContractMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> incomeTaxRateMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveMoneyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> financeEngineReceiveMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> financeOtherReceiveMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> openInvoiceTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> openInvoiceMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> openTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveSpecialInvoiceTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveSpecialInvoiceMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveSpecialTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveGeneralInvoiceTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveGeneralInvoiceMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveGeneralTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", InvocationInfoProxy.getTenantid());
        map.put("projectIds", projectIds);
        List<ProjectCapitalSetVO> payMoneyList = this.projectCapitalSetMapper.getProjectPayMny(map);
        if (payMoneyList != null && payMoneyList.size() > 0) {
            for (ProjectCapitalSetVO vo : payMoneyList) {
                payMoneyMap.put(vo.getProjectId(), vo.getProjectIncome());
            }
        }
        String authority = request.getHeader("authority");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("projectId", new Parameter("in", projectIds));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        QueryParam queryParam2 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam2.getOrderMap().put("createTime", "desc");
        CommonResponse incomeResp = this.incomeApi.getListByQueryParam(queryParam2);
        JSONArray jsonArray = new JSONArray();
        if (!incomeResp.isSuccess() || incomeResp.getData() == null) {
            logger.error("\u83b7\u53d6\u6536\u5165\u5408\u540c\u5217\u8868\u5931\u8d25\uff1a{}", (Object)incomeResp.getMsg());
        } else {
            jsonArray = ((JSONObject)incomeResp.getData()).getJSONArray("records");
        }
        List receiveList = this.receiveService.queryList(queryParam);
        JSONArray receiveArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiveList));
        CommonResponse openResp = this.invoiceApi.getOpenListByQueryParam(queryParam);
        JSONArray openjsonArray = new JSONArray();
        if (!openResp.isSuccess() || openResp.getData() == null) {
            logger.error("\u83b7\u53d6\u5f00\u7968\u5217\u8868\u5931\u8d25\uff1a{}", (Object)openResp.getMsg());
        } else {
            openjsonArray = ((JSONObject)openResp.getData()).getJSONArray("records");
        }
        QueryParam queryParam3 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam3.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        CommonResponse invoiceResp = this.invoiceApi.getReceiveListByQueryParam(queryParam3);
        JSONArray invoiceArray = new JSONArray();
        if (!invoiceResp.isSuccess() || invoiceResp.getData() == null) {
            logger.error("\u83b7\u53d6\u6536\u7968\u5217\u8868\u5931\u8d25\uff1a{}", (Object)invoiceResp.getMsg());
        } else {
            invoiceArray = ((JSONObject)invoiceResp.getData()).getJSONArray("records");
        }
        long endTime2 = System.currentTimeMillis();
        logger.info("query2 ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime2 - startTime) + "ms");
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (i = 0; i < jsonArray.size(); ++i) {
                obj = jsonArray.getJSONObject(i);
                projectId2 = this.getProjectId((JSONObject)obj);
                if (incomeContractTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)incomeContractTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("contractTaxMny"));
                    incomeContractTaxMnyMap.put(projectId2, sumMny);
                } else {
                    incomeContractTaxMnyMap.put(projectId2, obj.getBigDecimal("contractTaxMny"));
                }
                if (incomeContractMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)incomeContractMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("contractMny"));
                    incomeContractMnyMap.put(projectId2, sumMny);
                } else {
                    incomeContractMnyMap.put(projectId2, obj.getBigDecimal("contractMny"));
                }
                if (incomeTaxRateMap.get(projectId2) != null) continue;
                incomeTaxRateMap.put(projectId2, obj.getBigDecimal("taxRate"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)receiveArray)) {
            for (i = 0; i < receiveArray.size(); ++i) {
                obj = receiveArray.getJSONObject(i);
                projectId2 = this.getProjectId((JSONObject)obj);
                if (receiveMoneyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveMoneyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("receiveMny"));
                    receiveMoneyMap.put(projectId2, sumMny);
                } else {
                    receiveMoneyMap.put(projectId2, obj.getBigDecimal("receiveMny"));
                }
                if (Long.valueOf("1275321308270993409").equals(obj.getLong("receiveType"))) {
                    if (financeEngineReceiveMnyMap.get(projectId2) != null) {
                        sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)financeEngineReceiveMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("receiveMny"));
                        financeEngineReceiveMnyMap.put(projectId2, sumMny);
                    } else {
                        financeEngineReceiveMnyMap.put(projectId2, obj.getBigDecimal("receiveMny"));
                    }
                }
                if (!Long.valueOf("1275321354706132993").equals(obj.getLong("receiveType"))) continue;
                if (financeOtherReceiveMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)financeOtherReceiveMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("receiveMny"));
                    financeOtherReceiveMnyMap.put(projectId2, sumMny);
                    continue;
                }
                financeOtherReceiveMnyMap.put(projectId2, obj.getBigDecimal("receiveMny"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)openjsonArray)) {
            for (i = 0; i < openjsonArray.size(); ++i) {
                obj = openjsonArray.getJSONObject(i);
                projectId2 = this.getProjectId((JSONObject)obj);
                if (openInvoiceTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)openInvoiceTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                    openInvoiceTaxMnyMap.put(projectId2, sumMny);
                } else {
                    openInvoiceTaxMnyMap.put(projectId2, obj.getBigDecimal("invoiceTaxMny"));
                }
                if (openInvoiceMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)openInvoiceMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceMny"));
                    openInvoiceMnyMap.put(projectId2, sumMny);
                } else {
                    openInvoiceMnyMap.put(projectId2, obj.getBigDecimal("invoiceMny"));
                }
                if (openTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)openTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("taxMny"));
                    openTaxMnyMap.put(projectId2, sumMny);
                    continue;
                }
                openTaxMnyMap.put(projectId2, obj.getBigDecimal("taxMny"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)invoiceArray)) {
            for (i = 0; i < invoiceArray.size(); ++i) {
                obj = invoiceArray.getJSONObject(i);
                projectId2 = this.getProjectId((JSONObject)obj);
                if (Long.valueOf("1277537516768632833").equals(obj.getLong("invoiceType"))) {
                    if (receiveSpecialInvoiceTaxMnyMap.get(projectId2) != null) {
                        sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveSpecialInvoiceTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                        receiveSpecialInvoiceTaxMnyMap.put(projectId2, sumMny);
                    } else {
                        receiveSpecialInvoiceTaxMnyMap.put(projectId2, obj.getBigDecimal("invoiceTaxMny"));
                    }
                    if (receiveSpecialInvoiceMnyMap.get(projectId2) != null) {
                        sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveSpecialInvoiceMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceMny"));
                        receiveSpecialInvoiceMnyMap.put(projectId2, sumMny);
                    } else {
                        receiveSpecialInvoiceMnyMap.put(projectId2, obj.getBigDecimal("invoiceMny"));
                    }
                    if (receiveSpecialTaxMnyMap.get(projectId2) != null) {
                        sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveSpecialTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("taxMny"));
                        receiveSpecialTaxMnyMap.put(projectId2, sumMny);
                    } else {
                        receiveSpecialTaxMnyMap.put(projectId2, obj.getBigDecimal("taxMny"));
                    }
                }
                if (!Long.valueOf("1277537563879055362").equals(obj.getLong("invoiceType"))) continue;
                if (receiveGeneralInvoiceTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveGeneralInvoiceTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                    receiveGeneralInvoiceTaxMnyMap.put(projectId2, sumMny);
                } else {
                    receiveGeneralInvoiceTaxMnyMap.put(projectId2, obj.getBigDecimal("invoiceTaxMny"));
                }
                if (receiveGeneralInvoiceMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveGeneralInvoiceMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceMny"));
                    receiveGeneralInvoiceMnyMap.put(projectId2, sumMny);
                } else {
                    receiveGeneralInvoiceMnyMap.put(projectId2, obj.getBigDecimal("invoiceMny"));
                }
                if (receiveGeneralTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveGeneralTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("taxMny"));
                    receiveGeneralTaxMnyMap.put(projectId2, sumMny);
                    continue;
                }
                receiveGeneralTaxMnyMap.put(projectId2, obj.getBigDecimal("taxMny"));
            }
        }
        HashMap<Long, JSONObject> result = new HashMap<Long, JSONObject>();
        for (Long projectId2 : projectIds) {
            JSONObject resp = new JSONObject();
            resp.put("receiveMoney", receiveMoneyMap.get(projectId2));
            resp.put("payMoney", payMoneyMap.get(projectId2));
            resp.put("incomeContractTaxMny", incomeContractTaxMnyMap.get(projectId2));
            resp.put("incomeContractMny", incomeContractMnyMap.get(projectId2));
            resp.put("incomeTaxRate", incomeTaxRateMap.get(projectId2));
            resp.put("financeEngineReceiveMny", financeEngineReceiveMnyMap.get(projectId2));
            resp.put("financeOtherReceiveMny", financeOtherReceiveMnyMap.get(projectId2));
            resp.put("openInvoiceTaxMny", openInvoiceTaxMnyMap.get(projectId2));
            resp.put("openInvoiceMny", openInvoiceMnyMap.get(projectId2));
            resp.put("openTaxMny", openTaxMnyMap.get(projectId2));
            resp.put("receiveSpecialInvoiceTaxMny", receiveSpecialInvoiceTaxMnyMap.get(projectId2));
            resp.put("receiveSpecialInvoiceMny", receiveSpecialInvoiceMnyMap.get(projectId2));
            resp.put("receiveSpecialTaxMny", receiveSpecialTaxMnyMap.get(projectId2));
            resp.put("receiveGeneralInvoiceTaxMny", receiveGeneralInvoiceTaxMnyMap.get(projectId2));
            resp.put("receiveGeneralInvoiceMny", receiveGeneralInvoiceMnyMap.get(projectId2));
            resp.put("receiveGeneralTaxMny", receiveGeneralTaxMnyMap.get(projectId2));
            result.put(projectId2, resp);
        }
        long endTime = System.currentTimeMillis();
        logger.info("queryIncoemAndExpendByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - endTime2) + "ms");
        return result;
    }

    private Long getProjectId(JSONObject obj) {
        Long projectId = null;
        projectId = obj.getString("projectId").length() > 20 ? obj.getJSONObject("projectId").getLong("id") : obj.getLong("projectId");
        return projectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<JSONObject> queryIncoemAndExpendByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String authority = request.getHeader("authority");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", InvocationInfoProxy.getTenantid());
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(projectId);
        map.put("projectIds", projectIds);
        List<ProjectCapitalSetVO> payMoneyList = this.projectCapitalSetMapper.getProjectPayMny(map);
        BigDecimal payMoney = null;
        if (payMoneyList != null && payMoneyList.size() > 0) {
            payMoney = payMoneyList.get(0).getProjectIncome();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam queryParam1 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam.getOrderMap().put("createTime", "desc");
        Future<JSONObject> future1 = this.excute(threadPool, authority, "ejc-income-web/contract/pageList", queryParam1);
        QueryParam queryParam2 = (QueryParam)Utils.deepCopy((Object)queryParam);
        Future<JSONObject> future2 = this.excute(threadPool, queryParam2, this.receiveService);
        Future<JSONObject> future3 = this.excute(threadPool, authority, "ejc-tax-web/invoiceOpen/pageList", queryParam2);
        QueryParam queryParam3 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam3.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        Future<JSONObject> future4 = this.excute(threadPool, authority, "ejc-tax-web/invoiceReceive/pageList", queryParam3);
        BigDecimal receiveMoney = null;
        BigDecimal incomeContractTaxMny = null;
        BigDecimal incomeContractMny = null;
        BigDecimal incomeTaxRate = null;
        BigDecimal financeEngineReceiveMny = null;
        BigDecimal financeOtherReceiveMny = null;
        BigDecimal openInvoiceTaxMny = null;
        BigDecimal openInvoiceMny = null;
        BigDecimal openTaxMny = null;
        BigDecimal receiveSpecialInvoiceTaxMny = null;
        BigDecimal receiveSpecialInvoiceMny = null;
        BigDecimal receiveSpecialTaxMny = null;
        BigDecimal receiveGeneralInvoiceTaxMny = null;
        BigDecimal receiveGeneralInvoiceMny = null;
        BigDecimal receiveGeneralTaxMny = null;
        try {
            JSONArray invoiceArray;
            JSONArray openArray;
            JSONArray receiveArray;
            JSONObject obj;
            int i;
            JSONArray jsonArray = future1.get().getJSONArray("records");
            if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
                JSONObject obj1 = jsonArray.getJSONObject(0);
                incomeTaxRate = obj1.getBigDecimal("taxRate");
                for (i = 0; i < jsonArray.size(); ++i) {
                    obj = jsonArray.getJSONObject(i);
                    incomeContractTaxMny = MathUtil.safeAdd(incomeContractTaxMny, (BigDecimal)obj.getBigDecimal("contractTaxMny"));
                    incomeContractMny = MathUtil.safeAdd(incomeContractMny, (BigDecimal)obj.getBigDecimal("incomeContractMny"));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(receiveArray = future2.get().getJSONArray("records")))) {
                for (i = 0; i < receiveArray.size(); ++i) {
                    obj = receiveArray.getJSONObject(i);
                    if (Long.valueOf("1275321308270993409").equals(obj.getLong("receiveType"))) {
                        financeEngineReceiveMny = MathUtil.safeAdd(financeEngineReceiveMny, (BigDecimal)obj.getBigDecimal("receiveMny"));
                    }
                    if (Long.valueOf("1275321354706132993").equals(obj.getLong("receiveType"))) {
                        financeOtherReceiveMny = MathUtil.safeAdd(financeOtherReceiveMny, (BigDecimal)obj.getBigDecimal("receiveMny"));
                    }
                    receiveMoney = MathUtil.safeAdd(receiveMoney, (BigDecimal)obj.getBigDecimal("receiveMny"));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(openArray = future3.get().getJSONArray("records")))) {
                for (int i2 = 0; i2 < openArray.size(); ++i2) {
                    JSONObject obj2 = openArray.getJSONObject(i2);
                    openInvoiceTaxMny = MathUtil.safeAdd(openInvoiceTaxMny, (BigDecimal)obj2.getBigDecimal("invoiceTaxMny"));
                    openInvoiceMny = MathUtil.safeAdd(openInvoiceMny, (BigDecimal)obj2.getBigDecimal("invoiceMny"));
                    openTaxMny = MathUtil.safeAdd(openTaxMny, (BigDecimal)obj2.getBigDecimal("taxMny"));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(invoiceArray = future4.get().getJSONArray("records")))) {
                for (int i3 = 0; i3 < invoiceArray.size(); ++i3) {
                    JSONObject obj3 = invoiceArray.getJSONObject(i3);
                    if (Long.valueOf("1277537516768632833").equals(obj3.getLong("invoiceType"))) {
                        receiveSpecialInvoiceTaxMny = MathUtil.safeAdd(receiveSpecialInvoiceTaxMny, (BigDecimal)obj3.getBigDecimal("invoiceTaxMny"));
                        receiveSpecialInvoiceMny = MathUtil.safeAdd(receiveSpecialInvoiceMny, (BigDecimal)obj3.getBigDecimal("invoiceMny"));
                        receiveSpecialTaxMny = MathUtil.safeAdd(receiveSpecialTaxMny, (BigDecimal)obj3.getBigDecimal("taxMny"));
                    }
                    if (!Long.valueOf("1277537563879055362").equals(obj3.getLong("invoiceType"))) continue;
                    receiveGeneralInvoiceTaxMny = MathUtil.safeAdd(receiveGeneralInvoiceTaxMny, (BigDecimal)obj3.getBigDecimal("invoiceTaxMny"));
                    receiveGeneralInvoiceMny = MathUtil.safeAdd(receiveGeneralInvoiceMny, (BigDecimal)obj3.getBigDecimal("invoiceMny"));
                    receiveGeneralTaxMny = MathUtil.safeAdd(receiveGeneralTaxMny, (BigDecimal)obj3.getBigDecimal("taxMny"));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9879\u76ee\u6536\u4ed8\u6b3e\u4ee5\u53ca\u5408\u540c\u91d1\u989d\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        JSONObject resp = new JSONObject();
        resp.put("receiveMoney", receiveMoney);
        resp.put("payMoney", (Object)payMoney);
        resp.put("incomeContractTaxMny", incomeContractTaxMny);
        resp.put("incomeContractMny", incomeContractMny);
        resp.put("incomeTaxRate", (Object)incomeTaxRate);
        resp.put("financeEngineReceiveMny", (Object)financeEngineReceiveMny);
        resp.put("financeOtherReceiveMny", (Object)financeOtherReceiveMny);
        resp.put("openInvoiceTaxMny", (Object)openInvoiceTaxMny);
        resp.put("openInvoiceMny", (Object)openInvoiceMny);
        resp.put("openTaxMny", (Object)openTaxMny);
        resp.put("receiveSpecialInvoiceTaxMny", (Object)receiveSpecialInvoiceTaxMny);
        resp.put("receiveSpecialInvoiceMny", (Object)receiveSpecialInvoiceMny);
        resp.put("receiveSpecialTaxMny", (Object)receiveSpecialTaxMny);
        resp.put("receiveGeneralInvoiceTaxMny", (Object)receiveGeneralInvoiceTaxMny);
        resp.put("receiveGeneralInvoiceMny", (Object)receiveGeneralInvoiceMny);
        resp.put("receiveGeneralTaxMny", (Object)receiveGeneralTaxMny);
        long endTime = System.currentTimeMillis();
        logger.info("queryIncoemAndExpendByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)resp);
    }

    private static BigDecimal getSumMny(CommonResponse<JSONObject> resp, String records, String field) {
        JSONArray jsonArray = new JSONArray();
        if (!resp.isSuccess() || resp.getData() == null) {
            logger.error("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff1a{}", (Object)resp.getMsg());
        } else {
            logger.info("\u67e5\u8be2\u5217\u8868\u7ed3\u679c\uff1a{}", resp);
            jsonArray = ((JSONObject)resp.getData()).getJSONArray(records);
        }
        BigDecimal sumMny = null;
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                sumMny = MathUtil.safeAdd(sumMny, (BigDecimal)obj.getBigDecimal(field));
            }
        }
        return sumMny;
    }

    private static BigDecimal getSumMny(JSONObject json, String field) {
        JSONArray jsonArray = json.getJSONArray("records");
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return null;
        }
        BigDecimal sumMny = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            sumMny = MathUtil.safeAdd(sumMny, (BigDecimal)obj.getBigDecimal(field));
        }
        return sumMny;
    }

    private Future<JSONObject> excute(ExecutorService threadPool, String authority, String url, QueryParam queryParam) {
        CountCallable callable = new CountCallable(RequestContextHolder.getRequestAttributes(), authority, this.BASE_HOST + url, queryParam, null);
        Future<JSONObject> future = threadPool.submit(callable);
        return future;
    }

    private Future<JSONObject> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        CountCallable callable = new CountCallable(RequestContextHolder.getRequestAttributes(), null, null, queryParam, service);
        Future<JSONObject> future = threadPool.submit(callable);
        return future;
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? new BigDecimal("0.00") : src.setScale(2, 6);
    }
}

