/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class MonthUtil {
    public static String monthAdd(SimpleDateFormat sdf, String m, Integer len) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(m));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        cal.add(2, len);
        return sdf.format(cal.getTime());
    }

    public static Date monthAdd(Date m, Integer len) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(m);
        cal.add(2, len);
        return cal.getTime();
    }

    public static int compareTime(String t1, String t2) {
        int trr2;
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        if (trr1 > (trr2 = Integer.parseInt(t2.replaceAll("-", "")))) {
            return 1;
        }
        if (trr1 < trr2) {
            return -1;
        }
        return 0;
    }

    public static List<String> getMonthList(String startDate, String endDate) {
        ArrayList<String> list = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            c1.setTime(sdf.parse(startDate));
            c2.setTime(sdf.parse(endDate));
            int year = c2.get(1) - c1.get(1);
            int month = c2.get(2) + year * 12 - c1.get(2);
            for (int i = 0; i <= month; ++i) {
                c1.setTime(sdf.parse(startDate));
                c1.add(2, i);
                list.add(sdf.format(c1.getTime()));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List getMonth(String date, boolean flag, int num) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c = Calendar.getInstance();
        c.setTime(sdf.parse(date));
        for (int i = 0; i < num; ++i) {
            c.setTime(sdf.parse(date));
            if (flag) {
                c.add(2, i);
            } else {
                c.add(2, i + 1 - num);
            }
            list.add(sdf.format(c.getTime()));
        }
        return list;
    }

    public static Integer getSubMonth(String startDate, String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        Integer month = 0;
        try {
            c1.setTime(sdf.parse(startDate));
            c2.setTime(sdf.parse(endDate));
            int year = c2.get(1) - c1.get(1);
            month = c2.get(2) + year * 12 - c1.get(2);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return month;
    }

    public static String mostDate(List<String> list, int type) {
        String t = null;
        if (list.size() <= 0) {
            return t;
        }
        t = list.get(0);
        for (String d : list) {
            if (type == 0 && MonthUtil.compareTime(t, d) > 0) {
                t = d;
            }
            if (type != 1 || MonthUtil.compareTime(t, d) >= 0) continue;
            t = d;
        }
        return t;
    }
}

