package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 保证金退还表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_down_back")
public class BondDownBackEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 保证金主键
     */
    @TableField("bond_id")
    private Long bondId;

    /**
     * 退还编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 退还金额
     */
    @TableField("back_mny")
    private BigDecimal backMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("back_time")
    private Date backTime;

    /**
     * 经办人
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 付款方式
     */
    @TableField("payment_way")
    private Long paymentWay;

    /**
     * 付款组织id
     */
    @TableField("payment_org_id")
    private Long paymentOrgId;

    /**
     * 付款组织名称
     */
    @TableField("payment_org_name")
    private String paymentOrgName;

    /**
     * 实际付款组织id
     */
    @TableField("actual_org_id")
    private Long actualOrgId;

    /**
     * 实际付款组织名称
     */
    @TableField("actual_org_name")
    private String actualOrgName;

    /**
     * 来源ID
     */
    @TableField("source_back_id")
    private String sourceBackId;
    
    public Long getBondId() {
        return bondId;
    }

    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getPaymentWay() {
        return paymentWay;
    }

    public void setPaymentWay(Long paymentWay) {
        this.paymentWay = paymentWay;
    }

    public Long getPaymentOrgId() {
        return paymentOrgId;
    }

    public void setPaymentOrgId(Long paymentOrgId) {
        this.paymentOrgId = paymentOrgId;
    }

    public String getPaymentOrgName() {
        return paymentOrgName;
    }

    public void setPaymentOrgName(String paymentOrgName) {
        this.paymentOrgName = paymentOrgName;
    }

    public Long getActualOrgId() {
        return actualOrgId;
    }

    public void setActualOrgId(Long actualOrgId) {
        this.actualOrgId = actualOrgId;
    }

    public String getActualOrgName() {
        return actualOrgName;
    }

    public void setActualOrgName(String actualOrgName) {
        this.actualOrgName = actualOrgName;
    }

    public String getSourceBackId() {
        return sourceBackId;
    }

    public void setSourceBackId(String sourceBackId) {
        this.sourceBackId = sourceBackId;
    }
}
