package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_pay_sporadic")
public class PaySporadicEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办时间
     */
    @TableField("confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 付款类型：1-组织付款，2- 项目付款
     */
    @TableField("pay_type")
    private Integer payType;

    /**
     * 支付状态：1-未支付，2-已支付
     */
    @TableField("pay_status")
    private Integer payStatus;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 供应商
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 付款事由
     */
    @TableField("pay_reason")
    private String payReason;

    /**
     * 申请人
     */
    @TableField("apply_user_id")
    private Long applyUserId;

    /**
     * 申请人名称
     */
    @TableField("apply_user_name")
    private String applyUserName;

    /**
     * 申请时间
     */
    @TableField("apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    @TableField("apply_mny")
    private BigDecimal applyMny;

    /**
     * 发票金额
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 支付金额
     */
    @TableField("pay_mny")
    private BigDecimal payMny;

    /**
     * 账户名称
     */
    @TableField("account_name")
    private String accountName;

    /**
     * 银行账号
     */
    @TableField("account_num")
    private String accountNum;

    /**
     * 开户行
     */
    @TableField("account_bank")
    private String accountBank;

    /**
     * 撤回原因
     */
    @TableField("back_reason")
    private String backReason;

    /**
     * 撤回时间
     */
    @TableField("back_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 审批时间
     */
    @TableField("approve_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 属于项目:1-是，0-否
     */
    @TableField("depend_on_project")
    private String dependOnProject;
    /**
     * 是否包含入库单(1-是，0-否)
     */
    @TableField("input_flag")
    private String inputFlag;
    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;
    /**
     * 关联状态(1:是，0：否)
     */
    @TableField("relation_flag")
    private String relationFlag;
    /**
     * 分摊状态(1:是，0：否)
     */
    @TableField("proportion_flag")
    private String proportionFlag;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private String invoiceFlag;

    /**
     * 核算对象主键
     */
    @TableField(value="accounting_id")
    private java.lang.Long accountingId; // 核算对象主键

    /**
     * 核算对象名称
     */
    @TableField(value="accounting_name")
    private java.lang.String accountingName; // 核算对象名称

    /**
     * 集团成本科目主键
     */
    @TableField(value="org_subject_id")
    private java.lang.Long orgSubjectId;

    /**
     * 集团核算对象主键
     */
    @TableField(value="org_accounting_id")
    private java.lang.Long orgAccountingId;

    /**
     * 项目资金余额
     */
    @TableField("project_balance_tax_mny")
    private BigDecimal projectBalanceTaxMny;

    /**
     * 应付账款余额
     */
    @TableField("accounts_balance_tax_mny")
    private BigDecimal accountsBalanceTaxMny;
    
    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getInputFlag() {
        return inputFlag;
    }

    public void setInputFlag(String inputFlag) {
        this.inputFlag = inputFlag;
    }
    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    /**
     * 核算对象主键
     */
    public Long getAccountingId() {
        return accountingId;
    }

    /**
     * 核算对象主键
     */
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    /**
     * 核算对象名称
     */
    public String getAccountingName() {
        return accountingName;
    }

    /**
     * 核算对象名称
     */
    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    /**
     * 集团成本科目主键
     */
    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    /**
     * 集团成本科目主键
     */
    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    /**
     * 集团核算对象主键
     */
    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    /**
     * 集团核算对象主键
     */
    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }

    public BigDecimal getProjectBalanceTaxMny() {
        return projectBalanceTaxMny;
    }

    public void setProjectBalanceTaxMny(BigDecimal projectBalanceTaxMny) {
        this.projectBalanceTaxMny = projectBalanceTaxMny;
    }

    public BigDecimal getAccountsBalanceTaxMny() {
        return accountsBalanceTaxMny;
    }

    public void setAccountsBalanceTaxMny(BigDecimal accountsBalanceTaxMny) {
        this.accountsBalanceTaxMny = accountsBalanceTaxMny;
    }
}
