package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Controller
@RequestMapping("/receive")
public class ReceiveController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IReceiveService receiveService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IPayContractService payContractService;

    @Autowired
    private IPaySporadicService paySporadicService;

    @Autowired
    private IPayReimburseService payReimburseService;

    @Autowired
    private ILoadReimburseService loadReimburseService;

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param receiveVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReceiveVO> saveOrUpdate(@RequestBody ReceiveVO receiveVO) {
        ReceiveVO backVO = receiveService.insertOrUpdate(receiveVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceiveVO> queryDetail(Long id) {
        ReceiveVO backVO = receiveService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("Receive", receiveService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject page = receiveService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceiveVO> vos) {
        List<Long> ids = vos.stream().map(ReceiveVO::getId).collect(Collectors.toList());
        String msg = receiveService.delete(ids);
        return CommonResponse.success(msg);
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<ReceiveVO> supplierVos = receiveService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("receive-export.xlsx", beans, response);
    }

    /**
     * 统计累计已生效的收支
     *
     * @param projectRange
     * @return
     */
    @GetMapping(value = "/countRecAndPay")
    @ResponseBody
    public CommonResponse<JSONObject> countRecAndPay(@RequestParam(value = "projectRange") Integer projectRange
            , @RequestParam(value = "orgId", required = false) Long orgId) {
        JSONObject resp = new JSONObject();

        List<Long> orgIds = new ArrayList<>();
//        List<Long> newIds = new ArrayList<>();
        if (orgId != null) {
            orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
//            CommonResponse<List<ProjectRegisterVO>> listCommonResponse = projectApi.queryChildrenProjectByOrgId(orgId);
//            if (listCommonResponse.isSuccess()) {
//                List<ProjectRegisterVO> list = listCommonResponse.getData();
//                newIds = list.stream().map(ProjectRegisterVO::getId).collect(Collectors.toList());
//            }
        }else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }

        List<Long> projectIds = new ArrayList<>();
//        if(projectRange != 1) {
//            CommonResponse<List<Long>> res = projectApi.getProjectIdsByProperties(projectRange);
//            if(!res.isSuccess()) {
//                if(!res.isSuccess()) {
//                    logger.error("根据条件 projectRange-{} 查询项目Id列表失败，原因：{}", projectRange, res.getMsg());
//                    return CommonResponse.error("查询失败，查询匹配的项目信息失败。");
//                }
//            }
//            projectIds = res.getData();
//            // 根据组织过滤projectIds
//            if (orgId != null) {
//                projectIds = projectIds.stream().filter(newIds::contains).collect(Collectors.toList());
//            }
//            if(CollectionUtils.isEmpty(projectIds)) {
//                resp.put("rec", 0);
//                resp.put("out", 0);
//                return CommonResponse.success(resp);
//            }
//        }else {
//            projectIds = newIds;
//        }
        //收入
        Map<String, Object> result = receiveService.countRecAmt(InvocationInfoProxy.getTenantid(), projectIds, false, orgIds);
        resp.put("rec", result.get("amt"));

        //支出
        //1、合同付款
        Map<String, Object> payContractResult = payContractService.countAmt(InvocationInfoProxy.getTenantid(), projectIds, orgIds);
        Map<String, Object> paySporadicResult = paySporadicService.countAmt(InvocationInfoProxy.getTenantid(), projectIds, orgIds);
        Map<String, Object> payReimburse = payReimburseService.countAmt(InvocationInfoProxy.getTenantid(), projectIds, orgIds);
        Map<String, Object> loadReimburseResult = loadReimburseService.countAmt(InvocationInfoProxy.getTenantid(), projectIds, orgIds);
        BigDecimal totalOut = new BigDecimal(0);
        totalOut = totalOut.add(new BigDecimal(payContractResult.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(paySporadicResult.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(payReimburse.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(loadReimburseResult.get("amt").toString()));

        resp.put("out", totalOut.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP));
        return CommonResponse.success(resp);
    }
}
