package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IReceiveService extends IBaseService<ReceiveEntity> {

    ReceiveVO insertOrUpdate(ReceiveVO receiveVO);

    ReceiveVO queryDetail(Long id);

    List<ReceiveVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);

    SumReceiveVO getSumReceiveVOList(Long contractId);

    /**
     * 统计已生效的收入单据的收入金额
     *
     * @param tenantId 租户Id
     * @param projectIds 带过滤项目Id列表
     * @param isWithContract 是否有合同
     * @return
     */
    Map<String, Object> countRecAmt(Long tenantId, List<Long> projectIds, boolean isWithContract, List<Long> orgIds);
}
