package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.pub.utils.HttpTookit;
import com.ejianc.business.qdsz.nc.vo.RecBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.RecBillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("receive")
public class ReceiveBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IIncomeContractApi incomApi;

	@Autowired
	private IReceiveService receiveService;

	@Autowired
	private NCUtil ncUtil;

	@Autowired
	private ICustomerApi customerApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReceiveEntity entity = receiveService.selectById(billId);
		logger.info("审批通过后回写--- entity:" + entity);
		if(entity.getContractId() != null){
            incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), true);
        }

		//审批通过后回写NC
		ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
		if ("1".equals(project.getIndustryIntegrationFlag())){
			pushToNcAr(entity);
		}

		return CommonResponse.success("回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReceiveEntity entity = receiveService.selectById(billId);
		// 校验创建时间
		if (!validateCreateTime(entity)) return CommonResponse.error("该合同已存在后续单据,不能弃审!");
		// 校验存在未生效单据
		if (!validateEffective(entity)) return CommonResponse.error("该支出单据数据已被引用，不可进行撤回操作!");
		return CommonResponse.success("校验通过");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReceiveEntity entity = receiveService.selectById(billId);
		logger.info("弃审后回写--- entity:" + entity);
        if(entity.getContractId() != null){
            incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), false);
        }

		// 删除NC传应付单凭证
		if(StringUtils.isNotEmpty(entity.getSourceId())){
			String[] split = entity.getSourceId().split(",");
			for (String sourceId : split){
				JSONObject json = new JSONObject();
				json.put("busitype", "deleterecbill");
				json.put("pk_bill", sourceId);
				ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
			}

			LambdaUpdateWrapper<ReceiveEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(ReceiveEntity::getSourceId,null);
			wrapper.eq(ReceiveEntity::getId,billId);
			receiveService.update(wrapper);

		}

		return CommonResponse.success("回调处理成功！");
	}

	/**
	 * 校验存在未生效单据
	 * @param entity
	 * @return
	 */
	private boolean validateEffective(ReceiveEntity entity) {
		Long contractId = entity.getContractId();
		QueryWrapper wrapper = new QueryWrapper<ReceiveEntity>();
		wrapper.eq("contract_id", contractId);
		wrapper.eq("org_id", entity.getOrgId());
		wrapper.ne("bill_state", 1);
		wrapper.ne("bill_state", 3);
		List<ReceiveEntity> list = receiveService.list(wrapper);
		if(!list.isEmpty()){
			return false;
		}
		return true;
	}

	/**
	 * 校验创建时间
	 * @param entity
	 * @return
	 */
	private boolean validateCreateTime(ReceiveEntity entity) {
		Long contractId = entity.getContractId();
		Date createTime = entity.getCreateTime();
		QueryWrapper wrapper = new QueryWrapper<ReceiveEntity>();
		wrapper.eq("contract_id", contractId);
		wrapper.eq("org_id", entity.getOrgId());
		wrapper.gt("create_time", createTime);
		List<ReceiveEntity> list = receiveService.list(wrapper);
		if(!list.isEmpty()){
			return false;
		}
		return true;
	}

	private void pushToNcAr(ReceiveEntity receiveEntity){
		RecBillVO vo = transferToNCVO(receiveEntity);// 转换成NCVO

		StringBuffer sb = new StringBuffer();
		if(receiveEntity.getReceiveOrgId().equals(receiveEntity.getActualReceiveOrgId())){
			//如果【收款组织】和【实际收款组织】相同则传一个凭证
			String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 开始传凭证
			sb.append(sourceId);
		}else{
			//否则如果【收款组织】和【实际收款组织】不同则传两个凭证
			String sourceId1 = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 第一次传凭证

			vo.setPk_org(ncUtil.queryOrgById(receiveEntity.getActualReceiveOrgId()).getCode()); //传【实际收款组织】
			BankAccountVO bankAccountVO2 = ncUtil.queryDefaultBankAccountById(receiveEntity.getActualReceiveOrgId(), "insideOrgId");//根据实际收款组织查银行账户
			RecBillDetailVO recBillDetailVO2 = vo.getDetail().get(0);
			recBillDetailVO2.setBankaccount(bankAccountVO2.getBankCode());
			String sourceId2 = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 第二次传凭证
			sb.append(sourceId1).append(",").append(sourceId2);
		}

		LambdaUpdateWrapper<ReceiveEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(ReceiveEntity::getSourceId,sb.toString());// 保存来源主键
		wrapper.eq(ReceiveEntity::getId, receiveEntity.getId());
		receiveService.update(wrapper);

	}

	private RecBillVO transferToNCVO(ReceiveEntity receiveEntity){
		logger.info("----收入管理收款单传凭证开始:");

		RecBillVO recNcVo = new RecBillVO();
		recNcVo.setBusitype("recbill"); // 业务标识(默认recbill)

		recNcVo.setDef1(false);//默认false

		Long recType1 = 1275321308270993409L;//工程合同收款id
		Long recType2 = 1275321354706132993L;//其它收款id
		if (recType1.equals(receiveEntity.getReceiveType())){
			//工程合同收款
			recNcVo.setTradetype("F2-Cxx-001"); // 交易类型
		}
		if (recType2.equals(receiveEntity.getReceiveType())){
			//其它收款
			recNcVo.setTradetype("F2-Cxx-004"); // 交易类型
		}
		recNcVo.setPk_org(ncUtil.queryOrgById(receiveEntity.getReceiveOrgId()).getCode()); // 财务组织编码（收款单位）

		ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(receiveEntity.getProjectId())).get(0);
		recNcVo.setPk_project(String.valueOf(receiveEntity.getProjectId())); // 项目主键
		recNcVo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory())); // 开票主体分类 0-PMDA06001,1-PMDA06002
		recNcVo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay())); //计税方式 0-01,1-02
		if(StringUtils.isEmpty(project.getAreaCode())){
			throw new BusinessException("项目-区域不能为空！");
		}
		recNcVo.setDef5(project.getAreaCode()); // 区域编码

		recNcVo.setDef12(String.valueOf(receiveEntity.getId())); // PM单据主键
		recNcVo.setPk_customer(String.valueOf(receiveEntity.getReceiveUnitId())); // 客户主键

		CustomerVO customerVO = ncUtil.queryCustomerById(receiveEntity.getReceiveUnitId());
		recNcVo.setDef6(customerVO.getInsideOrgId() != null); // 是否内部单位 true/false

		recNcVo.setPk_dept(String.valueOf(project.getDeptId())); //部门

		DefdocDetailVO defDocById = ncUtil.getDefDocById(receiveEntity.getReceiveWay());
		recNcVo.setBalatype(defDocById.getCode()); //结算方式
		//recNcVo.setPk_realorg(String.valueOf(receiveEntity.getActualReceiveOrgId())); //实际收款组织
		recNcVo.setDef16(receiveEntity.getSettleStatus());
		recNcVo.setDef19(receiveEntity.getBillCode()); //单据编号
		recNcVo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/receive/receiveCard?id=" + receiveEntity.getId()));// 外部访问url
		recNcVo.setDef21("BT200622000000005");// 单据类型

		List<RecBillDetailVO> detailVOS = new ArrayList<>();
		RecBillDetailVO detailVO = new RecBillDetailVO();
		detailVO.setPk_project(String.valueOf(receiveEntity.getProjectId()));
		detailVO.setLocal_mny(receiveEntity.getReceiveMny()); //组织本币金额(收款金额)
		BankAccountVO bankAccountVO = ncUtil.queryDefaultBankAccountById(receiveEntity.getReceiveOrgId(), "insideOrgId");
		detailVO.setBankaccount(bankAccountVO.getBankCode()); //银行账户
		detailVO.setCashitem(ncUtil.getDefDocById(receiveEntity.getCashItemId()).getCode()); //现金流量
		detailVOS.add(detailVO);
		recNcVo.setDetail(detailVOS);

		return recNcVo;
	}

}
