package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_receive")
public class  ReceiveEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 收入类型
     */
    @TableField("receive_type")
    private Long receiveType;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同编码
     */
    @TableField("contract_code")
    private String contractCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目类型：1-自营，2-联营
     */
    @TableField("project_type")
    private String projectType;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 收款方式
     */
    @TableField("receive_way")
    private Long receiveWay;

    /**
     * 收款金额
     */
    @TableField("receive_mny")
    private BigDecimal receiveMny;

    /**
     * 收款单位
     */
    @TableField("receive_unit_id")
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    @TableField("receive_unit_name")
    private String receiveUnitName;

    /**
     * 收款说明
     */
    @TableField("receive_explain")
    private String receiveExplain;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办时间
     */
    @TableField("confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 合同金额
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 累计产值
     */
    @TableField("sum_production_mny")
    private BigDecimal sumProductionMny;

    /**
     * 累计批量
     */
    @TableField("sum_quote_mny")
    private BigDecimal sumQuoteMny;

    /**
     * 已收金额
     */
    @TableField("sum_collect_mny")
    private BigDecimal sumCollectMny;

    /**
     * 累计开票金额
     */
    @TableField("sum_invoicing_mny")
    private BigDecimal sumInvoicingMny;

    /**
     * 开票金额
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 收款类型：1-组织收款 2-项目收款
     */
    @TableField("pay_type")
    private Integer payType;


    @TableField(value = "receive_org_id")
    private Long receiveOrgId; //收款组织id
    @TableField(value = "receive_org_name")
    private String receiveOrgName; //收款组织名称
    @TableField(value = "actual_receive_org_id")
    private Long actualReceiveOrgId;  //实际收款组织id
    @TableField(value = "actual_receive_org_name")
    private String actualReceiveOrgName; //实际收款组织名称
    @TableField(value = "confirm_receive")
    private Integer confirmReceive; //是否确认收款(1-已收款，0-未收款[为空默认未收款])

    /**
     * 来源ID
     */
    @TableField("source_id")
    private String sourceId;

    /**
     * 部门主键
     */
    @TableField("dept_id")
    private Long deptId;

    /**
     * 部门名称
     */
    @TableField("dept_name")
    private String deptName;

    /**
     * 结算状态
     */
    @TableField("settle_status")
    private String settleStatus;

    /**
     * 结算状态名称
     */
    @TableField("settle_status_name")
    private String settleStatusName;

    /**
     * 现金流量
     */
    @TableField("cash_item_id")
    private Long cashItemId;

    /**
     * 现金流量名称
     */
    @TableField("cash_item_name")
    private String cashItemName;


    @TableField(exist=false)
    @SubEntity(serviceName="receiveReceiptService",pidName = "receiveId")
    private List<ReceiveReceiptEntity> receiveReceiptEntityList = new ArrayList<>();


    public List<ReceiveReceiptEntity> getReceiveReceiptEntityList() {
        return receiveReceiptEntityList;
    }

    public void setReceiveReceiptEntityList(List<ReceiveReceiptEntity> receiveReceiptEntityList) {
        this.receiveReceiptEntityList = receiveReceiptEntityList;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getReceiveType() {
        return receiveType;
    }

    public void setReceiveType(Long receiveType) {
        this.receiveType = receiveType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getReceiveWay() {
        return receiveWay;
    }

    public void setReceiveWay(Long receiveWay) {
        this.receiveWay = receiveWay;
    }

    public BigDecimal getReceiveMny() {
        return receiveMny;
    }

    public void setReceiveMny(BigDecimal receiveMny) {
        this.receiveMny = receiveMny;
    }

    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public String getReceiveExplain() {
        return receiveExplain;
    }

    public void setReceiveExplain(String receiveExplain) {
        this.receiveExplain = receiveExplain;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public Long getReceiveOrgId() {
        return receiveOrgId;
    }

    public void setReceiveOrgId(Long receiveOrgId) {
        this.receiveOrgId = receiveOrgId;
    }

    public String getReceiveOrgName() {
        return receiveOrgName;
    }

    public void setReceiveOrgName(String receiveOrgName) {
        this.receiveOrgName = receiveOrgName;
    }

    public Long getActualReceiveOrgId() {
        return actualReceiveOrgId;
    }

    public void setActualReceiveOrgId(Long actualReceiveOrgId) {
        this.actualReceiveOrgId = actualReceiveOrgId;
    }

    public String getActualReceiveOrgName() {
        return actualReceiveOrgName;
    }

    public void setActualReceiveOrgName(String actualReceiveOrgName) {
        this.actualReceiveOrgName = actualReceiveOrgName;
    }

    public Integer getConfirmReceive() {
        return confirmReceive;
    }

    public void setConfirmReceive(Integer confirmReceive) {
        this.confirmReceive = confirmReceive;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getSettleStatus() {
        return settleStatus;
    }

    public void setSettleStatus(String settleStatus) {
        this.settleStatus = settleStatus;
    }

    public String getSettleStatusName() {
        return settleStatusName;
    }

    public void setSettleStatusName(String settleStatusName) {
        this.settleStatusName = settleStatusName;
    }

    public Long getCashItemId() {
        return cashItemId;
    }

    public void setCashItemId(Long cashItemId) {
        this.cashItemId = cashItemId;
    }

    public String getCashItemName() {
        return cashItemName;
    }

    public void setCashItemName(String cashItemName) {
        this.cashItemName = cashItemName;
    }
}
