package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Controller
@RequestMapping("/paySporadic")
public class PaySporadicController {

    @Autowired
    private IPaySporadicService paySporadicService;

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param paySporadicVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PaySporadicVO> saveOrUpdate(@RequestBody PaySporadicVO paySporadicVO) {
        PaySporadicVO backVO = paySporadicService.insertOrUpdate(paySporadicVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaySporadicVO> queryDetail(Long id) {
        PaySporadicVO backVO = paySporadicService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PaySporadic", paySporadicService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
        JSONObject page = paySporadicService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryApproveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("approveTime", QueryParam.DESC);
        JSONObject page = paySporadicService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaySporadicVO> vos) {
        List<Long> ids = vos.stream().map(PaySporadicVO::getId).collect(Collectors.toList());
        String msg = paySporadicService.delete(ids);
        return CommonResponse.success(msg);
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<PaySporadicVO> supplierVos = paySporadicService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("sporadic-payapply-export.xlsx", beans, response);
    }

    /**
     * 查询收款账户信息
     * @param supplierId
     * @return
     */
    @RequestMapping(value = "/queryReceiveInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaySporadicVO> queryReceiveInfo(Long supplierId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<PaySporadicEntity> entityList = paySporadicService.queryList(queryParam,false);
        PaySporadicVO backVO = !entityList.isEmpty() ? BeanMapper.map( entityList.get(0), PaySporadicVO.class) : new PaySporadicVO();
        return CommonResponse.success("查询数据成功！", backVO);
    }
    /**成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PaySporadicVO> pushCost(@RequestBody PaySporadicVO paySporadicVO) {
        return paySporadicService.pushCost(paySporadicVO);
    }

    /**
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
        return CommonResponse.success("查询成功！", paySporadicService.getTotalColumnInfo(param, false));
    }

    /**
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取支出管理 合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getApproveTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        // 已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("approveTime", QueryParam.DESC);
        return CommonResponse.success("查询成功！", paySporadicService.getApproveTotalColumnInfo(param, false));
    }

}
