package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpDealMapper;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.PayBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.PayBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金办理表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondUpDealServiceImpl extends BaseServiceImpl<BondUpDealMapper, BondUpDealEntity> implements IBondUpDealService {

    private static final String BONGUP_DEAL = "BONGUP_DEAL";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private NCUtil ncUtil;


    @Override
    public BondUpDealVO insertOrUpdate(BondUpDealVO bondUpDealVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondUpDealEntity> entities = null;
        if(StringUtils.isEmpty(bondUpDealVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGUP_DEAL,tenantId);
            if(billCode.isSuccess()) {
                bondUpDealVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondUpDealEntity entity = BeanMapper.map(bondUpDealVO, BondUpDealEntity.class);
        if(null!=bondUpDealVO.getId()&&bondUpDealVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
            lambda.eq(BondUpDealEntity::getBillCode, bondUpDealVO.getBillCode());
            lambda.eq(BondUpDealEntity::getTenantId, tenantId);
            lambda.ne(BondUpDealEntity::getId, bondUpDealVO.getId());
            entities = super.list(lambda);
            //需要将本次数据新增，将之前数据改为作废
            LambdaUpdateWrapper<BondUpDealEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(BondUpDealEntity::getId,entity.getId());
            updateWrapper.set(BondUpDealEntity::getDealStatus,"2");
            super.update(updateWrapper);
            entity.setId(null);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
            lambda.eq(BondUpDealEntity::getTenantId, tenantId);
            lambda.eq(BondUpDealEntity::getBillCode, bondUpDealVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate(entity,false);
        //回写申请单
        LambdaUpdateWrapper<BondUpEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondUpEntity::getId,entity.getBondId());
        updateWrapper.set(BondUpEntity::getBondStatus,"1");
        updateWrapper.set(BondUpEntity::getBeginDate,entity.getBeginDate());
        updateWrapper.set(BondUpEntity::getEndDate,entity.getEndDate());
        updateWrapper.set(BondUpEntity::getEmployeeId,entity.getEmployeeId());
        updateWrapper.set(BondUpEntity::getEmployeeName,entity.getEmployeeName());
        updateWrapper.set(BondUpEntity::getPayMny,entity.getBondMny());
        updateWrapper.set(BondUpEntity::getBondType,entity.getBondType());
        updateWrapper.set(BondUpEntity::getDealTime,entity.getDealTime());
        bondUpService.update(updateWrapper);
        //推送凭证
        BondUpEntity upEntity = bondUpService.selectById(bondUpDealVO.getBondId());
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(upEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())){
            this.pushToNC(upEntity,entity);
        }
        return BeanMapper.map(entity, BondUpDealVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = bondUpService.selectById(id);
        LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
        lambda.eq(BondUpDealEntity::getBondId, id);
        lambda.orderBy(true,true,BondUpDealEntity::getDealStatus);
        List<BondUpDealEntity> list = super.list(lambda);
        vo = BeanMapper.map(upEntity,BondUpDealRentVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setDealRecord(BeanMapper.mapList(list,BondUpDealVO.class));
        }
        return vo;
    }

    /**
     * 推送NC传付款单凭证
     * @param entity
     */
    private void pushToNC(BondUpEntity entity,BondUpDealEntity upDealEntity) {
        PayBillVO vo = this.transferToNCVO(entity,upDealEntity);// 转换成NCVO
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        StringBuffer sb = new StringBuffer();
        if(entity.getApplyOrgId().equals(entity.getActualOrgId())){
            //【付款组织】和【实际付款组织】相同
            //根据开票主体决定传多少个凭证
//            List<Long> orgIds = ncUtil.validateDaoQiaoOrg(entity.getApplyOrgId(), project.getInvoiceMainCategory());
            List<Long> orgIds = ncUtil.validateInvoiceMainOrg(entity.getApplyOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds){
                OrgVO orgVO = ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
                sb.append(sourceId).append(",");
            }
        }else{
            //【收款组织】和【实际收款组织】不同
            //先传付款组织
            //根据开票主体决定传多少个凭证
//            List<Long> orgIds = ncUtil.validateDaoQiaoOrg(entity.getApplyOrgId(), project.getInvoiceMainCategory());
            List<Long> orgIds = ncUtil.validateInvoiceMainOrg(entity.getApplyOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds){
                OrgVO orgVO = ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
                sb.append(sourceId).append(",");
            }
            //再先传实际付款组织
            BankAccountVO bankAccountVO2 = ncUtil.queryDefaultBankAccountById(entity.getActualOrgId(), "insideOrgId");//根据付款组织查银行账户
            PayBillDetailVO payBillDetailVO2 = vo.getDetail().get(0);
            payBillDetailVO2.setBankaccount(bankAccountVO2.getBankCode()); //传实际付款组织的银行账户
            //根据开票主体决定传多少个凭证
//            List<Long> orgIds2 = ncUtil.validateDaoQiaoOrg(entity.getActualOrgId(), project.getInvoiceMainCategory());
            List<Long> orgIds2 = ncUtil.validateInvoiceMainOrg(entity.getActualOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds2){
                OrgVO orgVO = ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
                sb.append(sourceId).append(",");
            }
        }
        String sourceIds = sb.substring(0,sb.length()-1);
        LambdaUpdateWrapper<BondUpEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(BondUpEntity::getSourceId, sourceIds);// 保存来源主键
        wrapper.eq(BondUpEntity::getId, entity.getId());
        bondUpService.update(wrapper);
        LambdaUpdateWrapper<BondUpDealEntity> lambda = new LambdaUpdateWrapper<>();
        lambda.set(BondUpDealEntity::getSourceId, sourceIds);// 保存来源主键
        lambda.eq(BondUpDealEntity::getId, upDealEntity.getId());
        this.update(lambda);
    }

    /**
     * 转换成NCVO
     * @param entity
     * @return
     */
    private PayBillVO transferToNCVO(BondUpEntity entity,BondUpDealEntity bondUpDealEntity){
        logger.info("----付款单传凭证开始:");
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
        CustomerVO customerVO = ncUtil.queryCustomerById(entity.getCustomerId());
        PayBillVO vo = new PayBillVO();
        vo.setBusitype("paybill");// 业务标识
        vo.setTradetype("F3-Cxx-006");// 交易类型
        vo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
        vo.setPk_dept(String.valueOf(project.getDeptId()));// 部门主键
        vo.setDef12(String.valueOf(entity.getId()));// PM单据主键
        vo.setDef19(bondUpDealEntity.getBillCode());//单据编号
        vo.setDef1(false);
        vo.setPk_supplier("1001A11000000009VTP1");
        vo.setDef17(String.valueOf(entity.getCustomerId()));//自定义字段 供商id
        vo.setDef6(customerVO.getInsideOrgId() != null);// 是否内部单位 true/false
//        vo.setBalatype(ncUtil.getDefDocById(entity.getPaymentWay()).getCode()); //结算方式
        vo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/bondManageList/bondUpDetailManage?id=" + entity.getId()));// 外部访问url
        vo.setDef21("BT200616000000003");// 单据类型

        List<PayBillDetailVO> detailVOS = new ArrayList<>();
        PayBillDetailVO detailVO = new PayBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setLocal_mny(bondUpDealEntity.getBondMny());
        BankAccountVO bankAccountVO = ncUtil.queryDefaultBankAccountById(entity.getApplyOrgId(), "insideOrgId");//根据付款组织查银行账户
        detailVO.setBankaccount(bankAccountVO.getBankCode()); //传付款组织的银行账户
        detailVO.setCashitem(ncUtil.getDefDocById(entity.getCashItemId()).getCode()); //现金流量
        detailVO.setBalatype(ncUtil.getDefDocById(entity.getPaymentWay()).getCode()); //结算方式
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return  vo;
    }
}
