package com.ejianc.business.finance.service;

import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.finance.bean.LoadReimburseEntity;

import java.util.List;
import java.util.Map;

/**
 * 借款报销
 * 
 * @author generator
 * 
 */
public interface ILoadReimburseService extends IBaseService<LoadReimburseEntity> {
    LoadReimburseVO insertOrUpdate(LoadReimburseVO loadReimburseVO);

    /**
     * 统计借款报销本次报销金额总数（属于项目的单据）
     *
     * @param tenantId 租户Id
     * @param projectIds 待过滤的项目ID列表
     * @return
     */
    Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds);

    CommonResponse<LoadReimburseVO> pushCost(LoadReimburseVO loadReimburseVO);

    void costPush(LoadReimburseEntity loadReimburseEntity);

    //成本改造
    void pullCost(Long id);
}
