package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.mapper.BondDownBackMapper;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BondDownBackVO;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.PayBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.PayBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金退还表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondDownBackServiceImpl extends BaseServiceImpl<BondDownBackMapper, BondDownBackEntity> implements IBondDownBackService {
    private static final String BONGDOWN_BACK = "BONGDOWN_BACK";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBondDownService bondDownService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private NCUtil ncUtil;

    @Override
    public BondDownBackVO insertOrUpdate(BondDownBackVO bondDownBackVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondDownBackEntity> entities = null;
        if(StringUtils.isEmpty(bondDownBackVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGDOWN_BACK,tenantId);
            if(billCode.isSuccess()) {
                bondDownBackVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondDownBackEntity entity = BeanMapper.map(bondDownBackVO, BondDownBackEntity.class);
        if(null!=bondDownBackVO.getId()&&bondDownBackVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondDownBackEntity> lambda = Wrappers.<BondDownBackEntity>lambdaQuery();
            lambda.eq(BondDownBackEntity::getBillCode, bondDownBackVO.getBillCode());
            lambda.eq(BondDownBackEntity::getTenantId, tenantId);
            lambda.ne(BondDownBackEntity::getId, bondDownBackVO.getId());
            entities = super.list(lambda);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondDownBackEntity> lambda = Wrappers.<BondDownBackEntity>lambdaQuery();
            lambda.eq(BondDownBackEntity::getTenantId, tenantId);
            lambda.eq(BondDownBackEntity::getBillCode, bondDownBackVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBackTime(new Date());
        super.saveOrUpdate(entity,false);
        //回写申请单
        BondDownEntity upentity= bondDownService.selectById(bondDownBackVO.getBondId());
        BigDecimal sumBackMny = upentity.getBackMny()==null?BigDecimal.ZERO:upentity.getBackMny();
        BigDecimal applyMny = upentity.getApplyMny()==null?BigDecimal.ZERO:upentity.getApplyMny();
        if(applyMny.compareTo(sumBackMny.add(entity.getBackMny()))<0){
            throw new BusinessException("本次退还金额不能超过剩余金额!");
        }
        LambdaUpdateWrapper<BondDownEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondDownEntity::getId,entity.getBondId());
        updateWrapper.set(BondDownEntity::getBackMny,sumBackMny.add(entity.getBackMny()));
        bondDownService.update(updateWrapper);
        //推送凭证
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(upentity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())){
            this.pushToNC(upentity,entity);
        }
        return BeanMapper.map(entity, BondDownBackVO.class);
    }

    @Override
    public BondDownDealRentVO queryDetail(Long id) {
        BondDownDealRentVO vo = new BondDownDealRentVO();
        BondDownEntity upEntity = bondDownService.selectById(id);
        LambdaQueryWrapper<BondDownBackEntity> lambda = Wrappers.<BondDownBackEntity>lambdaQuery();
        lambda.eq(BondDownBackEntity::getBondId, id);
        lambda.orderBy(true,false,BondDownBackEntity::getBackTime);
        List<BondDownBackEntity> list = super.list(lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny()==null?BigDecimal.ZERO:upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny()==null?BigDecimal.ZERO:upEntity.getContractTaxMny());
        vo.setBackMny(upEntity.getBackMny()==null?BigDecimal.ZERO:upEntity.getBackMny());
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if(CollectionUtils.isNotEmpty(list)){
            vo.setBackRecord(BeanMapper.mapList(list,BondDownBackVO.class));
        }
        return vo;
    }

    /**
     * 推送NC传付款单凭证
     * @param entity
     */
    private void pushToNC(BondDownEntity entity,BondDownBackEntity bondDownBackEntity) {
        PayBillVO vo = this.transferToNCVO(entity,bondDownBackEntity);// 转换成NCVO
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        StringBuffer sb = new StringBuffer();
        if(entity.getPaymentOrgId().equals(entity.getActualOrgId())){
            //【付款组织】和【实际付款组织】相同
            //根据开票主体决定传多少个凭证
//            List<Long> orgIds = ncUtil.validateDaoQiaoOrg(entity.getPaymentOrgId(), project.getInvoiceMainCategory());
            List<Long> orgIds = ncUtil.validateInvoiceMainOrg(entity.getPaymentOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds){
                OrgVO orgVO = ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
                sb.append(sourceId).append(",");
            }
        }else{
            //【收款组织】和【实际收款组织】不同
            //先传付款组织
            //根据开票主体决定传多少个凭证
//            List<Long> orgIds = ncUtil.validateDaoQiaoOrg(entity.getPaymentOrgId(), project.getInvoiceMainCategory());
            List<Long> orgIds = ncUtil.validateInvoiceMainOrg(entity.getPaymentOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds){
                OrgVO orgVO = ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
                sb.append(sourceId).append(",");
            }
            //再先传实际付款组织
            BankAccountVO bankAccountVO2 = ncUtil.queryDefaultBankAccountById(entity.getActualOrgId(), "insideOrgId");//根据付款组织查银行账户
            PayBillDetailVO payBillDetailVO2 = vo.getDetail().get(0);
            payBillDetailVO2.setBankaccount(bankAccountVO2.getBankCode()); //传实际付款组织的银行账户
            //根据开票主体决定传多少个凭证
//            List<Long> orgIds2 = ncUtil.validateDaoQiaoOrg(entity.getActualOrgId(), project.getInvoiceMainCategory());
            List<Long> orgIds2 = ncUtil.validateInvoiceMainOrg(entity.getActualOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds2){
                OrgVO orgVO = ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
                sb.append(sourceId).append(",");
            }
        }
        String sourceIds = sb.substring(0,sb.length()-1);
        // 多次退回，主表拼接多次记录
        LambdaQueryWrapper<BondDownEntity> ew = new LambdaQueryWrapper<>();
        BondDownEntity data = bondDownService.getById(entity.getId());
        String dataSourceIds = data.getSourceBackId();
        dataSourceIds = StringUtils.isNotEmpty(dataSourceIds) ? dataSourceIds + "," + sourceIds : sourceIds;
        LambdaUpdateWrapper<BondDownEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(BondDownEntity::getSourceBackId, dataSourceIds);// 保存来源主键
        wrapper.eq(BondDownEntity::getId, entity.getId());

        bondDownService.update(wrapper);
        LambdaUpdateWrapper<BondDownBackEntity> lambda = new LambdaUpdateWrapper<>();
        lambda.set(BondDownBackEntity::getSourceBackId, sourceIds);// 保存来源主键
        lambda.eq(BondDownBackEntity::getId, bondDownBackEntity.getId());
        this.update(lambda);
    }

    /**
     * 转换成NCVO
     * @param entity
     * @return
     */
    private PayBillVO transferToNCVO(BondDownEntity entity,BondDownBackEntity bondDownBackEntity){
        logger.info("----付款单传凭证开始:");
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
//        OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
        SupplierVO supplierVO = ncUtil.querySupplierById(entity.getSupplierId());
        PayBillVO vo = new PayBillVO();
        vo.setBusitype("paybill");// 业务标识
        vo.setTradetype("F3-Cxx-007");// 交易类型
        vo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
        vo.setPk_dept(String.valueOf(project.getDeptId()));// 部门主键
        vo.setDef12(String.valueOf(entity.getId()));// PM单据主键
        vo.setDef19(bondDownBackEntity.getBillCode());//单据编号
        vo.setDef1(false);//默认false
        //vo.setPk_org(orgVO.getCode());// 财务组织编码
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));
        vo.setDef6(supplierVO.getInsideOrgId() != null);// 是否内部单位 true/false
//        vo.setBalatype(ncUtil.getDefDocById(entity.getPaymentWay()).getCode()); //结算方式
        vo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/bondManageList/bondDownDetailManage?id=" + entity.getId()));// 外部访问url
        vo.setDef21("BT200616000000004");// 单据类型

        List<PayBillDetailVO> detailVOS = new ArrayList<>();
        PayBillDetailVO detailVO = new PayBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setLocal_mny(bondDownBackEntity.getBackMny());
        BankAccountVO bankAccountVO = ncUtil.queryDefaultBankAccountById(entity.getPaymentOrgId(), "insideOrgId");//根据付款组织查银行账户
        detailVO.setBankaccount(bankAccountVO.getBankCode()); //传付款组织的银行账户
        detailVO.setCashitem(ncUtil.getDefDocById(entity.getCashItemId()).getCode()); //现金流量
        detailVO.setBalatype(ncUtil.getDefDocById(entity.getPaymentWay()).getCode()); //结算方式
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return  vo;
    }
}
