/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.FinanceCostVO;
import com.ejianc.business.finance.vo.FinanceMonthVO;
import com.ejianc.business.finance.vo.ManageDetailVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.PayApplyPubVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.SumMnyStatisticVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/payContract"})
public class PayContractController {
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayContractVO> saveOrUpdate(@RequestBody PayContractVO payContractVO) {
        PayContractVO backVO = this.contractService.insertOrUpdate(payContractVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> queryDetail(Long id) {
        PayContractVO backVO = this.contractService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayContract", (Object)this.contractService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        JSONObject page = this.contractService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        JSONObject page = this.contractService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayContractVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.contractService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<PayContractVO> supplierVos = this.contractService.queryExportList(queryParam);
        HashMap<String, List<PayContractVO>> beans = new HashMap<String, List<PayContractVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("contract-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryContractRefer"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryContractRefer(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject obj = JSONObject.parseObject((String)condition);
            if (condition.contains("projectId")) {
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)obj.getLong("projectId")));
            }
        }
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        CommonResponse apiContract = this.equipmentContractApi.getContract(queryParam);
        JSONObject page = new JSONObject();
        if (!apiContract.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        page = (JSONObject)apiContract.getData();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/querySettleRefer"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> querySettleRefer(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        Integer contractType = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject obj = JSONObject.parseObject((String)condition);
            if (!condition.contains("contractId")) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11contractId\uff01");
            }
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)obj.getLong("contractId")));
            if (condition.contains("projectId")) {
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)obj.getLong("projectId")));
            }
            if (!condition.contains("orgId")) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)obj.getLong("orgId")));
            if (condition.contains("contractType")) {
                contractType = obj.getInteger("contractType");
            } else {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11contractType\uff01");
            }
        }
        JSONObject page = this.contractService.querySettleRefer(queryParam, contractType);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryReceiveInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> queryReceiveInfo(Long receiveUnitId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("receiveUnitId", new Parameter("eq", (Object)receiveUnitId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.contractService.queryList(queryParam, false);
        PayContractVO backVO = !entityList.isEmpty() ? (PayContractVO)BeanMapper.map(entityList.get(0), PayContractVO.class) : new PayContractVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"getSumPayMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SumPayMnyVO> getSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="orgId", required=true) Long orgId) {
        SumPayMnyVO vo = this.contractService.getSumPayMny(contractId, orgId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryPendingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryPendingList(@RequestBody QueryParam param) {
        JSONObject page = this.contractService.queryPendingPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelExportPending"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportPending(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<PayApplyPubVO> records = this.contractService.queryExportPendingList(queryParam);
        HashMap<String, List<PayApplyPubVO>> beans = new HashMap<String, List<PayApplyPubVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("pending-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/batchConfirm"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> batchConfirm(@RequestBody List<PayApplyPubVO> vos) {
        String msg = this.contractService.batchConfirm(vos);
        return CommonResponse.success((String)"\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01");
    }

    @RequestMapping(value={"getStatisticsMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SumMnyStatisticVO> getStatisticsMny() {
        SumMnyStatisticVO vo = this.contractService.getStatisticsMny();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"getManageDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ManageDetailVO> getManageDetail(@RequestParam(value="projectId", required=true) Long projectId) {
        ManageDetailVO vo = this.contractService.getManageDetail(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"getTotalPayApplyAmountByProjectIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getTotalPayApplyAmountByProjectIds(@RequestBody Long orgId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List contractEntities = this.contractService.queryList(queryParam, false);
        BigDecimal payApplyAmount = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            for (PayContractEntity p : contractEntities) {
                if (p.getPayMny() == null) continue;
                payApplyAmount = MathUtil.safeAdd((BigDecimal)payApplyAmount, (BigDecimal)p.getPayMny());
            }
        }
        JSONObject back = new JSONObject();
        back.put("payApplyAmount", (Object)payApplyAmount);
        return CommonResponse.success((Object)back);
    }

    @RequestMapping(value={"getMonthInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<FinanceMonthVO>> getMonthInfo(@RequestParam(value="projectId", required=true) Long projectId, @RequestParam(value="timeRange", required=false) String timeRange) {
        List<FinanceMonthVO> list = this.contractService.getMonthInfo(projectId, timeRange);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"getCostInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<FinanceCostVO>> getCostInfo(@RequestParam(value="projectId", required=true) Long projectId) {
        List<FinanceCostVO> list = this.contractService.getCostInfo(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"getTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getApproveTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getApproveTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getPendingTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getPendingTotalColumnInfo(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getPendingTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType, @RequestParam(value="sumPayMny") BigDecimal sumPayMny, @RequestParam(value="payMny") BigDecimal payMny, @RequestParam(value="contractMny") BigDecimal contractMny) {
        ParamsCheckVO paramsCheckVO = this.contractService.checkParams(purchaseType, sumPayMny, payMny, contractMny);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }
}

