/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayForegiftPlanEntity;
import com.ejianc.business.finance.bean.PayForegiftRecordEntity;
import com.ejianc.business.finance.mapper.PayForegiftMapper;
import com.ejianc.business.finance.service.IPayForegiftPlanService;
import com.ejianc.business.finance.service.IPayForegiftRecordService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.vo.PayForegiftPlanVO;
import com.ejianc.business.finance.vo.PayForegiftRecordVO;
import com.ejianc.business.finance.vo.PayForegiftVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayForegiftServiceImpl
extends BaseServiceImpl<PayForegiftMapper, PayForegiftEntity>
implements IPayForegiftService {
    private static final String PAY_FOREGIFT_BILL_CODE = "PAY_FOREGIFT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayForegiftPlanService planService;
    @Autowired
    private IPayForegiftRecordService recordService;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public PayForegiftVO insertOrUpdate(PayForegiftVO vo) {
        PayForegiftEntity entity = (PayForegiftEntity)((Object)BeanMapper.map((Object)vo, PayForegiftEntity.class));
        if (!vo.getManageFlag()) {
            this.validateBeforeSave(entity);
        }
        String billTypeCode = BillTypeCodeEnum.getContractBillTypeCode((Long)vo.getContractType());
        if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(vo.getContractId()), (String)billTypeCode, (Integer)vo.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        this.autoSetBillCode(entity);
        super.saveOrUpdate((Object)entity);
        Long id = entity.getId();
        List<PayForegiftPlanVO> planVOList = this.updatePlanVOList(vo, id);
        List<PayForegiftRecordVO> recordVOList = this.updateRecordVOList(vo, id);
        PayForegiftVO backVO = (PayForegiftVO)BeanMapper.map((Object)super.getById((Serializable)id), PayForegiftVO.class);
        backVO.setPlanVOList(planVOList);
        backVO.setRecordVOList(recordVOList);
        return backVO;
    }

    private List<PayForegiftPlanVO> updatePlanVOList(PayForegiftVO foregiftVO, Long payapplyId) {
        List planVOList = foregiftVO.getPlanVOList();
        if (planVOList != null && !planVOList.isEmpty()) {
            List planEntityList = BeanMapper.mapList((Iterable)planVOList, PayForegiftPlanEntity.class);
            this.savePlanTime(payapplyId, planEntityList);
            this.planService.saveOrUpdateBatch(planEntityList, planEntityList.size(), false);
            planVOList = BeanMapper.mapList((Iterable)planEntityList, PayForegiftPlanVO.class);
        }
        List ids = planVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)payapplyId);
        wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        this.planService.remove((Wrapper)wrapper, false);
        return planVOList;
    }

    private void savePlanTime(Long payapplyId, List<PayForegiftPlanEntity> planEntityList) {
        Date planTime = null;
        Date newTime = new Date();
        for (PayForegiftPlanEntity planEntity : planEntityList) {
            planEntity.setPayapplyId(payapplyId);
            if (!planEntity.getPlanTime().after(newTime)) continue;
            if (planTime == null) {
                planTime = planEntity.getPlanTime();
                continue;
            }
            planTime = planTime.before(planEntity.getPlanTime()) ? planTime : planEntity.getPlanTime();
        }
        if (planTime != null) {
            PayForegiftEntity forgiftEntity = (PayForegiftEntity)((Object)((PayForegiftMapper)this.baseMapper).selectById(payapplyId));
            forgiftEntity.setPlanTime(planTime);
            super.saveOrUpdate((Object)forgiftEntity);
        }
    }

    private List<PayForegiftRecordVO> updateRecordVOList(PayForegiftVO foregiftVO, Long payapplyId) {
        List recordVOList = foregiftVO.getRecordVOList();
        if (recordVOList != null && !recordVOList.isEmpty()) {
            List recordEntityList = BeanMapper.mapList((Iterable)recordVOList, PayForegiftRecordEntity.class);
            for (PayForegiftRecordEntity recordEntity : recordEntityList) {
                recordEntity.setPayapplyId(payapplyId);
            }
            this.recordService.saveOrUpdateBatch(recordEntityList, recordEntityList.size(), false);
            recordVOList = BeanMapper.mapList((Iterable)recordEntityList, PayForegiftRecordVO.class);
        }
        if (recordVOList != null) {
            List ids = recordVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)payapplyId);
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
            this.recordService.remove((Wrapper)wrapper, false);
        }
        return recordVOList;
    }

    @Override
    public PayForegiftVO queryDetail(Long id) {
        PayForegiftEntity entity = (PayForegiftEntity)((Object)((PayForegiftMapper)this.baseMapper).selectById(id));
        PayForegiftVO vo = (PayForegiftVO)BeanMapper.map((Object)((Object)entity), PayForegiftVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List payForegiftPlanEntityList = this.planService.queryList(queryParam, false);
        vo.setPlanVOList(BeanMapper.mapList((Iterable)payForegiftPlanEntityList, PayForegiftPlanVO.class));
        List payForegiftRecordEntityList = this.recordService.queryList(queryParam, false);
        vo.setRecordVOList(BeanMapper.mapList((Iterable)payForegiftRecordEntityList, PayForegiftRecordVO.class));
        return vo;
    }

    @Override
    public List<PayForegiftVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PayForegiftVO vo = (PayForegiftVO)resVos.get(i);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.removeByIds(ids, false);
            this.planService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            this.recordService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("payReason");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        this.dealQueryParaam(param);
        IPage pageData = super.queryPage(param, false);
        List voList = BeanMapper.mapList((Iterable)pageData.getRecords(), PayForegiftVO.class);
        this.dealPlanTime(voList);
        JSONObject page = new JSONObject();
        page.put("records", (Object)voList);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return page;
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        this.dealQueryParaam(param);
        List list = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, PayForegiftVO.class);
        this.dealPlanTime(voList);
        BigDecimal sumApplyMny = voList.stream().filter(entity -> entity.getApplyMny() != null).map(PayForegiftVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = voList.stream().filter(entity -> entity.getPayMny() != null).map(PayForegiftVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        this.dealQueryParaam(param);
        List list = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, PayForegiftVO.class);
        this.dealPlanTime(voList);
        BigDecimal sumApplyMny = voList.stream().filter(entity -> entity.getApplyMny() != null).map(PayForegiftVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = voList.stream().filter(entity -> entity.getPayMny() != null).map(PayForegiftVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    private void dealPlanTime(List<PayForegiftVO> voList) {
        for (PayForegiftVO vo : voList) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
            queryParam.getParams().put("planTime", new Parameter("ge", (Object)new Date()));
            queryParam.getOrderMap().put("planTime", "asc");
            List entityList = this.planService.queryList(queryParam, false);
            Date planTime = null;
            for (PayForegiftPlanEntity entity : entityList) {
                if (planTime == null) {
                    planTime = entity.getPlanTime();
                    continue;
                }
                planTime = planTime.before(entity.getPlanTime()) ? planTime : entity.getPlanTime();
            }
            vo.setPlanTime(planTime);
        }
    }

    private void dealQueryParaam(QueryParam param) {
        Parameter parameter;
        Map parameterMap = param.getParams();
        if (parameterMap.containsKey("overdueFlag")) {
            parameter = (Parameter)parameterMap.get("overdueFlag");
            if (!"1,2".equals(parameter.getValue()) && !"2,1".equals(parameter.getValue())) {
                Integer flag = Integer.parseInt(String.valueOf(parameter.getValue()));
                List<Long> ids = ((PayForegiftMapper)this.baseMapper).queryIdsByFlag(flag);
                if (!ids.isEmpty()) {
                    param.getParams().put("id", new Parameter("in", ids));
                } else {
                    param.getParams().put("1", new Parameter("eq", (Object)0));
                }
            }
            parameterMap.remove("overdueFlag");
        }
        if (parameterMap.containsKey("returnAllFlag")) {
            parameter = (Parameter)parameterMap.get("returnAllFlag");
            if (!"1,2".equals(parameter.getValue()) && !"2,1".equals(parameter.getValue())) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                Integer status = Integer.parseInt(String.valueOf(parameter.getValue()));
                lambda.last(status == 1, "and return_mny >= apply_mny");
                lambda.last(status == 2, "and return_mny < apply_mny");
                List dataList = ((PayForegiftMapper)this.baseMapper).selectList((Wrapper)lambda);
                List ids = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                if (!ids.isEmpty()) {
                    param.getParams().put("id", new Parameter("in", ids));
                } else {
                    param.getParams().put("1", new Parameter("eq", (Object)0));
                }
            }
            parameterMap.remove("returnAllFlag");
        }
    }

    private void validateBeforeSave(PayForegiftEntity entity) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayForegiftEntity::getContractId, (Object)entity.getContractId());
        lambda.eq(PayForegiftEntity::getOrgId, (Object)entity.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        lambda.notIn(PayForegiftEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u540c\u4e00\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e,\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
    }

    private void autoSetBillCode(PayForegiftEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PAY_FOREGIFT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayForegiftEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }
}

