/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.bean.PaySporadicStockEntity;
import com.ejianc.business.finance.mapper.PaySporadicMapper;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IPaySporadicStockService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PaySporadicStockVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.material.api.IInstoreApi;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaySporadicServiceImpl
extends BaseServiceImpl<PaySporadicMapper, PaySporadicEntity>
implements IPaySporadicService {
    private static final String PAY_SPORADIC_BILL_CODE = "PAY_SPORADIC";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IInstoreApi instoreApi;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IPaySporadicStockService stockService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public PaySporadicVO insertOrUpdate(PaySporadicVO vo) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)BeanMapper.map((Object)vo, PaySporadicEntity.class));
        if (!vo.getManageFlag()) {
            this.validateBeforeSave(entity);
        }
        this.autoSetBillCode(entity);
        List stockVO = vo.getStockVOList();
        if (ListUtil.isNotEmpty((List)stockVO)) {
            entity.setInputFlag("1");
        } else {
            entity.setInputFlag("0");
        }
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        if (StringUtils.isEmpty((String)entity.getInvoiceFlag())) {
            entity.setInvoiceFlag("3");
        }
        super.saveOrUpdate((Object)entity);
        if (2 == vo.getPayStatus()) {
            PaySporadicEntity paySporadicEntity = (PaySporadicEntity)((Object)super.selectById((Serializable)entity.getId()));
            this.costPush(paySporadicEntity);
        }
        Long id = entity.getId();
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        List<PaySporadicStockVO> stockVOList = this.updateStockVOS(vo, id);
        PaySporadicVO backVO = (PaySporadicVO)BeanMapper.map((Object)super.getById((Serializable)id), PaySporadicVO.class);
        backVO.setInvoiceVOList(invoiceVOList);
        backVO.setStockVOList(stockVOList);
        return backVO;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PaySporadicVO vo, Long id) {
        List voList = vo.getInvoiceVOList();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u6536\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()).booleanValue()) {
                    throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                invoiceVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayInvoiceVO.class);
        }
        List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        this.invoiceService.remove((Wrapper)wrapper, false);
        return voList;
    }

    private List<PaySporadicStockVO> updateStockVOS(PaySporadicVO vo, Long id) {
        List voList = vo.getStockVOList();
        ArrayList<InstoreVO> instoreVOList = new ArrayList<InstoreVO>();
        ArrayList<Long> stockIds = new ArrayList<Long>();
        if (voList != null && !voList.isEmpty()) {
            for (PaySporadicStockVO stockVO : voList) {
                if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(stockVO.getStockId()), (String)BillTypeCodeEnum.\u7269\u8d44\u5165\u5e93.getBillTypeCode(), (Integer)stockVO.getStockVersion()).booleanValue()) {
                    throw new BusinessException("\u5165\u5e93\u5355\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                stockVO.setPayapplyId(id);
                InstoreVO instoreVO = new InstoreVO();
                instoreVO.setId(stockVO.getStockId());
                instoreVO.setPaymentFlag(Integer.valueOf(1));
                stockIds.add(stockVO.getStockId());
                instoreVOList.add(instoreVO);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PaySporadicStockEntity.class);
            this.stockService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PaySporadicStockVO.class);
        }
        List voIds = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List dataList = this.stockService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)id));
        List dataIds = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        dataIds.removeAll(voIds);
        List delIds = dataIds;
        if (!delIds.isEmpty()) {
            this.stockService.remove((Wrapper)new QueryWrapper().in((Object)"id", delIds), false);
        }
        for (PaySporadicStockEntity data : dataList) {
            if (!delIds.contains(data.getId()) || stockIds.contains(data.getStockId())) continue;
            InstoreVO instoreVO = new InstoreVO();
            instoreVO.setId(data.getStockId());
            instoreVO.setPaymentFlag(Integer.valueOf(0));
            instoreVOList.add(instoreVO);
        }
        if (!instoreVOList.isEmpty()) {
            this.instoreApi.updatePayment(instoreVOList);
        }
        return voList;
    }

    @Override
    public PaySporadicVO queryDetail(Long id) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)((PaySporadicMapper)this.baseMapper).selectById(id));
        PaySporadicVO vo = (PaySporadicVO)BeanMapper.map((Object)((Object)entity), PaySporadicVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, PayInvoiceVO.class));
        List stockEntityList = this.stockService.queryList(queryParam, false);
        vo.setStockVOList(BeanMapper.mapList((Iterable)stockEntityList, PaySporadicStockVO.class));
        return vo;
    }

    @Override
    public List<PaySporadicVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PaySporadicVO vo = (PaySporadicVO)resVos.get(i);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.removeByIds(ids, false);
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().in((Object)"payapply_id", ids);
            this.invoiceService.remove((Wrapper)wrapper, false);
            List stockList = this.stockService.list((Wrapper)wrapper);
            this.stockService.remove((Wrapper)wrapper, false);
            ArrayList<InstoreVO> instoreVOList = new ArrayList<InstoreVO>();
            for (PaySporadicStockEntity data : stockList) {
                InstoreVO instoreVO = new InstoreVO();
                instoreVO.setId(data.getStockId());
                instoreVO.setPaymentFlag(Integer.valueOf(0));
                instoreVOList.add(instoreVO);
            }
            if (!instoreVOList.isEmpty()) {
                this.instoreApi.updatePayment(instoreVOList);
            }
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("payReason");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PaySporadicServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PaySporadicVO> list = ((PaySporadicMapper)this.baseMapper).queryPageList(pages, wrapper, flag);
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        queryWrapper.select(new String[]{"ifnull(sum(pay_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"pay_status", (Object)2);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public CommonResponse<PaySporadicVO> pushCost(PaySporadicVO paySporadicVO) {
        PaySporadicEntity paySporadicEntity = (PaySporadicEntity)((Object)((PaySporadicMapper)this.baseMapper).selectById(paySporadicVO.getId()));
        paySporadicEntity.setSubjectId(paySporadicVO.getSubjectId());
        paySporadicEntity.setSubjectName(paySporadicVO.getSubjectName());
        paySporadicEntity.setOrgSubjectId(paySporadicVO.getOrgSubjectId());
        paySporadicEntity.setAccountingId(paySporadicVO.getAccountingId());
        paySporadicEntity.setAccountingName(paySporadicVO.getAccountingName());
        paySporadicEntity.setOrgAccountingId(paySporadicVO.getOrgAccountingId());
        super.saveOrUpdate((Object)paySporadicEntity, false);
        if (paySporadicEntity.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || paySporadicEntity.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
            this.costPush(paySporadicEntity);
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)paySporadicEntity), PaySporadicVO.class));
    }

    @Override
    public void costPush(PaySporadicEntity paySporadicEntity) {
        if (!"1".equals(paySporadicEntity.getDependOnProject())) {
            return;
        }
        Long subjectId = paySporadicEntity.getSubjectId();
        Long accountingId = paySporadicEntity.getAccountingId();
        boolean newRelationFlag = true;
        if (null == subjectId && null == accountingId) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{paySporadicEntity.getId()});
        updateWrapper.set(PaySporadicEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = paySporadicEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(paySporadicEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(paySporadicEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && newRelationFlag) {
            this.saveCost(paySporadicEntity);
        }
    }

    private void saveCost(PaySporadicEntity paySporadicEntity) {
        CommonResponse stringCommonResponse;
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        if (paySporadicEntity.getSubjectId() != null && paySporadicEntity.getAccountingId() != null) {
            CostDetailVO costDetailVO = new CostDetailVO();
            costDetailVO.setSubjectId(paySporadicEntity.getSubjectId());
            costDetailVO.setSourceId(paySporadicEntity.getId());
            costDetailVO.setSourceDetailId(paySporadicEntity.getId());
            costDetailVO.setHappenTaxMny(paySporadicEntity.getPayMny());
            costDetailVO.setHappenMny(paySporadicEntity.getPayMny());
            costDetailVO.setHappenDate(paySporadicEntity.getApplyTime());
            costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
            costDetailVO.setSourceType(PAY_SPORADIC_BILL_CODE);
            costDetailVO.setSourceTabType(PAY_SPORADIC_BILL_CODE);
            costDetailVO.setProjectId(paySporadicEntity.getProjectId());
            costDetailVO.setAccountingId(paySporadicEntity.getAccountingId());
            costDetailVO.setOrgSubjectId(paySporadicEntity.getOrgSubjectId());
            costDetailVO.setOrgAccountingId(paySporadicEntity.getOrgAccountingId());
            costDetailVOList.add(costDetailVO);
        }
        if (ListUtil.isNotEmpty(costDetailVOList) && !(stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList)).isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
    }

    private void validateBeforeSave(PaySporadicEntity entity) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PaySporadicEntity::getSupplierId, (Object)entity.getSupplierId());
        lambda.eq(PaySporadicEntity::getOrgId, (Object)entity.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        lambda.notIn(PaySporadicEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u7533\u8bf7\u5355[" + ((PaySporadicEntity)((Object)entityList.get(0))).getBillCode() + "]\uff0c\u65e0\u6cd5\u53d1\u8d77\u7533\u8bf7!");
        }
    }

    private void autoSetBillCode(PaySporadicEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PAY_SPORADIC_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PaySporadicEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(PaySporadicEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PaySporadicServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PaySporadicVO> list = ((PaySporadicMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PaySporadicVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PaySporadicVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PaySporadicServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PaySporadicVO> list = ((PaySporadicMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PaySporadicVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PaySporadicVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }
}

