/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller.api;

import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.BlocKanBanVo;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.sub.api.ISubBlocKanBanApi;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/blocKanBan/"})
public class FinanceBlocKanBanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISubBlocKanBanApi subBlocKanBanApi;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private ISupplierApi supplierApi;

    @GetMapping(value={"querySupplierPayMny"})
    @ResponseBody
    public CommonResponse<List<BlocKanBanVo>> querySupplierPayMny(@RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="mnyFlag") Integer mnyFlag, @RequestParam(value="yearFlag") Integer yearFlag) {
        BigDecimal sunMny;
        if (orgId == null) {
            Long tenantid = InvocationInfoProxy.getTenantid();
            CommonResponse orgByTenantId = this.orgApi.findOrgByTenantId(tenantid);
            orgId = ((OrgVO)orgByTenantId.getData()).getId();
        }
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        CommonResponse mapCommonResponse = this.subBlocKanBanApi.queryExternalSupplierAndMny(null, yearFlag);
        if (!mapCommonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5206\u5305\u6570\u636e\u5931\u8d25");
        }
        Map map = (Map)mapCommonResponse.getData();
        ArrayList contractVOList = new ArrayList(map.values());
        List<Long> supplierIds = contractVOList.stream().map(ContractVO::getSupplierId).collect(Collectors.toList());
        List<PayContractVO> payContractVOList = this.payContractService.querySupplierPayMny(orgIds, supplierIds, yearFlag);
        Map payContractVOMap = payContractVOList.stream().collect(Collectors.toMap(PayContractVO::getReceiveUnitId, Function.identity()));
        HashSet set = new HashSet(map.keySet());
        set.addAll(payContractVOMap.keySet());
        List<Object> voList = new ArrayList();
        for (Long supplierId : set) {
            BlocKanBanVo blocKanBanVo = new BlocKanBanVo();
            blocKanBanVo.setReceiveUnitId(supplierId);
            if (map.containsKey(supplierId)) {
                blocKanBanVo.setReceiveUnitName(((ContractVO)map.get(supplierId)).getSupplierName());
                BigDecimal contractTaxMny = ((ContractVO)map.get(supplierId)).getContractTaxMny();
                contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
                blocKanBanVo.setTotalContractTaxMny(contractTaxMny);
            } else {
                blocKanBanVo.setTotalContractTaxMny(BigDecimal.ZERO);
            }
            if (payContractVOMap.containsKey(supplierId)) {
                blocKanBanVo.setReceiveUnitName(((PayContractVO)payContractVOMap.get(supplierId)).getReceiveUnitName());
                BigDecimal payMny = ((PayContractVO)payContractVOMap.get(supplierId)).getPayMny();
                payMny = payMny == null ? BigDecimal.ZERO : payMny;
                blocKanBanVo.setTotalPayMny(payMny);
            } else {
                blocKanBanVo.setTotalPayMny(BigDecimal.ZERO);
            }
            blocKanBanVo.setOwedMny(ComputeUtil.safeSub((BigDecimal)blocKanBanVo.getTotalContractTaxMny(), (BigDecimal)blocKanBanVo.getTotalPayMny()));
            if (blocKanBanVo.getOwedMny().compareTo(new BigDecimal("0E-8")) == 0) {
                blocKanBanVo.setOwedMny(BigDecimal.ZERO);
            }
            voList.add(blocKanBanVo);
        }
        if (mnyFlag == 0) {
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalPayMny).reversed()).limit(5L).collect(Collectors.toList());
            sunMny = voList.stream().map(BlocKanBanVo::getTotalPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo blocKanBanVo : voList) {
                blocKanBanVo.setSupplierRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)blocKanBanVo.getTotalPayMny(), (BigDecimal)sunMny), (BigDecimal)new BigDecimal("100")));
            }
        } else if (mnyFlag == 1) {
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalContractTaxMny).reversed()).limit(5L).collect(Collectors.toList());
            sunMny = voList.stream().map(BlocKanBanVo::getTotalContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo blocKanBanVo : voList) {
                blocKanBanVo.setSupplierRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)blocKanBanVo.getTotalContractTaxMny(), (BigDecimal)sunMny), (BigDecimal)new BigDecimal("100")));
            }
        } else {
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getOwedMny).reversed()).limit(5L).collect(Collectors.toList());
            sunMny = voList.stream().map(BlocKanBanVo::getOwedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo blocKanBanVo : voList) {
                blocKanBanVo.setSupplierRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)blocKanBanVo.getOwedMny(), (BigDecimal)sunMny), (BigDecimal)new BigDecimal("100")));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u4f9b\u5e94\u5546top5\u6210\u529f", voList);
    }

    @GetMapping(value={"querySubSupplierByProject"})
    @ResponseBody
    public CommonResponse<List<BlocKanBanVo>> querySubSupplierByProject(@RequestParam(value="projectId", required=false) Long projectId, @RequestParam(value="mnyFlag") Integer mnyFlag, @RequestParam(value="yearFlag") Integer yearFlag, @RequestParam(defaultValue="10") Integer topN) {
        if (projectId == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u4e3a\u7a7a\uff01");
        }
        List<Object> voList = new ArrayList();
        if (mnyFlag == 0) {
            List<PayContractVO> payContractList = this.payContractService.querySupplierPayMnyByProject(projectId, yearFlag, Arrays.asList(1));
            BigDecimal totalPayMny = payContractList.stream().map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (PayContractVO payContractVO : payContractList) {
                BlocKanBanVo vo = new BlocKanBanVo();
                vo.setReceiveUnitId(payContractVO.getReceiveUnitId());
                vo.setReceiveUnitName(payContractVO.getReceiveUnitName());
                vo.setTotalPayMny(payContractVO.getPayMny());
                BigDecimal supplierRate = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalPayMny(), (BigDecimal)totalPayMny), (BigDecimal)new BigDecimal("100"));
                vo.setSupplierRate(MathUtil.judgeZeroError((BigDecimal)supplierRate));
                voList.add(vo);
            }
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalPayMny).reversed()).limit(topN.intValue()).collect(Collectors.toList());
        } else if (mnyFlag == 1) {
            List<ContractVO> contractList = this.payContractService.querySubContractMny(projectId, yearFlag);
            BigDecimal totalContractTaxMny = contractList.stream().map(ContractVO::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (ContractVO contractVO : contractList) {
                BlocKanBanVo vo = new BlocKanBanVo();
                vo.setReceiveUnitId(contractVO.getSupplierId());
                vo.setReceiveUnitName(contractVO.getSupplierName());
                vo.setTotalContractTaxMny(contractVO.getContractTaxMny());
                BigDecimal supplierRate = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalContractTaxMny(), (BigDecimal)totalContractTaxMny), (BigDecimal)new BigDecimal("100"));
                vo.setSupplierRate(MathUtil.judgeZeroError((BigDecimal)supplierRate));
                voList.add(vo);
            }
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalContractTaxMny).reversed()).limit(topN.intValue()).collect(Collectors.toList());
        } else {
            List<BlocKanBanVo> banVoList = this.payContractService.querySubOwedMny(projectId, yearFlag);
            List<PayContractVO> payContractList = this.payContractService.querySupplierPayMnyByProject(projectId, yearFlag, Arrays.asList(1));
            Map map = payContractList.stream().collect(Collectors.toMap(PayContractVO::getReceiveUnitId, Function.identity()));
            for (BlocKanBanVo banVo : banVoList) {
                BigDecimal taxMny;
                BigDecimal settleTaxMny = MathUtil.judgeZeroError((BigDecimal)banVo.getSettleTaxMny());
                BigDecimal finishSettleTaxMny = MathUtil.judgeZeroError((BigDecimal)banVo.getFinishSettleTaxMny());
                BigDecimal bigDecimal = taxMny = finishSettleTaxMny.equals(BigDecimal.ZERO) ? settleTaxMny : finishSettleTaxMny;
                if (map.containsKey(banVo.getReceiveUnitId())) {
                    banVo.setOwedMny(ComputeUtil.safeSub((BigDecimal)taxMny, (BigDecimal)((PayContractVO)map.get(banVo.getReceiveUnitId())).getPayMny()));
                    continue;
                }
                banVo.setOwedMny(taxMny);
            }
            BigDecimal totalOwedMny = banVoList.stream().map(BlocKanBanVo::getOwedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo banVo : banVoList) {
                BigDecimal supplierRate = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)banVo.getOwedMny(), (BigDecimal)totalOwedMny), (BigDecimal)new BigDecimal("100"));
                banVo.setSupplierRate(MathUtil.judgeZeroError((BigDecimal)supplierRate));
            }
            voList = banVoList.stream().sorted(Comparator.comparing(BlocKanBanVo::getOwedMny).reversed()).limit(topN.intValue()).collect(Collectors.toList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u4f9b\u5e94\u5546\u6210\u529f", voList);
    }

    @GetMapping(value={"queryMESupplierByProject"})
    @ResponseBody
    public CommonResponse<List<BlocKanBanVo>> queryMESupplierByProject(@RequestParam(value="projectId", required=false) Long projectId, @RequestParam(value="mnyFlag") Integer mnyFlag, @RequestParam(value="yearFlag") Integer yearFlag, @RequestParam(defaultValue="10") Integer topN) {
        if (projectId == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u4e3a\u7a7a\uff01");
        }
        List<Object> voList = new ArrayList();
        if (mnyFlag == 0) {
            List<PayContractVO> payContractList = this.payContractService.querySupplierPayMnyByProject(projectId, yearFlag, Arrays.asList(2, 3, 4));
            BigDecimal totalPayMny = payContractList.stream().map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (PayContractVO payContractVO : payContractList) {
                BlocKanBanVo vo = new BlocKanBanVo();
                vo.setReceiveUnitId(payContractVO.getReceiveUnitId());
                vo.setReceiveUnitName(payContractVO.getReceiveUnitName());
                vo.setTotalPayMny(payContractVO.getPayMny());
                BigDecimal supplierRate = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalPayMny(), (BigDecimal)totalPayMny), (BigDecimal)new BigDecimal("100"));
                vo.setSupplierRate(MathUtil.judgeZeroError((BigDecimal)supplierRate));
                voList.add(vo);
            }
            voList = voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalPayMny).reversed()).limit(topN.intValue()).collect(Collectors.toList());
        } else if (mnyFlag == 1) {
            List<BlocKanBanVo> contractList = this.payContractService.queryMaterialContractMny(projectId, yearFlag);
            BigDecimal totalContractTaxMny = contractList.stream().map(BlocKanBanVo::getTotalContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo banVo : contractList) {
                BigDecimal supplierRate = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)banVo.getTotalContractTaxMny(), (BigDecimal)totalContractTaxMny), (BigDecimal)new BigDecimal("100"));
                banVo.setSupplierRate(MathUtil.judgeZeroError((BigDecimal)supplierRate));
            }
            voList = contractList.stream().sorted(Comparator.comparing(BlocKanBanVo::getTotalContractTaxMny).reversed()).limit(topN.intValue()).collect(Collectors.toList());
        } else {
            List<BlocKanBanVo> settleList = this.payContractService.queryMaterialSettleMny(projectId, yearFlag);
            List<PayContractVO> payContractList = this.payContractService.querySupplierPayMnyByProject(projectId, yearFlag, Arrays.asList(2, 3, 4));
            Map map = payContractList.stream().collect(Collectors.toMap(PayContractVO::getReceiveUnitId, Function.identity()));
            for (BlocKanBanVo banVo : settleList) {
                BigDecimal settleTaxMny = MathUtil.judgeZeroError((BigDecimal)banVo.getSettleTaxMny());
                if (map.containsKey(banVo.getReceiveUnitId())) {
                    banVo.setOwedMny(ComputeUtil.safeSub((BigDecimal)settleTaxMny, (BigDecimal)((PayContractVO)map.get(banVo.getReceiveUnitId())).getPayMny()));
                    continue;
                }
                banVo.setOwedMny(settleTaxMny);
            }
            BigDecimal totalOwedMny = settleList.stream().map(BlocKanBanVo::getOwedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (BlocKanBanVo banVo : settleList) {
                BigDecimal supplierRate = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)banVo.getOwedMny(), (BigDecimal)totalOwedMny), (BigDecimal)new BigDecimal("100"));
                banVo.setSupplierRate(MathUtil.judgeZeroError((BigDecimal)supplierRate));
            }
            voList = settleList.stream().sorted(Comparator.comparing(BlocKanBanVo::getOwedMny).reversed()).limit(topN.intValue()).collect(Collectors.toList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6750\u6599\u8bbe\u5907\u4f9b\u5e94\u5546\u6210\u529f\uff01", voList);
    }
}

