/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.mbs.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.mbs.bean.bank.BankEntity;
import com.ejianc.business.finance.mbs.bean.bank.request.BankMbsReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankPubReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqHeadVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankMbsRespVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankRespDetail;
import com.ejianc.business.finance.mbs.bean.pay.request.PayMbsReqVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayPubReqVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqDetail;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqHeadVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqList;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqVo;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoMbsReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoPubReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.response.PayInfoMbsRespVo;
import com.ejianc.business.finance.mbs.mapper.BankMapper;
import com.ejianc.business.finance.mbs.service.IBankService;
import com.ejianc.business.finance.utils.XmlUtils;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mbsService")
public class MbsService {
    @Autowired
    private BankMapper bankMapper;
    @Autowired
    private IBankService bankService;
    private String URL = "http://58.56.155.202:8010/webservice/outService.ws";
    private String BankTRANSCODE = "PBQB01";
    private String PayTRANSCODE = "PMSQ01";
    private String PayInfoTRANSCODE = "GETPAYINFO";
    private String MD5Key = "QDSZ123";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void getMbsBankInfo() throws Exception {
        ArrayList<BankEntity> bankList = new ArrayList<BankEntity>();
        BankReqHeadVo bankHeadVo = new BankReqHeadVo(1, 100);
        Date today = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String LASTMODIFIEDONSTART = sdf.format(today);
        String LASTMODIFIEDONEND = sdf.format(today);
        SimpleDateFormat sdfCodeF = new SimpleDateFormat("yyyyMMdd");
        String getCode = sdfCodeF.format(today);
        BankReqSearchonditionsVo bankSearchonditionsVo = new BankReqSearchonditionsVo(LASTMODIFIEDONSTART, LASTMODIFIEDONEND);
        BankReqVo bankReqVo = new BankReqVo(bankHeadVo, bankSearchonditionsVo);
        BankMbsReqVo mbsVo = new BankMbsReqVo();
        mbsVo.setReq(bankReqVo);
        String MD5 = MbsService.md5String(XmlUtils.getXmlFromObject(bankReqVo), this.MD5Key);
        BankPubReqVo pubVo = new BankPubReqVo(getCode, this.BankTRANSCODE, MD5);
        mbsVo.setPub(pubVo);
        String xmlStr = XmlUtils.getXmlFromObject(mbsVo);
        xmlStr = this.splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
        String sendResult = XmlUtils.sendXml(xmlStr, this.URL);
        sendResult = this.splicingXmlResponse(sendResult);
        System.out.println(sendResult);
        BankMbsRespVo mbsResponseVo = new BankMbsRespVo();
        mbsResponseVo = (BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
        int pageNum = mbsResponseVo.getResp().getPAGECOUNT();
        if (pageNum > 1) {
            for (int i = 1; i > pageNum; ++i) {
                mbsVo.getReq().getHead().setPAGEINDEX(i);
                sendResult = XmlUtils.sendXml(xmlStr, this.URL);
                mbsResponseVo = (BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
                List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
                Iterator iterator = detail.iterator();
                while (iterator.hasNext()) {
                    BankRespDetail bankRespDetail = (BankRespDetail)iterator.next();
                    BankEntity entity = new BankEntity();
                    entity.setId(IdWorker.getId());
                    entity.setShortName(bankRespDetail.getName());
                    entity.setName(bankRespDetail.getName());
                    entity.setCode(bankRespDetail.getBankcode());
                    entity.setBankCategoryId(null);
                    entity.setBankCategoryName(null);
                    bankList.add(entity);
                }
            }
        } else {
            List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
            for (BankRespDetail bankRespDetail : detail) {
                BankEntity entity = new BankEntity();
                entity.setId(IdWorker.getId());
                entity.setShortName(bankRespDetail.getName());
                entity.setName(bankRespDetail.getName());
                entity.setCode(bankRespDetail.getBankcode());
                entity.setBankCategoryId(null);
                entity.setBankCategoryName(null);
                bankList.add(entity);
            }
        }
        for (BankEntity bankEntity : bankList) {
            QueryWrapper bankWrapper = new QueryWrapper();
            ((QueryWrapper)bankWrapper.eq((Object)"code", (Object)bankEntity.getCode())).eq((Object)"dr", (Object)0);
            List entityList = this.bankService.list((Wrapper)bankWrapper);
            if (entityList.size() > 0) {
                bankEntity.setId(((BankEntity)((Object)entityList.get(0))).getId());
                bankEntity.setCreateTime(((BankEntity)((Object)entityList.get(0))).getCreateTime());
                bankEntity.setCreateUserCode(((BankEntity)((Object)entityList.get(0))).getCreateUserCode());
            }
            this.bankService.saveOrUpdate((Object)bankEntity);
        }
    }

    public void sendPay(PayReqDetail payDetail) throws Exception {
        this.logger.info("\u5f00\u59cb\u63a8\u9001\u8d44\u91d1\u7cfb\u7edf");
        BigDecimal ALLAMOUNT = BigDecimal.ZERO;
        int ALLCOUNT = 0;
        PayMbsReqVo mbsReqVo = new PayMbsReqVo();
        PayReqVo req = new PayReqVo();
        PayReqHeadVo head = new PayReqHeadVo();
        PayReqList list = new PayReqList();
        head.setALLAMOUNT(ALLAMOUNT);
        head.setALLCOUNT(ALLCOUNT);
        ArrayList<PayReqDetail> payReqDetail = new ArrayList<PayReqDetail>();
        payReqDetail.add(payDetail);
        list.setDetail(payReqDetail);
        req.setHead(head);
        req.setList(list);
        mbsReqVo.setReq(req);
        String reqString = XmlUtils.getXmlFromObject(req);
        this.logger.info("\u6253\u5370reqString-----" + reqString);
        String MD5 = MbsService.md5String(reqString, this.MD5Key);
        this.logger.info("\u6253\u5370MD5\u5bc6\u6587-----" + MD5);
        PayPubReqVo pubReqVo = new PayPubReqVo(payDetail.getSRCSERIALNO(), this.PayTRANSCODE, MD5);
        mbsReqVo.setPub(pubReqVo);
        String xmlStr = XmlUtils.getXmlFromObject(mbsReqVo);
        this.logger.info("\u63a8\u9001MBS\u62a5\u6587--- xmlStr1:" + xmlStr);
        xmlStr = this.splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
        this.logger.info("\u63a8\u9001MBS\u62a5\u6587--- xmlStr:" + xmlStr);
        this.logger.info("\u63a8\u9001MBS\u5730\u5740--- URL:" + this.URL);
        String sendResult = XmlUtils.sendXml(xmlStr, this.URL);
        sendResult = this.splicingXmlResponse(sendResult);
        System.out.println(sendResult);
        PayMbsRespVo payMbsRespVo = new PayMbsRespVo();
        payMbsRespVo = (PayMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
        this.logger.info("MBS\u8fd4\u56de\u62a5\u6587--- xmlStr:" + sendResult);
    }

    public void getPayInfo() throws Exception {
        String SRCSERIALNO = null;
        PayInfoMbsReqVo mbsReqVo = new PayInfoMbsReqVo();
        mbsReqVo.getReq().getSearchconditions().setSRCSERIALNO(SRCSERIALNO);
        String MD5 = MbsService.md5String(XmlUtils.getXmlFromObject(mbsReqVo.getReq()), this.MD5Key);
        PayInfoPubReqVo pubReqVo = new PayInfoPubReqVo(SRCSERIALNO, this.PayTRANSCODE, MD5);
        mbsReqVo.setPub(pubReqVo);
        String xmlStr = XmlUtils.getXmlFromObject(mbsReqVo);
        xmlStr = this.splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
        String sendResult = XmlUtils.sendXml(xmlStr, this.URL);
        sendResult = this.splicingXmlResponse(sendResult);
        System.out.println(sendResult);
        PayInfoMbsRespVo payMbsRespVo = new PayInfoMbsRespVo();
        payMbsRespVo = (PayInfoMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
    }

    private String splicingXmlRequest(String xml) {
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xml;
        xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:out=\"http://outsystem.ats.com.cn\"><soapenv:Header/><soapenv:Body><out:outSystemWS><out:in0><![CDATA[" + xml + "]]></out:in0></out:outSystemWS></soapenv:Body></soapenv:Envelope>";
        return xml;
    }

    private String splicingXmlResponse(String xml) {
        xml = StringEscapeUtils.unescapeXml((String)xml);
        int a = xml.indexOf("<MBS>");
        int b = xml.indexOf("</MBS>");
        xml = StringUtils.substring((String)xml, (int)a, (int)b) + "</MBS>";
        return xml;
    }

    private static String md5String(String md5String, String md5Key) {
        String md5Value = MbsService.MD5Encoder(md5String + md5Key);
        return md5Value;
    }

    public static final String MD5Encoder(String s) {
        return MbsService.MD5Encoder(s, "utf-8");
    }

    public static final String MD5Encoder(String s, String charset) {
        try {
            byte[] btInput = s.getBytes(charset);
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < md.length; ++i) {
                int val = md[i] & 0xFF;
                if (val < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(val));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

