/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.mbs.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.mbs.bean.bank.BankEntity;
import com.ejianc.business.finance.mbs.bean.bank.request.BankMbsReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankPubReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqHeadVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankMbsRespVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankRespDetail;
import com.ejianc.business.finance.mbs.bean.pay.request.PayMbsReqVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayPubReqVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqDetail;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.business.finance.mbs.service.IBankService;
import com.ejianc.business.finance.utils.XmlUtils;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class MbsTask {
    @Autowired
    IBankService bankService;
    private String URL = "http://58.56.155.202:8010/webservice/outService.ws";
    private String MD5 = "9601a2e927ec7225a2e65ed6ed942198";
    private String BankTRANSCODE = "PBQB01";
    private String PayTRANSCODE = "PMSQ01";
    private String PayInfoTRANSCODE = "GETPAYINFO";
    private String MD5Key = "QDSZ123";

    @Scheduled(cron="0 0 0 * * ?")
    public void saveMbsBankInfo() throws Exception {
        ArrayList<BankEntity> bankList = new ArrayList<BankEntity>();
        BankReqHeadVo bankHeadVo = new BankReqHeadVo(1, 100);
        Date today = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String LASTMODIFIEDONSTART = sdf.format(today);
        String LASTMODIFIEDONEND = sdf.format(today);
        SimpleDateFormat sdfCodeF = new SimpleDateFormat("yyyyMMdd");
        String getCode = sdfCodeF.format(today);
        BankReqSearchonditionsVo bankSearchonditionsVo = new BankReqSearchonditionsVo("2023-01-01", LASTMODIFIEDONEND);
        BankReqVo bankReqVo = new BankReqVo(bankHeadVo, bankSearchonditionsVo);
        BankMbsReqVo mbsVo = new BankMbsReqVo();
        mbsVo.setReq(bankReqVo);
        String MD5 = MbsTask.md5String(XmlUtils.getXmlFromObject(bankReqVo), this.MD5Key);
        BankPubReqVo pubVo = new BankPubReqVo(getCode, this.BankTRANSCODE, MD5);
        mbsVo.setPub(pubVo);
        String xmlStr = XmlUtils.getXmlFromObject(mbsVo);
        xmlStr = this.splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
        String sendResult = XmlUtils.sendXml(xmlStr, this.URL);
        sendResult = this.splicingXmlResponse(sendResult);
        System.out.println(sendResult);
        BankMbsRespVo mbsResponseVo = new BankMbsRespVo();
        mbsResponseVo = (BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
        int pageNum = mbsResponseVo.getResp().getPAGECOUNT();
        if (pageNum > 1) {
            for (int i = 1; i > pageNum; ++i) {
                mbsVo.getReq().getHead().setPAGEINDEX(i);
                sendResult = XmlUtils.sendXml(xmlStr, this.URL);
                mbsResponseVo = (BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
                List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
                Iterator iterator = detail.iterator();
                while (iterator.hasNext()) {
                    BankRespDetail bankRespDetail = (BankRespDetail)iterator.next();
                    BankEntity entity = new BankEntity();
                    entity.setId(IdWorker.getId());
                    entity.setShortName(bankRespDetail.getName());
                    entity.setName(bankRespDetail.getName());
                    entity.setCode(bankRespDetail.getBankcode());
                    entity.setBankCategoryId(null);
                    entity.setBankCategoryName(null);
                    bankList.add(entity);
                }
            }
        } else if (pageNum == 1) {
            List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
            for (BankRespDetail bankRespDetail : detail) {
                BankEntity entity = new BankEntity();
                entity.setId(IdWorker.getId());
                entity.setShortName(bankRespDetail.getName());
                entity.setName(bankRespDetail.getName());
                entity.setCode(bankRespDetail.getBankcode());
                entity.setBankCategoryId(null);
                entity.setBankCategoryName(null);
                bankList.add(entity);
            }
        }
        if (bankList != null) {
            for (BankEntity bankEntity : bankList) {
                QueryWrapper bankWrapper = new QueryWrapper();
                ((QueryWrapper)bankWrapper.eq((Object)"code", (Object)bankEntity.getCode())).eq((Object)"dr", (Object)0);
                List entityList = this.bankService.list((Wrapper)bankWrapper);
                if (entityList.size() > 0) {
                    bankEntity.setId(((BankEntity)((Object)entityList.get(0))).getId());
                    bankEntity.setCreateTime(((BankEntity)((Object)entityList.get(0))).getCreateTime());
                    bankEntity.setCreateUserCode(((BankEntity)((Object)entityList.get(0))).getCreateUserCode());
                }
                this.bankService.saveOrUpdate((Object)bankEntity);
            }
        }
    }

    public void sendPay() throws Exception {
        PayReqDetail payDetail = new PayReqDetail();
        BigDecimal ALLAMOUNT = BigDecimal.ZERO;
        int ALLCOUNT = 0;
        PayMbsReqVo mbsReqVo = new PayMbsReqVo();
        PayPubReqVo pubReqVo = new PayPubReqVo("0000001", this.PayTRANSCODE, this.MD5);
        mbsReqVo.setPub(pubReqVo);
        mbsReqVo.getReq().getHead().setALLAMOUNT(ALLAMOUNT);
        mbsReqVo.getReq().getHead().setALLCOUNT(ALLCOUNT);
        mbsReqVo.getReq().getList().getDetail().add(payDetail);
        String xmlStr = XmlUtils.getXmlFromObject(mbsReqVo);
        xmlStr = this.splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
        String sendResult = XmlUtils.sendXml(xmlStr, this.URL);
        sendResult = this.splicingXmlResponse(sendResult);
        System.out.println(sendResult);
        PayMbsRespVo payMbsRespVo = new PayMbsRespVo();
        payMbsRespVo = (PayMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
    }

    private String splicingXmlRequest(String xml) {
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xml;
        xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:out=\"http://outsystem.ats.com.cn\"><soapenv:Header/><soapenv:Body><out:outSystemWS><out:in0><![CDATA[" + xml + "]]></out:in0></out:outSystemWS></soapenv:Body></soapenv:Envelope>";
        return xml;
    }

    private String splicingXmlResponse(String xml) {
        xml = StringEscapeUtils.unescapeXml((String)xml);
        int a = xml.indexOf("<MBS>");
        int b = xml.indexOf("</MBS>");
        xml = StringUtils.substring((String)xml, (int)a, (int)b) + "</MBS>";
        return xml;
    }

    private static String md5String(String md5String, String md5Key) {
        String md5Value = MbsTask.MD5Encoder(md5String + md5Key);
        return md5Value;
    }

    public static final String MD5Encoder(String s) {
        return MbsTask.MD5Encoder(s, "utf-8");
    }

    public static final String MD5Encoder(String s, String charset) {
        try {
            byte[] btInput = s.getBytes(charset);
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < md.length; ++i) {
                int val = md[i] & 0xFF;
                if (val < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(val));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

