/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bondDown")
public class BondDownBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBondDownService bondDownService;
    @Autowired
    private IBondDownDealService bondDownDealService;
    @Autowired
    private IBondDownBackService bondDownBackService;
    @Autowired
    private NCUtil ncUtil;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper wrapper;
        JSONObject json;
        LambdaUpdateWrapper split;
        this.logger.info("\u8fdb\u5165\u5f03\u5ba1\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        BondDownEntity upEntity = (BondDownEntity)((Object)this.bondDownService.selectById(billId));
        upEntity.setBondStatus("0");
        upEntity.setBackMny(BigDecimal.ZERO);
        upEntity.setPayMny(BigDecimal.ZERO);
        upEntity.setEmployeeId(null);
        upEntity.setEmployeeName(null);
        boolean res = this.bondDownService.saveOrUpdate((Object)upEntity, false);
        QueryWrapper dealWrapper = new QueryWrapper();
        dealWrapper.eq((Object)"bond_id", (Object)billId);
        this.bondDownDealService.remove((Wrapper)dealWrapper, false);
        QueryWrapper backWrapper = new QueryWrapper();
        backWrapper.eq((Object)"bond_id", (Object)billId);
        this.bondDownBackService.remove((Wrapper)backWrapper, false);
        if (StringUtils.isNotEmpty((CharSequence)upEntity.getSourceId())) {
            for (String sourceId : split = upEntity.getSourceId().split(",")) {
                json = new JSONObject();
                json.put("busitype", (Object)"deleterecbill");
                json.put("pk_bill", (Object)sourceId);
                this.ncUtil.postByJson(json.toJSONString());
            }
            wrapper = new LambdaUpdateWrapper();
            wrapper.set(BondDownEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.bondDownService.update((Wrapper)wrapper);
        }
        if (StringUtils.isNotEmpty((CharSequence)upEntity.getSourceBackId())) {
            for (String sourceId : split = upEntity.getSourceBackId().split(",")) {
                json = new JSONObject();
                json.put("busitype", (Object)"deletepaybill");
                json.put("pk_bill", (Object)sourceId);
                this.ncUtil.postByJson(json.toJSONString());
            }
            wrapper = new LambdaUpdateWrapper();
            wrapper.set(BondDownEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.bondDownService.update((Wrapper)wrapper);
        }
        if (res) {
            return CommonResponse.success((String)"\u56de\u9000\u6210\u529f!");
        }
        return CommonResponse.error((String)"\u56de\u9000\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5!");
    }
}

