/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpDealMapper;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.PayBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.PayBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BondUpDealServiceImpl
extends BaseServiceImpl<BondUpDealMapper, BondUpDealEntity>
implements IBondUpDealService {
    private static final String BONGUP_DEAL = "BONGUP_DEAL";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private NCUtil ncUtil;

    @Override
    public BondUpDealVO insertOrUpdate(BondUpDealVO bondUpDealVO) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondUpDealVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGUP_DEAL, tenantId);
            if (billCode.isSuccess()) {
                bondUpDealVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondUpDealEntity entity = (BondUpDealEntity)((Object)BeanMapper.map((Object)bondUpDealVO, BondUpDealEntity.class));
        if (null != bondUpDealVO.getId() && bondUpDealVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondUpDealEntity::getBillCode, (Object)bondUpDealVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondUpDealVO.getId());
            entities = super.list((Wrapper)lambda);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(BondUpDealEntity::getDealStatus, (Object)"2");
            super.update((Wrapper)updateWrapper);
            entity.setId(null);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondUpDealEntity::getBillCode, (Object)bondUpDealVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondUpEntity::getBondStatus, (Object)"1");
        updateWrapper.set(BondUpEntity::getBeginDate, (Object)entity.getBeginDate());
        updateWrapper.set(BondUpEntity::getEndDate, (Object)entity.getEndDate());
        updateWrapper.set(BondUpEntity::getEmployeeId, (Object)entity.getEmployeeId());
        updateWrapper.set(BondUpEntity::getEmployeeName, (Object)entity.getEmployeeName());
        updateWrapper.set(BondUpEntity::getPayMny, (Object)entity.getBondMny());
        updateWrapper.set(BondUpEntity::getBondType, (Object)entity.getBondType());
        updateWrapper.set(BondUpEntity::getDealTime, (Object)entity.getDealTime());
        this.bondUpService.update((Wrapper)updateWrapper);
        BondUpEntity upEntity = (BondUpEntity)((Object)this.bondUpService.selectById(bondUpDealVO.getBondId()));
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(upEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())) {
            this.pushToNC(upEntity, entity);
        }
        return (BondUpDealVO)BeanMapper.map((Object)((Object)entity), BondUpDealVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = (BondUpEntity)((Object)this.bondUpService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondUpDealEntity::getBondId, (Object)id);
        lambda.orderBy(true, true, (Object[])new SFunction[]{BondUpDealEntity::getDealStatus});
        List list = super.list((Wrapper)lambda);
        vo = (BondUpDealRentVO)BeanMapper.map((Object)((Object)upEntity), BondUpDealRentVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setDealRecord(BeanMapper.mapList((Iterable)list, BondUpDealVO.class));
        }
        return vo;
    }

    private void pushToNC(BondUpEntity entity, BondUpDealEntity upDealEntity) {
        List<Long> orgIds;
        PayBillVO vo = this.transferToNCVO(entity, upDealEntity);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        StringBuffer sb = new StringBuffer();
        if (entity.getApplyOrgId().equals(entity.getActualOrgId())) {
            orgIds = this.ncUtil.validateInvoiceMainOrg(entity.getApplyOrgId(), project.getMainOrgId());
            for (Long orgId : orgIds) {
                OrgVO orgVO = this.ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append(sourceId).append(",");
            }
        } else {
            orgIds = this.ncUtil.validateInvoiceMainOrg(entity.getApplyOrgId(), project.getMainOrgId());
            for (Long orgId : orgIds) {
                OrgVO orgVO = this.ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append(sourceId).append(",");
            }
            BankAccountVO bankAccountVO2 = this.ncUtil.queryDefaultBankAccountById(entity.getActualOrgId(), "insideOrgId");
            PayBillDetailVO payBillDetailVO2 = (PayBillDetailVO)vo.getDetail().get(0);
            payBillDetailVO2.setBankaccount(bankAccountVO2.getBankCode());
            List<Long> orgIds2 = this.ncUtil.validateInvoiceMainOrg(entity.getActualOrgId(), project.getMainOrgId());
            for (Long orgId : orgIds2) {
                OrgVO orgVO = this.ncUtil.queryOrgById(orgId);
                vo.setPk_org(orgVO.getCode());
                String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append(sourceId).append(",");
            }
        }
        String sourceIds = sb.substring(0, sb.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(BondUpEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.bondUpService.update((Wrapper)wrapper);
        LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
        lambda.set(BondUpDealEntity::getSourceId, (Object)sourceIds);
        lambda.eq(BaseEntity::getId, (Object)upDealEntity.getId());
        this.update((Wrapper)lambda);
    }

    private PayBillVO transferToNCVO(BondUpEntity entity, BondUpDealEntity bondUpDealEntity) {
        this.logger.info("----\u4ed8\u6b3e\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = this.ncUtil.queryOrgById(project.getOrgId());
        CustomerVO customerVO = this.ncUtil.queryCustomerById(entity.getCustomerId());
        PayBillVO vo = new PayBillVO();
        vo.setBusitype("paybill");
        vo.setTradetype("F3-Cxx-006");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setPk_dept(String.valueOf(project.getDeptId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setDef19(bondUpDealEntity.getBillCode());
        vo.setDef1(Boolean.valueOf(false));
        vo.setPk_supplier("1001A11000000009VTP1");
        vo.setSupname("\u901a\u7528\u6295\u6807\u4fdd\u8bc1\u91d1\u5ba2\u5546");
        vo.setTaxpayerid("1001A11000000009VTP1");
        vo.setDef17(String.valueOf(entity.getCustomerId()));
        vo.setDef6(Boolean.valueOf(customerVO.getInsideOrgId() != null));
        vo.setDef20(this.ncUtil.getWebSite("ejc-finance-frontend/#/bondManageList/bondUpDetailManage?id=" + entity.getId()));
        vo.setDef21("BT200616000000003");
        ArrayList<PayBillDetailVO> detailVOS = new ArrayList<PayBillDetailVO>();
        PayBillDetailVO detailVO = new PayBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setLocal_mny(bondUpDealEntity.getBondMny());
        BankAccountVO bankAccountVO = this.ncUtil.queryDefaultBankAccountById(entity.getApplyOrgId(), "insideOrgId");
        detailVO.setBankaccount(bankAccountVO.getBankCode());
        detailVO.setCashitem(this.ncUtil.getDefDocById(entity.getCashItemId()).getCode());
        detailVO.setBalatype(this.ncUtil.getDefDocById(entity.getPaymentWay()).getCode());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }
}

