/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="LoadReimburseService")
public class LoadReimburseServiceImpl
extends BaseServiceImpl<LoadReimburseMapper, LoadReimburseEntity>
implements ILoadReimburseService {
    private static final String BONDUP_BILL_CODE = "LOAD_REIMBURSE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public LoadReimburseVO insertOrUpdate(LoadReimburseVO loadReimburseVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (null != loadReimburseVO && StringUtils.isEmpty((CharSequence)loadReimburseVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                loadReimburseVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LoadReimburseEntity entity = (LoadReimburseEntity)((Object)BeanMapper.map((Object)loadReimburseVO, LoadReimburseEntity.class));
        BigDecimal surplusMny = this.loadApplyService.querySurplusMny(entity.getId(), null, entity.getOrgId(), 0, "");
        BigDecimal reimburseMny = entity.getReimburseMny();
        if (reimburseMny.compareTo(surplusMny) > 0) {
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            throw new BusinessException("\u672c\u6b21\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u53ef\u62a5\u9500\u91d1\u989d\u3010" + df1.format(surplusMny) + "\u3011\u5143");
        }
        List invoiceVOList = loadReimburseVO.getInvoiceVOList();
        if (CollectionUtils.isNotEmpty((Collection)invoiceVOList)) {
            ArrayList listi = new ArrayList();
            invoiceVOList.forEach(vo -> {
                InvoiceReceiveFlagVO invo = new InvoiceReceiveFlagVO();
                if ("add".equals(vo.getRowState())) {
                    invo.setId(vo.getInvoiceId());
                    invo.setFlag(Integer.valueOf(1));
                    listi.add(invo);
                } else if ("del".equals(vo.getRowState())) {
                    invo.setId(vo.getInvoiceId());
                    invo.setFlag(Integer.valueOf(0));
                    listi.add(invo);
                }
            });
            if (listi.size() > 0) {
                this.invoiceApi.updateFlag(listi);
            }
        }
        entity.setSurplusMny(surplusMny);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        super.saveOrUpdate((Object)entity, false);
        return (LoadReimburseVO)BeanMapper.map((Object)((Object)entity), LoadReimburseVO.class);
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        queryWrapper.select(new String[]{"ifnull(sum(reimburse_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public CommonResponse<LoadReimburseVO> pushCost(LoadReimburseVO loadReimburseVO) {
        LoadReimburseEntity loadReimburseEntity = (LoadReimburseEntity)((Object)((LoadReimburseMapper)this.baseMapper).selectById(loadReimburseVO.getId()));
        loadReimburseEntity.setSubjectId(loadReimburseVO.getSubjectId());
        loadReimburseEntity.setSubjectName(loadReimburseVO.getSubjectName());
        super.saveOrUpdate((Object)loadReimburseEntity, false);
        this.costPush(loadReimburseEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)loadReimburseEntity), LoadReimburseVO.class));
    }

    @Override
    public void costPush(LoadReimburseEntity loadReimburseEntity) {
        if (!"1".equals(loadReimburseEntity.getDependOnProject())) {
            return;
        }
        Long subjectId = loadReimburseEntity.getSubjectId();
        boolean newRelationFlag = true;
        if (null == subjectId) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{loadReimburseEntity.getId()});
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = loadReimburseEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(loadReimburseEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(loadReimburseEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && newRelationFlag) {
            this.saveCost(loadReimburseEntity);
        }
    }

    private void saveCost(LoadReimburseEntity loadReimburseEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(loadReimburseEntity.getSubjectId());
        costDetailVO.setSourceId(loadReimburseEntity.getId());
        costDetailVO.setSourceDetailId(loadReimburseEntity.getId());
        costDetailVO.setHappenTaxMny(loadReimburseEntity.getReimburseMny());
        costDetailVO.setHappenMny(loadReimburseEntity.getReimburseMny());
        costDetailVO.setHappenDate(loadReimburseEntity.getApplyTime());
        costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(BONDUP_BILL_CODE);
        costDetailVO.setSourceTabType(BONDUP_BILL_CODE);
        costDetailVO.setProjectId(loadReimburseEntity.getProjectId());
        costDetailVOList.add(costDetailVO);
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            ((Object)costDetailVOList).toString();
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }
}

