/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.bean.OtherDetailEntity;
import com.ejianc.business.finance.bean.OtherEntity;
import com.ejianc.business.finance.mapper.OtherMapper;
import com.ejianc.business.finance.service.IOtherService;
import com.ejianc.business.finance.vo.OtherVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherService")
public class OtherServiceImpl
extends BaseServiceImpl<OtherMapper, OtherEntity>
implements IOtherService {
    private static final String FINANCE_OTHER = "FINANCE_OTHER";
    private static final String FINANCE_OTHER_DETAIL = "FINANCE_OTHER_DETAIL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<OtherVO> pushCost(OtherVO otherVO) {
        OtherEntity otherEntity = (OtherEntity)((Object)((OtherMapper)this.baseMapper).selectById(otherVO.getId()));
        if (ListUtil.isNotEmpty((List)otherVO.getOtherDetailList())) {
            List otherDetail = BeanMapper.mapList((Iterable)otherVO.getOtherDetailList(), OtherDetailEntity.class);
            otherEntity.setOtherDetailList(otherDetail);
        }
        super.saveOrUpdate((Object)otherEntity, false);
        this.costPush(otherEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)otherEntity), OtherVO.class));
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(OtherEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public void costPush(OtherEntity otherEntity) {
        this.logger.info("\u5f00\u59cbPush");
        List<OtherDetailEntity> otherdetail = otherEntity.getOtherDetailList();
        boolean newRelationFlag = true;
        if (ListUtil.isNotEmpty(otherdetail)) {
            for (OtherDetailEntity otherDetailEntity : otherdetail) {
                if (null != otherDetailEntity.getSubjectId()) continue;
                newRelationFlag = false;
                break;
            }
        }
        if (ListUtil.isEmpty(otherdetail)) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{otherEntity.getId()});
        updateWrapper.set(OtherEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = otherEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(otherEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(otherEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && newRelationFlag) {
            this.saveCost(otherEntity);
        }
    }

    private void saveCost(OtherEntity otherEntity) {
        CommonResponse stringCommonResponse;
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<OtherDetailEntity> pushOtherDetail = otherEntity.getOtherDetailList();
        if (ListUtil.isNotEmpty(pushOtherDetail)) {
            for (OtherDetailEntity otherDetailEntity : pushOtherDetail) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherDetailEntity.getSubjectId());
                costDetailVO.setSourceId(otherDetailEntity.getOtherId());
                costDetailVO.setSourceDetailId(otherDetailEntity.getId());
                costDetailVO.setHappenTaxMny(otherDetailEntity.getTaxMny());
                costDetailVO.setHappenMny(otherDetailEntity.getMny());
                costDetailVO.setHappenDate(otherEntity.getHappenDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(FINANCE_OTHER);
                costDetailVO.setSourceTabType(FINANCE_OTHER_DETAIL);
                costDetailVO.setProjectId(otherEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList) && !(stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList)).isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
    }
}

