/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.mapper.PayInfoMapper;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayForegiftVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payInfoService")
public class PayInfoServiceImpl
extends BaseServiceImpl<PayInfoMapper, PayInfoEntity>
implements IPayInfoService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PAY_INFO_CODE";
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    @Autowired
    private IPayForegiftService foregiftService;

    @Override
    public PayInfoVO insertOrUpdate(PayInfoVO saveOrUpdateVO) {
        PayInfoEntity entity = (PayInfoEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayInfoEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getBillCode() == null || "".equals(entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        PayInfoVO vo = (PayInfoVO)BeanMapper.map((Object)((Object)entity), PayInfoVO.class);
        return vo;
    }

    @Override
    public String batchConfirm(List<PayInfoVO> vos) {
        for (PayInfoVO vo : vos) {
            PayContractVO updateVO;
            if ("HT".equals(vo.getPayInfoType())) {
                updateVO = this.payContractService.queryDetail(vo.getId());
                updateVO.setEmployeeId(vo.getEmployeeId());
                updateVO.setEmployeeName(vo.getEmployeeName());
                updateVO.setConfirmTime(vo.getConfirmTime());
                updateVO.setPayMny(vo.getPayMny());
                updateVO.setPayStatus(vo.getPayStatus());
                this.payContractService.insertOrUpdate(updateVO);
            }
            if ("LX".equals(vo.getPayInfoType())) {
                updateVO = this.sporadicService.queryDetail(vo.getId());
                updateVO.setEmployeeId(vo.getEmployeeId());
                updateVO.setEmployeeName(vo.getEmployeeName());
                updateVO.setConfirmTime(vo.getConfirmTime());
                updateVO.setPayMny(vo.getPayMny());
                updateVO.setPayStatus(vo.getPayStatus());
                this.sporadicService.insertOrUpdate((PaySporadicVO)updateVO);
            }
            if ("QT".equals(vo.getPayInfoType())) {
                updateVO = this.reimburseService.queryDetail(vo.getId());
                updateVO.setEmployeeId(vo.getEmployeeId());
                updateVO.setEmployeeName(vo.getEmployeeName());
                updateVO.setConfirmTime(vo.getConfirmTime());
                updateVO.setPayMny(vo.getPayMny());
                updateVO.setPayStatus(vo.getPayStatus());
                this.reimburseService.insertOrUpdate((PayReimburseVO)updateVO);
            }
            if (!"YJ".equals(vo.getPayInfoType())) continue;
            updateVO = this.foregiftService.queryDetail(vo.getId());
            updateVO.setEmployeeId(vo.getEmployeeId());
            updateVO.setEmployeeName(vo.getEmployeeName());
            updateVO.setConfirmTime(vo.getConfirmTime());
            updateVO.setPayMny(vo.getPayMny());
            updateVO.setPayStatus(vo.getPayStatus());
            this.foregiftService.insertOrUpdate((PayForegiftVO)updateVO);
        }
        return "\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01";
    }
}

