/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.bean.ReceiveReceiptEntity;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.RecBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.RecBillVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="receive")
public class ReceiveBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIncomeContractApi incomApi;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private NCUtil ncUtil;
    @Autowired
    private ICustomerApi customerApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())) {
            this.pushToNcAr(entity);
        }
        if (entity.getContractId() != null) {
            this.incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), Boolean.valueOf(true));
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        if (!this.validateCreateTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u5b58\u5728\u540e\u7eed\u5355\u636e,\u4e0d\u80fd\u5f03\u5ba1!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u652f\u51fa\u5355\u636e\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u64a4\u56de\u64cd\u4f5c!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        if (StringUtils.isNotEmpty((CharSequence)entity.getSourceId())) {
            String[] split;
            for (String sourceId : split = entity.getSourceId().split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deleterecbill");
                json.put("pk_bill", (Object)sourceId);
                this.ncUtil.postByJson(json.toJSONString());
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ReceiveEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.receiveService.update((Wrapper)wrapper);
        }
        if (entity.getContractId() != null) {
            this.incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), Boolean.valueOf(false));
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private boolean validateEffective(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.receiveService.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateCreateTime(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        Date createTime = entity.getCreateTime();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.gt((Object)"create_time", (Object)createTime);
        List list = this.receiveService.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private void pushToNcAr(ReceiveEntity receiveEntity) {
        RecBillVO vo = this.transferToNCVO(receiveEntity);
        StringBuffer sb = new StringBuffer();
        if (receiveEntity.getReceiveOrgId().equals(receiveEntity.getActualReceiveOrgId())) {
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            sb.append(sourceId);
        } else {
            String sourceId1 = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            vo.setPk_org(this.ncUtil.queryParentOrgById(receiveEntity.getActualReceiveOrgId()).getCode());
            String sourceId2 = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            sb.append(sourceId1).append(",").append(sourceId2);
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(ReceiveEntity::getSourceId, (Object)sb.toString());
        wrapper.eq(BaseEntity::getId, (Object)receiveEntity.getId());
        this.receiveService.update((Wrapper)wrapper);
    }

    private RecBillVO transferToNCVO(ReceiveEntity receiveEntity) {
        this.logger.info("----\u6536\u5165\u7ba1\u7406\u6536\u6b3e\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        RecBillVO recNcVo = new RecBillVO();
        recNcVo.setBusitype("recbill");
        recNcVo.setDef1(Boolean.valueOf(false));
        Long recType1 = 1275321308270993409L;
        Long recType2 = 1275321354706132993L;
        if (recType1.equals(receiveEntity.getReceiveType())) {
            recNcVo.setTradetype("F2-Cxx-001");
        }
        if (recType2.equals(receiveEntity.getReceiveType())) {
            recNcVo.setTradetype("F2-Cxx-004");
        }
        recNcVo.setPk_org(this.ncUtil.queryParentOrgById(receiveEntity.getReceiveOrgId()).getCode());
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(receiveEntity.getProjectId())).get(0);
        recNcVo.setPk_project(String.valueOf(receiveEntity.getProjectId()));
        recNcVo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        recNcVo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        if (StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        recNcVo.setDef5(project.getAreaCode());
        recNcVo.setDef12(String.valueOf(receiveEntity.getId()));
        recNcVo.setPk_customer(String.valueOf(receiveEntity.getReceiveUnitId()));
        CustomerVO customerVO = this.ncUtil.queryCustomerById(receiveEntity.getReceiveUnitId());
        recNcVo.setDef6(Boolean.valueOf(customerVO.getInsideOrgId() != null));
        recNcVo.setPk_dept(String.valueOf(project.getDeptId()));
        DefdocDetailVO defDocById = this.ncUtil.getDefDocById(receiveEntity.getReceiveWay());
        recNcVo.setBalatype(defDocById.getCode());
        recNcVo.setDef16(receiveEntity.getSettleStatus());
        recNcVo.setDef19(receiveEntity.getBillCode());
        recNcVo.setDef20(this.ncUtil.getWebSite("ejc-finance-frontend/#/receive/receiveCard?id=" + receiveEntity.getId()));
        recNcVo.setDef21("BT200622000000005");
        ArrayList<RecBillDetailVO> detailVOS = new ArrayList<RecBillDetailVO>();
        RecBillDetailVO detailVO = new RecBillDetailVO();
        List<ReceiveReceiptEntity> receiptEntityList = receiveEntity.getReceiveReceiptEntityList();
        for (ReceiveReceiptEntity receiptEntity : receiptEntityList) {
            detailVO.setPk_project(String.valueOf(receiveEntity.getProjectId()));
            detailVO.setLocal_mny(receiptEntity.getLocalMnyTax());
            detailVO.setBankaccount(receiptEntity.getBankCode());
            detailVO.setCashitem(this.ncUtil.getDefDocById(receiptEntity.getCashitemId()).getCode());
            detailVO.setBalatype(String.valueOf(receiptEntity.getBalatypeId()));
            detailVOS.add(detailVO);
        }
        recNcVo.setDetail(detailVOS);
        return recNcVo;
    }
}

