package com.ejianc.business.finance.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

/**
 * 实付款信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payInfo")
public class PayInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PAY_INFO_CODE";//此处需要根据实际修改

    @Autowired
    private IPayInfoService service;
    
    @Autowired
    private IPayContractService conservice;
    
    @Autowired
    private IPayContractSettleService consetservice;

    @Autowired
    private SessionManager sessionManager;

    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/insertOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayInfoVO> insertOrUpdate(@RequestBody PayInfoVO saveOrUpdateVO) {
    	PayInfoVO vo=service.insertOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayInfoVO> queryDetail(Long id) {
    	PayInfoEntity entity = service.selectById(id);
    	PayInfoVO vo = BeanMapper.map(entity, PayInfoVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayInfoVO> vos) {
        service.removeByIds(vos.stream().map(PayInfoVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表非网银支付
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListByNoBank", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryListByNoBank(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, getOrgList()));
        param.getParams().put("billState", new Parameter(QueryParam.EQ,0));
        param.getParams().put("isBank", new Parameter(QueryParam.EQ,"N"));
        
        IPage<PayInfoEntity> page = service.queryPage(param,false);
        IPage<PayInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表网银支付
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListByBank", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryListByBank(@RequestBody QueryParam param) {
    	JSONObject page = service.queryPendingPageJson(param, false);
    	return CommonResponse.success("查询列表数据成功！", page);
//    public CommonResponse<IPage<PayContractVO>> queryListByBank(@RequestBody QueryParam param) {

//        /** 模糊搜索配置字段示例 */
//        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFieldsAdd(fuzzyFields);
////        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
////        param.getParams().put("orgId", new Parameter(QueryParam.IN, getOrgList()));
////        param.getParams().put("billState", new Parameter(QueryParam.EQ,0));
////        param.getParams().put("isBank", new Parameter(QueryParam.EQ,"Y"));
////        IPage<PayInfoEntity> page = service.queryPage(param,false);
////        IPage<PayInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
////  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayInfoVO.class));
//    	
//        Long parentid = null;
//        List<Long> parentidlist = new ArrayList<>();
//        
//        QueryParam param2 = new QueryParam();
//        param2.getParams().put("settlePaymentMethod", new Parameter(QueryParam.EQ,"1460221804369940481"));//单据体收款方式为网银
//        param2.getParams().put("dr", new Parameter(QueryParam.EQ,"0"));
//        List<PayContractSettleEntity> page1 = consetservice.queryList(param2);
//        
//        for(PayContractSettleEntity conset : page1) {
//        	parentid = conset.getPayapplyId();
//        	if(!parentidlist.contains(parentid) && parentid != null) {
//        		parentidlist.add(parentid);
//        	}
//        }
//        String jsonString = JSONObject.toJSON(parentidlist).toString();
//        String parent = jsonString.replace("[", "(").replace("]", ")");
//        
//        
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        param.getParams().put("id", new Parameter(QueryParam.SQL,"id in "+parent+" or payment_method = 1460221804369940481"));
//        //筛选单据头网银或者单据体为网银
//
//        IPage<PayContractEntity> page = conservice.queryPage(param,false);
//        
//        IPage<PayContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表合同
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryContractList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryContractList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, getOrgList()));

        param.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
        param.getParams().put("payInfoType", new Parameter(QueryParam.EQ,"HT"));
        IPage<PayInfoEntity> page = service.queryPage(param,false);
        IPage<PayInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
  
    
    /**
     * @Description queryList 查询列表押金
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryForegiftList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryForegiftList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, getOrgList()));

        param.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
        param.getParams().put("payInfoType", new Parameter(QueryParam.EQ,"YJ"));
        IPage<PayInfoEntity> page = service.queryPage(param,false);
        IPage<PayInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表零星
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/querySporadicList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> querySporadicList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, getOrgList()));

        param.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
        param.getParams().put("payInfoType", new Parameter(QueryParam.EQ,"LX"));
        IPage<PayInfoEntity> page = service.queryPage(param,false);
        IPage<PayInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表其他
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReimburseList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryReimburseList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, getOrgList()));
        param.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
        param.getParams().put("payInfoType", new Parameter(QueryParam.EQ,"QT"));
        IPage<PayInfoEntity> page = service.queryPage(param,false);
        IPage<PayInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PayInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PayInfo-export.xlsx", beans, response);
    }

    
    public List<Long> getOrgList(){
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        return departmentIds;
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
    }
    
    public void fuzzyFieldsAdd(List<String> fuzzyFields) {
        fuzzyFields.add("billCode");
        fuzzyFields.add("payapplyCode");
        fuzzyFields.add("applyMny");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
    }
}
