package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
@Controller
@RequestMapping("/payReimburse")
public class PayReimburseController {

    private static final long serialVersionUID = 1L;

    @Autowired
    private IPayReimburseService payReimburseService;

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param payReimburseVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayReimburseVO> saveOrUpdate(@RequestBody PayReimburseVO payReimburseVO) {
        PayReimburseVO backVO = payReimburseService.insertOrUpdate(payReimburseVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryDetail(Long id) {
        PayReimburseVO backVO = payReimburseService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayReimburse", payReimburseService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
//        param.getParams().put("createUserCode",new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        JSONObject page = payReimburseService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryApproveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("approveTime", QueryParam.DESC);
        JSONObject page = payReimburseService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayReimburseVO> vos) {
        List<Long> ids = vos.stream().map(PayReimburseVO::getId).collect(Collectors.toList());
        String msg = payReimburseService.delete(ids);
        return CommonResponse.success(msg);
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("createUserCode",new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        List<PayReimburseVO> supplierVos = payReimburseService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("reim-payapply-export.xlsx", beans, response);
    }

    /**
     * 支出管理excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportApprove", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportApprove(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        List<PayReimburseVO> supplierVos = payReimburseService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("reim-payapply-export.xlsx", beans, response);
    }


    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description refer 商机登记列表参照
     *
     * @Param [pageNumber, pageSize, searchText]
     * @Return com.alibaba.fastjson.JSONObject
     */
    @RequestMapping(value = "/refer")
    @ResponseBody
    public JSONObject refer(@RequestParam(defaultValue = "1") Integer pageNumber,
                            @RequestParam(defaultValue = "10") Integer pageSize,
                            String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        IPage<PayReimburseEntity> pageData = payReimburseService.queryPage(queryParam,false);
        Page<PayReimburseEntity> page = new PageImpl<>(pageData.getRecords(),new PageRequest(pageNumber,pageSize),pageData.getTotal());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", page);
        jsonObject.put("code", "success");
        jsonObject.put("msg", "查询数表参照成功");
        return jsonObject;
    }

    /**
     * 查询收款账户信息
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryReceiveInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryReceiveInfo(QueryParam queryParam) {
        queryParam.getParams().put("applyUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<PayReimburseEntity> entityList = payReimburseService.queryList(queryParam,false);
        PayReimburseVO backVO = !entityList.isEmpty() ? BeanMapper.map( entityList.get(0), PayReimburseVO.class) : new PayReimburseVO();
        return CommonResponse.success("查询数据成功！", backVO);
    }
    /**成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayReimburseVO> pushCost(@RequestBody PayReimburseVO paySporadicVO) {
        return payReimburseService.pushCost(paySporadicVO);
    }

    /**
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
        param.getParams().put("createUserCode",new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        return CommonResponse.success("查询成功！", payReimburseService.getTotalColumnInfo(param, false));
    }

    /**
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取支出管理 合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getApproveTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("approveTime", QueryParam.DESC);
        return CommonResponse.success("查询成功！", payReimburseService.getApproveTotalColumnInfo(param, false));
    }

}
