package com.ejianc.business.finance.mbs.task;

import java.math.BigDecimal;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import com.ejianc.business.finance.utils.ApplicationContextUtil;
import com.ejianc.business.finance.utils.XmlUtils;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.mbs.bean.bank.BankEntity;
import com.ejianc.business.finance.mbs.bean.bank.request.BankMbsReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankPubReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqHeadVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankMbsRespVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankRespDetail;
import com.ejianc.business.finance.mbs.bean.pay.request.PayMbsReqVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayPubReqVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqDetail;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoMbsReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoPubReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqHeadVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.response.PayInfoMbsRespVo;
import com.ejianc.business.finance.mbs.service.IBankService;
import com.ejianc.business.finance.service.IPayInfoService;

@Component
public class MbsTask {
	@Autowired
	IBankService bankService;
	@Autowired
	IPayInfoService payInfoService;
	
	private String URL="http://58.56.155.202:8010/webservice/outService.ws";
	private String MD5="9601a2e927ec7225a2e65ed6ed942198";
	//指令
	//查询银行
	private String BankTRANSCODE="PBQB01";
	//推送支付
	private String PayTRANSCODE="PMSQ01";
	//查询支付状态
	private String PayInfoTRANSCODE="GETPAYINFO";
	//密码盐
	private String MD5Key="QDSZ123";
	
	
	@Scheduled(cron = "0 0 0 * * ?")  //间隔1秒
    public void saveMbsBankInfo() throws Exception {
		//银行档案实例
		List<BankEntity> bankList= new ArrayList<BankEntity>();
		
		//查询页数，每页条数
		BankReqHeadVo bankHeadVo=new BankReqHeadVo(1,100);
		//时间格式化 查询数据时间
		Date today = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String LASTMODIFIEDONSTART=sdf.format(today);
		String LASTMODIFIEDONEND=sdf.format(today);
		SimpleDateFormat sdfCodeF = new SimpleDateFormat("yyyyMMdd");
		String getCode=sdfCodeF.format(today);
		BankReqSearchonditionsVo bankSearchonditionsVo=new BankReqSearchonditionsVo("2023-01-01",LASTMODIFIEDONEND);
		BankReqVo bankReqVo=new BankReqVo(bankHeadVo,bankSearchonditionsVo);
		BankMbsReqVo mbsVo=new BankMbsReqVo();
		mbsVo.setReq(bankReqVo);
		String MD5=md5String(XmlUtils.getXmlFromObject(bankReqVo),MD5Key);
		//拼接pub 
		BankPubReqVo pubVo=new BankPubReqVo(getCode,BankTRANSCODE,MD5);
		mbsVo.setPub(pubVo);
		String xmlStr=XmlUtils.getXmlFromObject(mbsVo);
		xmlStr=splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
		//推送获取返回结果
		String sendResult = XmlUtils.sendXml(xmlStr,URL);
		sendResult=splicingXmlResponse(sendResult);
		System.out.println(sendResult);	
		//XML转换为Bean
		BankMbsRespVo mbsResponseVo=new BankMbsRespVo();
		mbsResponseVo=(BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
		//获取总页数
		int pageNum=mbsResponseVo.getResp().getPAGECOUNT();
		//页数大于1,需要循环遍历继续查询
		if(pageNum>1) {
			for (int i = 1; i > pageNum; i++) {
				mbsVo.getReq().getHead().setPAGEINDEX(i);
				sendResult = XmlUtils.sendXml(xmlStr,URL);
				mbsResponseVo=(BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
				List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
				for (BankRespDetail bankRespDetail : detail) {
					BankEntity entity=new BankEntity();
					entity.setId(IdWorker.getId());
					entity.setShortName(bankRespDetail.getName());
					entity.setName(bankRespDetail.getName());
					entity.setCode(bankRespDetail.getBankcode());
					entity.setBankCategoryId(null);
					entity.setBankCategoryName(null);
					bankList.add(entity);
				}
				//TODO 写入银行档案List中，保存实例到数据库中
				
			}
		}else if (pageNum==1) {
			//TODO 写入银行档案List中，保存实例到数据库中
			List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
			for (BankRespDetail bankRespDetail : detail) {
				BankEntity entity=new BankEntity();
				entity.setId(IdWorker.getId());
				entity.setShortName(bankRespDetail.getName());
				entity.setName(bankRespDetail.getName());
				entity.setCode(bankRespDetail.getBankcode());
				entity.setBankCategoryId(null);
				entity.setBankCategoryName(null);
				bankList.add(entity);
			}
		}
		if(bankList != null) {
		for (BankEntity bankEntity : bankList) {
			QueryWrapper<BankEntity> bankWrapper=new QueryWrapper<BankEntity>();
			bankWrapper.eq("code", bankEntity.getCode()).eq("dr", 0);
			List<BankEntity> entityList=bankService.list(bankWrapper);
			if(entityList.size()>0) {
				bankEntity.setId(entityList.get(0).getId());
				bankEntity.setCreateTime(entityList.get(0).getCreateTime());
				bankEntity.setCreateUserCode(entityList.get(0).getCreateUserCode());
			}
			bankService.saveOrUpdate(bankEntity);
		}
		}
	}
			
	//推送支付信息至资金系统
	public void getPayInfo()throws Exception {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("is_bank",new Parameter(QueryParam.EQ,"Y"));
		queryParam.getParams().put("create_time",new Parameter(QueryParam.SQL," datediff(now(),create_time)>3 "));
		//获取需要更新的数据
		List<PayInfoEntity> payInfoList=payInfoService.queryList(queryParam);
		String SRCSERIALNO=null;
		PayInfoMbsReqVo mbsReqVo=new PayInfoMbsReqVo();
		PayInfoReqHeadVo head=new PayInfoReqHeadVo(1, 10);
		PayInfoReqSearchonditionsVo searchconditions=new PayInfoReqSearchonditionsVo();
		PayInfoReqVo req=new PayInfoReqVo(null, null);
		for (PayInfoEntity payInfoEntity : payInfoList) {
			SRCSERIALNO=payInfoEntity.getId().toString();
			searchconditions.setSRCSERIALNO(SRCSERIALNO);
			req.setHead(head);
			req.setSearchconditions(searchconditions);
			mbsReqVo.setReq(req);
			String MD5=md5String(XmlUtils.getXmlFromObject(mbsReqVo.getReq()),MD5Key);
			PayInfoPubReqVo pubReqVo=new PayInfoPubReqVo(SRCSERIALNO,PayTRANSCODE,MD5);
			mbsReqVo.setPub(pubReqVo);
			String xmlStr=XmlUtils.getXmlFromObject(mbsReqVo);
			xmlStr=splicingXmlRequest(xmlStr);
	        System.out.println(xmlStr);
			//推送获取返回结果
			String sendResult = XmlUtils.sendXml(xmlStr,URL);
			sendResult=splicingXmlResponse(sendResult);
			System.out.println(sendResult);	
			//XML转换为Bean
			PayInfoMbsRespVo payMbsRespVo=new PayInfoMbsRespVo();
			payMbsRespVo=(PayInfoMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
			String payState=payMbsRespVo.getResp().getList().getDetail().get(0).getPaystate();
			if("2".equals(payState)) {
				payInfoEntity.setPayStatus(2);
				payInfoService.saveOrUpdate(payInfoEntity);
				PayInfoVO payInfoVO=BeanMapper.map(payInfoEntity, PayInfoVO.class);
				List<PayInfoVO> payInfovo=new ArrayList<PayInfoVO>();
				payInfovo.add(payInfoVO);
				payInfoService.batchConfirm(payInfovo);
			}else{
				payInfoEntity.setPayStatus(Integer.parseInt(payState));
				payInfoService.saveOrUpdate(payInfoEntity);
			}
		}



	}
			//request转
			private String splicingXmlRequest(String xml) {
				//拼接格式
				xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+xml;
				xml="<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:out=\"http://outsystem.ats.com.cn\"><soapenv:Header/><soapenv:Body><out:outSystemWS><out:in0><![CDATA["+xml+"]]></out:in0></out:outSystemWS></soapenv:Body></soapenv:Envelope>";
				return xml;
			}
			
			private String splicingXmlResponse(String xml) {
				//转义
				xml = StringEscapeUtils.unescapeXml(xml);
				//拼接获取XML
				int a=xml.indexOf("<MBS>");
				int b=xml.indexOf("</MBS>");
				xml=StringUtils.substring(xml, a, b)+"</MBS>";
				return xml;
			}
			private static String md5String(String md5String,String md5Key){
			    String md5Value = MD5Encoder(md5String + md5Key);
			    return md5Value;
			}
			
			public final static String MD5Encoder(String s) {
			    return MD5Encoder(s,"utf-8");
			}

			public final static String MD5Encoder(String s, String charset) {
			    try {
			        byte[] btInput = s.getBytes(charset);
			        MessageDigest mdInst = MessageDigest.getInstance("MD5");
			        mdInst.update(btInput);
			        byte[] md = mdInst.digest();
			        StringBuffer sb = new StringBuffer();
			        for (int i = 0; i < md.length; i++) {
			            int val = ((int) md[i]) & 0xff;
			            if (val < 16){
			                sb.append("0");
			            }
			            sb.append(Integer.toHexString(val));
			        }
			        return sb.toString();
			    } catch (Exception e) {
			        return null;
			    }
			}
}
