package com.ejianc.business.finance.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.finance.mapper.PayContractMapper;
import com.ejianc.business.finance.mapper.PayInfoMapper;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.vo.PayApplyPubVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayForegiftVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;

/**
 * 实付款信息
 * 
 * @author generator
 * 
 */
@Service("payInfoService")
public class PayInfoServiceImpl extends BaseServiceImpl<PayInfoMapper, PayInfoEntity> implements IPayInfoService{
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PAY_INFO_CODE";//此处需要根据实际修改
    
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;

    @Autowired
    private IPayForegiftService foregiftService;
    
    @Autowired
    private IOrgApi orgApi;
    
    @Autowired
    private IDefdocApi defdocApi;
    
    @Autowired
    private IPayContractSettleService consetservice;
    
    @Autowired
    private FeignUtil feignUtil;
    
    @Autowired
    private PayContractMapper conmapper;

	@Override
	public PayInfoVO insertOrUpdate(PayInfoVO saveOrUpdateVO) {
		//vo转化实体
		PayInfoEntity entity = BeanMapper.map(saveOrUpdateVO, PayInfoEntity.class);
		//获取租户编码
		Long tenantId = InvocationInfoProxy.getTenantid();
	   	if(entity.getBillCode() == null || "".equals(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
	   	saveOrUpdate(entity, false);
	   	PayInfoVO vo = BeanMapper.map(entity, PayInfoVO.class);
		return vo;
	}
	
	 @Override
	    public String batchConfirm(List<PayInfoVO> vos) {
	        for (PayInfoVO vo : vos) {
	            if ("HT".equals(vo.getPayInfoType())) {
	                PayContractVO updateVO = payContractService.queryDetail(vo.getId());
	                updateVO.setEmployeeId(vo.getEmployeeId());
	                updateVO.setEmployeeName(vo.getEmployeeName());
	                updateVO.setConfirmTime(vo.getConfirmTime());
	                updateVO.setPayMny(vo.getPayMny());
	                updateVO.setPayStatus(vo.getPayStatus());
	                payContractService.insertOrUpdate(updateVO);
	            }
	            if ("LX".equals(vo.getPayInfoType())) {
	                PaySporadicVO updateVO = sporadicService.queryDetail(vo.getId());
	                updateVO.setEmployeeId(vo.getEmployeeId());
	                updateVO.setEmployeeName(vo.getEmployeeName());
	                updateVO.setConfirmTime(vo.getConfirmTime());
	                updateVO.setPayMny(vo.getPayMny());
	                updateVO.setPayStatus(vo.getPayStatus());
	                sporadicService.insertOrUpdate(updateVO);
	            }
	            if ("QT".equals(vo.getPayInfoType())) {
	                PayReimburseVO updateVO = reimburseService.queryDetail(vo.getId());
	                updateVO.setEmployeeId(vo.getEmployeeId());
	                updateVO.setEmployeeName(vo.getEmployeeName());
	                updateVO.setConfirmTime(vo.getConfirmTime());
	                updateVO.setPayMny(vo.getPayMny());
	                updateVO.setPayStatus(vo.getPayStatus());
	                reimburseService.insertOrUpdate(updateVO);
	            }
	            if ("YJ".equals(vo.getPayInfoType())) {
	                PayForegiftVO updateVO = foregiftService.queryDetail(vo.getId());
	                updateVO.setEmployeeId(vo.getEmployeeId());
	                updateVO.setEmployeeName(vo.getEmployeeName());
	                updateVO.setConfirmTime(vo.getConfirmTime());
	                updateVO.setPayMny(vo.getPayMny());
	                updateVO.setPayStatus(vo.getPayStatus());
	                foregiftService.insertOrUpdate(updateVO);
	            }
	        }
	        return "批量支付成功！";
	    }
	 
	@Override
	public JSONObject queryPendingPageJson(QueryParam param, boolean isEs) {

		Long parentid = null;
		List<Long> parentidlist = new ArrayList<>();

		QueryParam param2 = new QueryParam();
		param2.getParams().put("settlePaymentMethod", new Parameter(QueryParam.EQ, "1460221804369940481"));// 单据体收款方式为网银
		param2.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
		List<PayContractSettleEntity> page1 = consetservice.queryList(param2);

		for (PayContractSettleEntity conset : page1) {
			parentid = conset.getPayapplyId();
			if (!parentidlist.contains(parentid) && parentid != null) {
				parentidlist.add(parentid);
			}
		}
		String jsonString = JSONObject.toJSON(parentidlist).toString();
		String parent = jsonString.replace("[", "(").replace("]", ")");
		// 查找合同付款，单据体含有网银的数据

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("orgName");
		fuzzyFields.add("receiveUnitName");
		fuzzyFields.add("applyUserName");
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		// 组织本下
		param.getParams().put("orgId",
				new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
						.stream().map(OrgVO::getId).collect(Collectors.toList())));
		// 已生效状态的单据
		param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
		param.getParams().put("payStatus", new Parameter(QueryParam.EQ, 1));// 未支付
		param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));// 未删除
		param.getParams().put("id", new Parameter(QueryParam.SQL,"project_id  in (select id from `ejc-market`.ejc_market_project where dr=0 and is_send_mbs =1) and (id in " + parent + " or  payment_method = 1460221804369940481)"));
		param.getOrderMap().put("approveTime", QueryParam.DESC);

		// 转换报销筛选条件
		transformReimburse(param);
		Page<PayApplyPubVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
		QueryWrapper wrapper = changeToQueryWrapper(param);
		List<PayApplyPubVO> list = conmapper.queryPendingList(pages, wrapper);
		Map<Long, String> defdocMap = feignUtil.getDefdocMap(324875125018329093L);
		if (!list.isEmpty()) {
			for (PayApplyPubVO vo : list) {
				// 翻译报销
				if ("其他费用".equals(vo.getApplyType()) && defdocMap.containsKey(Long.valueOf(vo.getFeeType()))) {
					vo.setFeeType("其他费用-" + defdocMap.get(Long.valueOf(vo.getFeeType())));
				}
			}
		}

		JSONObject page = new JSONObject();
		page.put("records", list);
		page.put("total", pages.getTotal());
		page.put("current", pages.getCurrent());
		page.put("size", pages.getSize());
		page.put("pages", pages.getPages());
		return page;
	}

	private void transformReimburse(QueryParam param) {
		// 判断筛选条件是否携带报销信息
		Parameter feeType = param.getParams().get("feeType");
		if (!Objects.equals(feeType, null)) {
			String value = feeType.getValue().toString();

			if (StringUtils.contains(value, "其他费用-")) {
				// 查询资金-付款申请-报销费用类别
				CommonResponse<List<DefdocDetailVO>> listCommonResponse = defdocApi
						.getDefDocByDefId(324875125018329093L);
				List<DefdocDetailVO> data = listCommonResponse.getData();
				String[] split = value.split(",");
				for (int i = 0; i < split.length; i++) {
					String feeTypeName = split[i];
					if (StringUtils.contains(feeTypeName, "其他费用-")) {
						List<DefdocDetailVO> list = data.stream()
								.filter(vo -> vo.getName().equals(feeTypeName.substring(5)))
								.collect(Collectors.toList());

						split[i] = list.get(0).getId().toString();
					}
				}

				value = StringUtils.join(split, ",");
				// 重新赋值
				feeType.setValue(value);
			}
		}
	}
    
}
