/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payInfo"})
public class PayInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PAY_INFO_CODE";
    @Autowired
    private IPayInfoService service;
    @Autowired
    private IPayContractService conservice;
    @Autowired
    private IPayContractSettleService consetservice;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDefdocApi defdocApi;

    @RequestMapping(value={"/insertOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayInfoVO> insertOrUpdate(@RequestBody PayInfoVO saveOrUpdateVO) {
        PayInfoVO vo = this.service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayInfoVO> queryDetail(Long id) {
        PayInfoEntity entity = (PayInfoEntity)((Object)this.service.selectById(id));
        PayInfoVO vo = (PayInfoVO)BeanMapper.map((Object)((Object)entity), PayInfoVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayInfoVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryListByNoBank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryListByNoBank(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        this.fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", this.getOrgList()));
        param.getParams().put("billState", new Parameter("eq", (Object)0));
        param.getParams().put("isBank", new Parameter("eq", (Object)"N"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListByBank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryListByBank(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        this.fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", this.getOrgList()));
        param.getParams().put("billState", new Parameter("eq", (Object)0));
        param.getParams().put("isBank", new Parameter("eq", (Object)"Y"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryContractList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryContractList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        this.fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", this.getOrgList()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("payInfoType", new Parameter("eq", (Object)"HT"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryForegiftList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryForegiftList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        this.fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", this.getOrgList()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("payInfoType", new Parameter("eq", (Object)"YJ"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySporadicList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> querySporadicList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        this.fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", this.getOrgList()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("payInfoType", new Parameter("eq", (Object)"LX"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReimburseList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayInfoVO>> queryReimburseList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        this.fuzzyFieldsAdd(fuzzyFields);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", this.getOrgList()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("payInfoType", new Parameter("eq", (Object)"QT"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PayInfo-export.xlsx", beans, response);
    }

    public List<Long> getOrgList() {
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        return departmentIds;
    }

    public void fuzzyFieldsAdd(List<String> fuzzyFields) {
        fuzzyFields.add("billCode");
        fuzzyFields.add("payapplyCode");
        fuzzyFields.add("applyMny");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
    }

    @RequestMapping(value={"/batchConfirm"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> batchConfirm(@RequestBody List<PayInfoVO> vos) {
        String msg = this.service.batchConfirm(vos);
        return CommonResponse.success((String)"\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01");
    }
}

