/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.pub.utils.HttpTookit;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/payReimburse"})
public class PayReimburseController {
    private static final long serialVersionUID = 1L;
    @Value(value="${nc.ncSeUrl}")
    private String ncSeUrl;
    @Autowired
    private NCUtil ncUtil;
    @Autowired
    private IPayReimburseService payReimburseService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayReimburseVO> saveOrUpdate(@RequestBody PayReimburseVO payReimburseVO) {
        PayReimburseVO backVO = this.payReimburseService.insertOrUpdate(payReimburseVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryDetail(Long id) {
        PayReimburseVO backVO = this.payReimburseService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/industry"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> industry(Long projectId) {
        ProjectRegisterVO projects = this.ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
        String industry = projects.getIndustryIntegrationFlag();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)industry);
    }

    @RequestMapping(value={"/isSendMbs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> issendmbs(Long projectId) {
        ProjectRegisterVO projects = this.ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
        String isSendMbs = projects.getIsSendMbs();
        System.out.println("\u662f\u5426\u5f00\u542f\u4e1a\u8d44\u4e00\u4f53\u5316\u7ed3\u679c\uff1a" + isSendMbs);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)isSendMbs);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayReimburse", (Object)this.payReimburseService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        JSONObject page = this.payReimburseService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        JSONObject page = this.payReimburseService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayReimburseVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.payReimburseService.delete(ids);
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        List<PayReimburseVO> supplierVos = this.payReimburseService.queryExportList(queryParam);
        HashMap<String, List<PayReimburseVO>> beans = new HashMap<String, List<PayReimburseVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("reim-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportApprove"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportApprove(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        List<PayReimburseVO> supplierVos = this.payReimburseService.queryExportList(queryParam);
        HashMap<String, List<PayReimburseVO>> beans = new HashMap<String, List<PayReimburseVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("reim-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refer"})
    @ResponseBody
    public JSONObject refer(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        IPage pageData = this.payReimburseService.queryPage(queryParam, false);
        PageImpl page = new PageImpl(pageData.getRecords(), (Pageable)new PageRequest(pageNumber.intValue(), pageSize.intValue()), pageData.getTotal());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)page);
        jsonObject.put("code", (Object)"success");
        jsonObject.put("msg", (Object)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f");
        return jsonObject;
    }

    @RequestMapping(value={"/queryReceiveInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryReceiveInfo(QueryParam queryParam) {
        queryParam.getParams().put("applyUserId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.payReimburseService.queryList(queryParam, false);
        PayReimburseVO backVO = !entityList.isEmpty() ? (PayReimburseVO)BeanMapper.map(entityList.get(0), PayReimburseVO.class) : new PayReimburseVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayReimburseVO> pushCost(@RequestBody PayReimburseVO paySporadicVO) {
        return this.payReimburseService.pushCost(paySporadicVO);
    }

    @RequestMapping(value={"getTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.payReimburseService.getTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getApproveTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.payReimburseService.getApproveTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getCarno"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Object>> getCarno(String param) {
        SimpleDateFormat enddate = new SimpleDateFormat("yyyy-MM-dd");
        param = "{\"busitype\":\"carno\",\"begindate\":\"2000-01-01\",\"enddate\": \"" + enddate + "\"}";
        ArrayList carnolist = new ArrayList();
        HashMap headers = new HashMap();
        String back = null;
        try {
            back = HttpTookit.postByJson((String)this.ncSeUrl, (String)param, headers);
        }
        catch (Exception e) {
            try {
                back = HttpTookit.postByJson((String)this.ncSeUrl, (String)param, headers);
            }
            catch (Exception e1) {
                throw new BusinessException("\u67e5\u8be2\u8f66\u724c\u63a5\u53e3\u5f02\u5e38!");
            }
        }
        if (!back.contains("code")) {
            throw new BusinessException("\u8fd4\u56de\u503c\u89e3\u6790\u5f02\u5e38!");
        }
        JSONObject json = JSONObject.parseObject((String)back);
        if (!"1".equals(json.getString("success"))) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONArray result = json.getJSONArray("result");
        for (int i = 0; i < result.size(); ++i) {
            Object object = result.get(i);
            Map mess = (Map)object;
            Integer dr = (Integer)mess.get("dr");
            Integer enable = (Integer)mess.get("enablestate");
            if (dr == null && enable == null || enable != 2 || dr != 0) continue;
            carnolist.add(object);
        }
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", carnolist);
    }
}

