/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.mbs.task;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.mbs.bean.bank.BankEntity;
import com.ejianc.business.finance.mbs.bean.bank.request.BankMbsReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankPubReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqHeadVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankMbsRespVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankRespDetail;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoMbsReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoPubReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqHeadVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.response.PayInfoMbsRespVo;
import com.ejianc.business.finance.mbs.service.IBankService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.utils.XmlUtils;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class MbsTask {
    @Autowired
    IBankService bankService;
    @Autowired
    IPayInfoService payInfoService;
    @Value(value="${mbs.mbsUrl}")
    private String URL;
    @Value(value="${mbs.MD5Key}")
    private String MD5Key;
    private String BankTRANSCODE = "PBQB01";
    private String PayTRANSCODE = "PMSQ01";
    private String PayInfoTRANSCODE = "GETPAYINFO";
    @Autowired
    private IDefdocApi defdocApi;

    @Scheduled(cron="0 0 0 * * ?")
    public void saveMbsBankInfo() throws Exception {
        ArrayList<BankEntity> bankList = new ArrayList<BankEntity>();
        BankReqHeadVo bankHeadVo = new BankReqHeadVo(1, 100);
        Date today = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String LASTMODIFIEDONSTART = sdf.format(today);
        String LASTMODIFIEDONEND = sdf.format(today);
        SimpleDateFormat sdfCodeF = new SimpleDateFormat("yyyyMMdd");
        String getCode = sdfCodeF.format(today);
        BankReqSearchonditionsVo bankSearchonditionsVo = new BankReqSearchonditionsVo("2023-01-01", LASTMODIFIEDONEND);
        BankReqVo bankReqVo = new BankReqVo(bankHeadVo, bankSearchonditionsVo);
        BankMbsReqVo mbsVo = new BankMbsReqVo();
        mbsVo.setReq(bankReqVo);
        String MD5 = MbsTask.md5String(XmlUtils.getXmlFromObject(bankReqVo), this.MD5Key);
        BankPubReqVo pubVo = new BankPubReqVo(getCode, this.BankTRANSCODE, MD5);
        mbsVo.setPub(pubVo);
        String xmlStr = XmlUtils.getXmlFromObject(mbsVo);
        xmlStr = this.splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
        String sendResult = XmlUtils.sendXml(xmlStr, this.URL);
        sendResult = this.splicingXmlResponse(sendResult);
        System.out.println(sendResult);
        BankMbsRespVo mbsResponseVo = new BankMbsRespVo();
        mbsResponseVo = (BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
        int pageNum = mbsResponseVo.getResp().getPAGECOUNT();
        if (pageNum > 1) {
            for (int i = 1; i > pageNum; ++i) {
                mbsVo.getReq().getHead().setPAGEINDEX(i);
                sendResult = XmlUtils.sendXml(xmlStr, this.URL);
                mbsResponseVo = (BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
                List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
                Iterator iterator = detail.iterator();
                while (iterator.hasNext()) {
                    BankRespDetail bankRespDetail = (BankRespDetail)iterator.next();
                    BankEntity entity = new BankEntity();
                    entity.setId(IdWorker.getId());
                    entity.setShortName(bankRespDetail.getName());
                    entity.setName(bankRespDetail.getName());
                    entity.setCode(bankRespDetail.getBankcode());
                    entity.setBankCategoryId(null);
                    entity.setBankCategoryName(null);
                    bankList.add(entity);
                }
            }
        } else if (pageNum == 1) {
            List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
            for (BankRespDetail bankRespDetail : detail) {
                BankEntity entity = new BankEntity();
                entity.setId(IdWorker.getId());
                entity.setShortName(bankRespDetail.getName());
                entity.setName(bankRespDetail.getName());
                entity.setCode(bankRespDetail.getBankcode());
                entity.setBankCategoryId(null);
                entity.setBankCategoryName(null);
                bankList.add(entity);
            }
        }
        if (bankList != null) {
            for (BankEntity bankEntity : bankList) {
                QueryWrapper bankWrapper = new QueryWrapper();
                ((QueryWrapper)bankWrapper.eq((Object)"code", (Object)bankEntity.getCode())).eq((Object)"dr", (Object)0);
                List entityList = this.bankService.list((Wrapper)bankWrapper);
                if (entityList.size() > 0) {
                    bankEntity.setId(((BankEntity)((Object)entityList.get(0))).getId());
                    bankEntity.setCreateTime(((BankEntity)((Object)entityList.get(0))).getCreateTime());
                    bankEntity.setCreateUserCode(((BankEntity)((Object)entityList.get(0))).getCreateUserCode());
                }
                this.bankService.saveOrUpdate((Object)bankEntity);
            }
        }
    }

    @Scheduled(cron="0 0 0,12 * * ?")
    public void getPayInfo() throws Exception {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("is_bank", new Parameter("eq", (Object)"Y"));
        queryParam.getParams().put("create_time", new Parameter("sql", (Object)" datediff(now(),create_time)>3 "));
        List payInfoList = this.payInfoService.queryList(queryParam);
        String SRCSERIALNO = null;
        PayInfoMbsReqVo mbsReqVo = new PayInfoMbsReqVo();
        PayInfoReqHeadVo head = new PayInfoReqHeadVo(1, 10);
        PayInfoReqSearchonditionsVo searchconditions = new PayInfoReqSearchonditionsVo();
        PayInfoReqVo req = new PayInfoReqVo(null, null);
        for (PayInfoEntity payInfoEntity : payInfoList) {
            SRCSERIALNO = payInfoEntity.getId().toString();
            searchconditions.setSRCSERIALNO(SRCSERIALNO);
            req.setHead(head);
            req.setSearchconditions(searchconditions);
            mbsReqVo.setReq(req);
            String MD5 = MbsTask.md5String(XmlUtils.getXmlFromObject(mbsReqVo.getReq()), this.MD5Key);
            PayInfoPubReqVo pubReqVo = new PayInfoPubReqVo(SRCSERIALNO, this.PayTRANSCODE, MD5);
            mbsReqVo.setPub(pubReqVo);
            String xmlStr = XmlUtils.getXmlFromObject(mbsReqVo);
            xmlStr = this.splicingXmlRequest(xmlStr);
            System.out.println(xmlStr);
            String sendResult = XmlUtils.sendXml(xmlStr, this.URL);
            sendResult = this.splicingXmlResponse(sendResult);
            System.out.println(sendResult);
            PayInfoMbsRespVo payMbsRespVo = new PayInfoMbsRespVo();
            payMbsRespVo = (PayInfoMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
            String payState = payMbsRespVo.getResp().getList().getDetail().get(0).getPaystate();
            payInfoEntity.setRenewMsg(xmlStr);
            payInfoEntity.setRenewResult(sendResult);
            if ("2".equals(payState)) {
                payInfoEntity.setPayStatus(2);
                this.payInfoService.saveOrUpdate((Object)payInfoEntity);
                PayInfoVO payInfoVO = (PayInfoVO)BeanMapper.map((Object)((Object)payInfoEntity), PayInfoVO.class);
                ArrayList<PayInfoVO> payInfovo = new ArrayList<PayInfoVO>();
                payInfovo.add(payInfoVO);
                this.payInfoService.batchConfirm(payInfovo);
                continue;
            }
            payInfoEntity.setPayStatus(Integer.parseInt(payState));
            this.payInfoService.saveOrUpdate((Object)payInfoEntity);
        }
    }

    @Scheduled(cron="0 0 0,12 * * ?")
    public void resendPayInfo() throws Exception {
        HashMap<String, String> allresponse = new HashMap<String, String>();
        CommonResponse response = this.defdocApi.getDefDocByDefCode("finance-pay-status");
        for (DefdocDetailVO defdocDetailVO : (List)response.getData()) {
            allresponse.put(defdocDetailVO.getCode(), defdocDetailVO.getName());
        }
        ArrayList<String> mbsStatusList = new ArrayList<String>();
        mbsStatusList.add("2");
        mbsStatusList.add("3");
        mbsStatusList.add("6");
        mbsStatusList.add("9");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("is_bank", new Parameter("eq", (Object)"Y"));
        queryParam.getParams().put("pay_status", new Parameter("not_in", mbsStatusList));
        List payInfoList = this.payInfoService.queryList(queryParam);
        String SRCSERIALNO = null;
        PayInfoMbsReqVo mbsReqVo = new PayInfoMbsReqVo();
        PayInfoReqHeadVo head = new PayInfoReqHeadVo(1, 10);
        PayInfoReqSearchonditionsVo searchconditions = new PayInfoReqSearchonditionsVo();
        PayInfoReqVo req = new PayInfoReqVo(null, null);
        for (PayInfoEntity payInfoEntity : payInfoList) {
            SRCSERIALNO = payInfoEntity.getId().toString();
            searchconditions.setSRCSERIALNO(SRCSERIALNO);
            req.setHead(head);
            req.setSearchconditions(searchconditions);
            mbsReqVo.setReq(req);
            String MD5 = MbsTask.md5String(XmlUtils.getXmlFromObject(mbsReqVo.getReq()), this.MD5Key);
            PayInfoPubReqVo pubReqVo = new PayInfoPubReqVo(SRCSERIALNO, this.PayTRANSCODE, MD5);
            mbsReqVo.setPub(pubReqVo);
            String xmlStr = XmlUtils.getXmlFromObject(mbsReqVo);
            xmlStr = this.splicingXmlRequest(xmlStr);
            System.out.println(xmlStr);
            String sendResult = XmlUtils.sendXml(xmlStr, this.URL);
            sendResult = this.splicingXmlResponse(sendResult);
            System.out.println(sendResult);
            PayInfoMbsRespVo payMbsRespVo = new PayInfoMbsRespVo();
            payMbsRespVo = (PayInfoMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
            String payState = payMbsRespVo.getResp().getList().getDetail().get(0).getPaystate();
            String jsonString = JSONObject.toJSON(payMbsRespVo.getResp().getList().getDetail()).toString();
            int start = jsonString.indexOf("<paystate>");
            int end = jsonString.indexOf("</paystate>");
            String code = jsonString.substring(start, end);
            payInfoEntity.setResult((String)allresponse.get(code));
            if ("2".equals(payState)) {
                payInfoEntity.setPayStatus(2);
                this.payInfoService.saveOrUpdate((Object)payInfoEntity);
                PayInfoVO payInfoVO = (PayInfoVO)BeanMapper.map((Object)((Object)payInfoEntity), PayInfoVO.class);
                ArrayList<PayInfoVO> payInfovo = new ArrayList<PayInfoVO>();
                payInfovo.add(payInfoVO);
                this.payInfoService.batchConfirm(payInfovo);
                continue;
            }
            payInfoEntity.setPayStatus(Integer.parseInt(payState));
            this.payInfoService.saveOrUpdate((Object)payInfoEntity);
        }
    }

    private String splicingXmlRequest(String xml) {
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xml;
        xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:out=\"http://outsystem.ats.com.cn\"><soapenv:Header/><soapenv:Body><out:outSystemWS><out:in0><![CDATA[" + xml + "]]></out:in0></out:outSystemWS></soapenv:Body></soapenv:Envelope>";
        return xml;
    }

    private String splicingXmlResponse(String xml) {
        xml = StringEscapeUtils.unescapeXml((String)xml);
        int a = xml.indexOf("<MBS>");
        int b = xml.indexOf("</MBS>");
        xml = StringUtils.substring((String)xml, (int)a, (int)b) + "</MBS>";
        return xml;
    }

    private static String md5String(String md5String, String md5Key) {
        String md5Value = MbsTask.MD5Encoder(md5String + md5Key);
        return md5Value;
    }

    public static final String MD5Encoder(String s) {
        return MbsTask.MD5Encoder(s, "utf-8");
    }

    public static final String MD5Encoder(String s, String charset) {
        try {
            byte[] btInput = s.getBytes(charset);
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < md.length; ++i) {
                int val = md[i] & 0xFF;
                if (val < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(val));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

