/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.EquipmentReportVo;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayForegiftPlanEntity;
import com.ejianc.business.finance.bean.PayForegiftRecordEntity;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.controller.SqlParam;
import com.ejianc.business.finance.enums.ConstantTypeEnum;
import com.ejianc.business.finance.mapper.PayContractMapper;
import com.ejianc.business.finance.pub.vo.PubContractSettleVO;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayForegiftPlanService;
import com.ejianc.business.finance.service.IPayForegiftRecordService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.MonthUtil;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BlocKanBanVo;
import com.ejianc.business.finance.vo.FinanceCostVO;
import com.ejianc.business.finance.vo.FinanceMonthVO;
import com.ejianc.business.finance.vo.ManageDetailVO;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.PayAndReceiveMnyWarnVO;
import com.ejianc.business.finance.vo.PayApplyPubVO;
import com.ejianc.business.finance.vo.PayContractSettleVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayForegiftVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PayMnyWarnVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.finance.vo.ProjectAppVo;
import com.ejianc.business.finance.vo.ReportAppVo;
import com.ejianc.business.finance.vo.SumMnyStatisticVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.income.api.IContractReportApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.qdsz.nc.vo.PayBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.PayBillVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayContractServiceImpl
extends BaseServiceImpl<PayContractMapper, PayContractEntity>
implements IPayContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
    private static final String CHECK_PARAM_CODE = "P-v1U24318";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IPayContractSettleService settleService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    @Autowired
    private IPayForegiftService foregiftService;
    @Autowired
    private IPayForegiftRecordService recordService;
    @Autowired
    private IPayForegiftPlanService planService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private ISubContractForPayApi subApi;
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IMaterialSettlementApi materialApi;
    @Autowired
    private IIncomeContractApi incomeApi;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private IContractReportApi contractReportApi;
    @Autowired
    private ISubReportApi subReportApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private PayContractMapper payContractMapper;
    @Autowired
    private NCUtil ncUtil;

    @Override
    public PayContractVO insertOrUpdate(PayContractVO vo) {
        PayContractEntity entity;
        Boolean isbank = false;
        Long feetype = vo.getFeeType();
        String paymentMethodName = vo.getPaymentMethodName();
        List settleVOs = vo.getSettleVOList();
        if (paymentMethodName.equals("\u7f51\u94f6") && !feetype.equals(1L)) {
            for (PayContractSettleVO volist : settleVOs) {
                if (!volist.getSettlePaymentMethodName().equals("\u7f51\u94f6")) continue;
                isbank = true;
            }
            if (isbank.equals(false)) {
                throw new BusinessException("\u6536\u4ed8\u6b3e\u65b9\u5f0f\u4e3a\u7f51\u94f6\u65f6\uff0c\u5355\u636e\u4f53\u5fc5\u987b\u8981\u6709\u7f51\u94f6\u4ed8\u6b3e\u6570\u636e\uff01");
            }
        } else if (!paymentMethodName.equals("\u7f51\u94f6") && !feetype.equals(1L)) {
            for (PayContractSettleVO volist : settleVOs) {
                if (!volist.getSettlePaymentMethodName().equals("\u7f51\u94f6")) continue;
                throw new BusinessException("\u6536\u4ed8\u6b3e\u65b9\u5f0f\u4e3a\u975e\u7f51\u94f6\u65f6\uff0c\u4e0d\u5141\u8bb8\u7f51\u94f6\u4ed8\u6b3e\u65b9\u5f0f\uff01");
            }
        }
        if (null == (entity = (PayContractEntity)((Object)BeanMapper.map((Object)vo, PayContractEntity.class))).getInvoiceFlag()) {
            entity.setInvoiceFlag(3);
        }
        Long projectId = vo.getProjectId();
        ProjectRegisterVO projects = this.ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
        String mbs = projects.getIsSendMbs();
        boolean writeFlag = this.getWriteFlag(vo);
        if (!vo.getManageFlag()) {
            this.validateBeforeSave(entity);
        }
        String billTypeCode = BillTypeCodeEnum.getContractBillTypeCode((Long)vo.getContractType());
        if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(vo.getContractId()), (String)billTypeCode, (Integer)vo.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        List settleVOListMny = vo.getSettleVOList();
        for (PayContractSettleVO payContractSettleVO : settleVOListMny) {
            String settleId = payContractSettleVO.getSettleId().toString();
            BigDecimal sumBodyApplyMny = new BigDecimal(0);
            BigDecimal surplusApplyMny = payContractSettleVO.getSurplusApplyMny();
            for (PayContractSettleVO payContractSettleVOtemp : settleVOListMny) {
                String settleIdTemp = payContractSettleVOtemp.getSettleId().toString();
                if (!settleId.equals(settleIdTemp) || (sumBodyApplyMny = sumBodyApplyMny.add(payContractSettleVOtemp.getBodyApplyMny())).setScale(2, 4).compareTo(surplusApplyMny.setScale(2, 4)) <= 0) continue;
                throw new BusinessException("\u7ed3\u7b97\u5355" + payContractSettleVO.getSettleCode() + " \u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u5927\u4e8e\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d");
            }
        }
        this.autoSetBillCode(entity);
        super.saveOrUpdate((Object)entity);
        Long id = entity.getId();
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        List<PayContractSettleVO> settleVOList = this.updateSettleVOS(vo, id);
        if (writeFlag) {
            ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
            if ("1".equals(project.getIndustryIntegrationFlag())) {
                this.pushToNcAr(entity);
            }
            this.writeBackSumPayMny(id, entity, true);
        }
        PayContractVO backVO = (PayContractVO)BeanMapper.map((Object)super.getById((Serializable)id), PayContractVO.class);
        backVO.setInvoiceVOList(invoiceVOList);
        backVO.setSettleVOList(settleVOList);
        return backVO;
    }

    @Override
    public PayContractVO queryDetail(Long id) {
        PayContractEntity entity = (PayContractEntity)((Object)((PayContractMapper)this.baseMapper).selectById(id));
        PayContractVO vo = (PayContractVO)BeanMapper.map((Object)((Object)entity), PayContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, PayInvoiceVO.class));
        List settleEntityList = this.settleService.queryList(queryParam, false);
        vo.setSettleVOList(BeanMapper.mapList((Iterable)settleEntityList, PayContractSettleVO.class));
        return vo;
    }

    @Override
    public List<PayContractVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PayContractVO vo = (PayContractVO)resVos.get(i);
                vo.setFeeTypeName(ConstantTypeEnum.getEnumByCode(vo.getFeeType()).getName());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.removeByIds(ids, false);
            this.invoiceService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            this.settleService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("payReason");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        NCUtil.voucherParam(param);
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(pages, wrapper, flag);
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public JSONObject querySettleRefer(QueryParam param, Integer contractType) {
        CommonResponse apiContract = null;
        if (contractType != null) {
            switch (contractType) {
                case 1: {
                    break;
                }
                case 2: {
                    apiContract = this.equipmentApi.getContractSettle(param);
                    break;
                }
                case 3: {
                    apiContract = this.equipmentApi.getRentSettle(param);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    apiContract = this.rmatContractApi.getRmatSettle(param);
                }
            }
        }
        JSONObject page = new JSONObject();
        if (apiContract.isSuccess()) {
            page = (JSONObject)apiContract.getData();
            ((JSONObject)apiContract.getData()).get((Object)"records");
            ObjectMapper mapper = new ObjectMapper();
            List settleVOList = (List)mapper.convertValue(((JSONObject)apiContract.getData()).get((Object)"records"), (TypeReference)new TypeReference<List<PubContractSettleVO>>(){});
            if (!settleVOList.isEmpty()) {
                PubContractSettleVO vo;
                Map settleMap = settleVOList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                List ids = settleVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
                QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().in((Object)"settle_id", ids);
                wrapper.last("and payapply_id in (select id from ejc_finance_pay_contract where dr = 0 and bill_state in (1,3))");
                List entityList = this.settleService.list((Wrapper)wrapper);
                for (PayContractSettleEntity entity : entityList) {
                    if (!settleMap.containsKey(entity.getSettleId())) continue;
                    vo = (PubContractSettleVO)settleMap.get(entity.getSettleId());
                    vo.setSumApplyMny(MathUtil.safeAdd((BigDecimal)vo.getSumApplyMny(), (BigDecimal)entity.getBodyApplyMny()));
                }
                for (Long id : settleMap.keySet()) {
                    vo = (PubContractSettleVO)settleMap.get(id);
                    vo.setSurplusApplyMny(MathUtil.safeSub((BigDecimal)vo.getSettleMny(), (BigDecimal)vo.getSumApplyMny()));
                    if (vo.getSurplusApplyMny().compareTo(new BigDecimal(0)) != 0) continue;
                    settleMap.remove(id);
                }
                page.put("records", new ArrayList(settleMap.values()));
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return page;
    }

    @Override
    public SumPayMnyVO getSumPayMny(Long contractId, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        if (orgId != null) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        }
        List entityList = super.queryList(param, false);
        SumPayMnyVO vo = new SumPayMnyVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        BigDecimal sumPayMny = null;
        BigDecimal sumPrePayMny = null;
        BigDecimal sumOffsetMny = BigDecimal.ZERO;
        for (PayContractEntity entity : entityList) {
            if (2 == entity.getPayStatus() && (entity.getBillState() == BillStateEnum.COMMITED_STATE.getBillStateCode() || BillStateEnum.PASSED_STATE.getBillStateCode() == entity.getBillState())) {
                sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)entity.getPayMny());
                if (entity.getFeeType() == 1L) {
                    sumPrePayMny = MathUtil.safeAdd(sumPrePayMny, (BigDecimal)entity.getPayMny());
                }
            }
            sumOffsetMny = MathUtil.safeAdd((BigDecimal)sumOffsetMny, (BigDecimal)entity.getOffsetMny());
        }
        vo.setSumPayMny(sumPayMny);
        vo.setSumPrePayMny(sumPrePayMny);
        vo.setSumOffsetMny(sumOffsetMny);
        vo.setSumLastOffsetMny(MathUtil.safeSub((BigDecimal)vo.getSumPrePayMny(), (BigDecimal)vo.getSumOffsetMny()));
        return vo;
    }

    @Override
    public SumPayMnyVO getSumPayMnyVOList(Long contractId, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("payStatus", new Parameter("eq", (Object)2));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("createTime", "desc");
        List entityList = super.queryList(param, false);
        BigDecimal sumPayMny = null;
        for (PayContractEntity entity : entityList) {
            sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)entity.getPayMny());
        }
        SumPayMnyVO vo = new SumPayMnyVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        vo.setSumPayMny(sumPayMny);
        vo.setContractVOList(BeanMapper.mapList((Iterable)entityList, PayContractVO.class));
        return vo;
    }

    @Override
    public JSONObject queryPendingPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("payStatus", new Parameter("eq", (Object)1));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        String SqlStr = " ((is_send_mbs = 0 ) OR (is_send_mbs = 1 AND (payment_method_name != '\u7f51\u94f6' OR a.id IN ( SELECT payapply_id FROM ejc_finance_pay_contract_settle WHERE settle_payment_method_name != '\u7f51\u94f6' AND dr = 0 )))) ";
        param.getParams().put("id", new Parameter("sql", (Object)SqlStr));
        param.getOrderMap().put("approveTime", "desc");
        this.transformReimburse(param);
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayApplyPubVO> list = ((PayContractMapper)this.baseMapper).queryPendingList(pages, wrapper);
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(324875125018329093L);
        if (!list.isEmpty()) {
            for (PayApplyPubVO vo : list) {
                if (!"\u5176\u4ed6\u8d39\u7528".equals(vo.getApplyType()) || !defdocMap.containsKey(Long.valueOf(vo.getFeeType()))) continue;
                vo.setFeeType("\u5176\u4ed6\u8d39\u7528-" + defdocMap.get(Long.valueOf(vo.getFeeType())));
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public List<PayApplyPubVO> queryExportPendingList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List records = (List)this.queryPendingPageJson(param, false).get((Object)"records");
        return records;
    }

    @Override
    public String batchConfirm(List<PayApplyPubVO> vos) {
        for (PayApplyPubVO vo : vos) {
            PayContractVO updateVO;
            Long projectId = vo.getProjectId();
            ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
            String mbs = project.getIsSendMbs();
            String industry = project.getIndustryIntegrationFlag();
            boolean idin = false;
            String methon = vo.getPaymentMethodName();
            Long id = vo.getId();
            if ("\u5408\u540c\u4ed8\u6b3e".equals(vo.getApplyType())) {
                Long parentid = null;
                ArrayList<Long> parentidlist = new ArrayList<Long>();
                QueryParam param2 = new QueryParam();
                param2.getParams().put("settlePaymentMethod", new Parameter("sql", (Object)"settle_payment_method_name != '\u7f51\u94f6'"));
                param2.getParams().put("dr", new Parameter("eq", (Object)"0"));
                List page1 = this.settleService.queryList(param2);
                if (page1.size() != 0) {
                    for (PayContractSettleEntity conset : page1) {
                        parentid = conset.getPayapplyId();
                        if (parentidlist.contains(parentid) || parentid == null) continue;
                        parentidlist.add(parentid);
                    }
                    for (Long ids : parentidlist) {
                        if (!ids.equals(id)) continue;
                        idin = true;
                    }
                }
            }
            if ("\u5408\u540c\u4ed8\u6b3e".equals(vo.getApplyType()) && (!mbs.equals("1") || !methon.equals("\u7f51\u94f6") || idin) && industry.equals("1")) {
                updateVO = this.queryDetail(vo.getId());
                updateVO.setEmployeeId(vo.getEmployeeId());
                updateVO.setEmployeeName(vo.getEmployeeName());
                updateVO.setConfirmTime(vo.getConfirmTime());
                updateVO.setPayMny(vo.getPayMny());
                updateVO.setPayStatus(vo.getPayStatus());
                this.insertOrUpdate(updateVO);
                continue;
            }
            if ("\u96f6\u661f\u91c7\u8d2d".equals(vo.getApplyType()) && (!mbs.equals("1") || !methon.equals("\u7f51\u94f6")) && industry.equals("1")) {
                updateVO = this.sporadicService.queryDetail(vo.getId());
                updateVO.setEmployeeId(vo.getEmployeeId());
                updateVO.setEmployeeName(vo.getEmployeeName());
                updateVO.setConfirmTime(vo.getConfirmTime());
                updateVO.setPayMny(vo.getPayMny());
                updateVO.setPayStatus(vo.getPayStatus());
                this.sporadicService.insertOrUpdate((PaySporadicVO)updateVO);
                continue;
            }
            if ("\u5176\u4ed6\u8d39\u7528".equals(vo.getApplyType()) && (!mbs.equals("1") || !methon.equals("\u7f51\u94f6")) && industry.equals("1")) {
                updateVO = this.reimburseService.queryDetail(vo.getId());
                updateVO.setEmployeeId(vo.getEmployeeId());
                updateVO.setEmployeeName(vo.getEmployeeName());
                updateVO.setConfirmTime(vo.getConfirmTime());
                updateVO.setPayMny(vo.getPayMny());
                updateVO.setPayStatus(vo.getPayStatus());
                this.reimburseService.insertOrUpdate((PayReimburseVO)updateVO);
                continue;
            }
            if ("\u62bc\u91d1".equals(vo.getApplyType()) && industry.equals("1")) {
                updateVO = this.foregiftService.queryDetail(vo.getId());
                updateVO.setEmployeeId(vo.getEmployeeId());
                updateVO.setEmployeeName(vo.getEmployeeName());
                updateVO.setConfirmTime(vo.getConfirmTime());
                updateVO.setPayMny(vo.getPayMny());
                updateVO.setPayStatus(vo.getPayStatus());
                this.foregiftService.insertOrUpdate((PayForegiftVO)updateVO);
                continue;
            }
            if (!industry.equals("1")) {
                throw new BusinessException("\u9879\u76ee\u672a\u5f00\u542f\u4e1a\u8d22\u4e00\u4f53\u5316,\u5355\u636e\u65e0\u6cd5\u8fdb\u884c\u6279\u91cf\u652f\u4ed8");
            }
            throw new BusinessException("\u4e1a\u8d44\u7f51\u94f6\u7c7b\u5355\u636e\u65e0\u6cd5\u8fdb\u884c\u6279\u91cf\u652f\u4ed8");
        }
        return "\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01";
    }

    @Override
    public ManageDetailVO getManageDetail(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        List receiveList = this.receiveService.queryList(param, false);
        BigDecimal sumReceiveMny = null;
        for (ReceiveEntity receive : receiveList) {
            sumReceiveMny = MathUtil.safeAdd(sumReceiveMny, (BigDecimal)receive.getReceiveMny());
        }
        List contractList = super.queryList(param, false);
        BigDecimal sumPayMny = null;
        for (PayContractEntity contract : contractList) {
            sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)contract.getPayMny());
        }
        BigDecimal manageFeeRate = null;
        BigDecimal manageFee = null;
        CommonResponse incomeContract = this.incomeApi.searchContract(projectId);
        if (incomeContract.isSuccess() && incomeContract.getData() != null) {
            manageFeeRate = ((ContractVo)incomeContract.getData()).getManageChargeRate();
            manageFee = MathUtil.safeMultiply((BigDecimal)sumReceiveMny, (BigDecimal)MathUtil.safeDiv((BigDecimal)manageFeeRate, (BigDecimal)new BigDecimal(100)));
        }
        BigDecimal surplusPayMny = MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)sumReceiveMny, manageFee), (BigDecimal)sumPayMny);
        ManageDetailVO vo = new ManageDetailVO();
        vo.setProjectId(projectId);
        vo.setSumReceiveMny(sumReceiveMny);
        vo.setManageFeeRate(manageFeeRate);
        vo.setManageFee(manageFee);
        vo.setSumPayMny(sumPayMny);
        vo.setSurplusPayMny(surplusPayMny);
        return vo;
    }

    @Override
    public SumMnyStatisticVO getStatisticsMny() {
        QueryParam param = new QueryParam();
        List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        List contractList = super.queryList(param, false);
        List sporadicList = this.sporadicService.queryList(param, false);
        List reimburseList = this.reimburseService.queryList(param, false);
        List foregiftList = this.foregiftService.queryList(param, false);
        BigDecimal sumApplyMny = null;
        BigDecimal sumPayMny = null;
        BigDecimal sumContractPayMny = null;
        BigDecimal sumSporadicPayMny = null;
        BigDecimal sumReimbursePayMny = null;
        BigDecimal sumForegiftPayMny = null;
        for (PayContractEntity contract : contractList) {
            sumApplyMny = MathUtil.safeAdd(sumApplyMny, (BigDecimal)contract.getApplyMny());
            sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)contract.getPayMny());
            sumContractPayMny = MathUtil.safeAdd(sumContractPayMny, (BigDecimal)contract.getPayMny());
        }
        for (PaySporadicEntity sporadic : sporadicList) {
            sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)sporadic.getApplyMny());
            sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)sporadic.getPayMny());
            sumSporadicPayMny = MathUtil.safeAdd(sumSporadicPayMny, (BigDecimal)sporadic.getPayMny());
        }
        for (PayReimburseEntity reimburse : reimburseList) {
            sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)reimburse.getApplyMny());
            sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)reimburse.getPayMny());
            sumReimbursePayMny = MathUtil.safeAdd(sumReimbursePayMny, (BigDecimal)reimburse.getPayMny());
        }
        for (PayForegiftEntity foregift : foregiftList) {
            sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)foregift.getApplyMny());
            sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)foregift.getPayMny());
            sumForegiftPayMny = MathUtil.safeAdd(sumForegiftPayMny, (BigDecimal)foregift.getPayMny());
        }
        List payapplyIds = foregiftList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        BigDecimal sumReturnMny = null;
        BigDecimal sumPlanMny = null;
        if (!payapplyIds.isEmpty()) {
            List recordList = this.recordService.list((Wrapper)new QueryWrapper().in((Object)"payapply_id", payapplyIds));
            for (PayForegiftRecordEntity record : recordList) {
                sumReturnMny = MathUtil.safeAdd(sumReturnMny, (BigDecimal)record.getReturnMny());
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"payapply_id", payapplyIds);
            wrapper.between((Object)"plan_time", (Object)PayContractServiceImpl.getTime("min"), (Object)PayContractServiceImpl.getTime("max"));
            List planList = this.planService.list((Wrapper)wrapper);
            for (PayForegiftPlanEntity plan : planList) {
                sumPlanMny = MathUtil.safeAdd(sumPlanMny, (BigDecimal)plan.getPlanMny());
            }
        }
        BigDecimal sumUnPayMny = MathUtil.safeSub((BigDecimal)sumApplyMny, (BigDecimal)sumPayMny);
        SumMnyStatisticVO vo = new SumMnyStatisticVO();
        vo.setOrgIds(orgIds);
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        vo.setSumUnPayMny(sumUnPayMny);
        vo.setSumContractPayMny(sumContractPayMny);
        vo.setSumSporadicPayMny(sumSporadicPayMny);
        vo.setSumReimbursePayMny(sumReimbursePayMny);
        vo.setSumForegiftPayMny(sumForegiftPayMny);
        vo.setSumReturnMny(sumReturnMny);
        vo.setSumPlanMny(sumPlanMny);
        return vo;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        queryWrapper.select(new String[]{"ifnull(sum(pay_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"pay_status", (Object)2);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public List<FinanceMonthVO> getMonthInfo(Long projectId, String timeRange) {
        Date startDate = MonthUtil.monthFAdd(new Date(), -999);
        Date endDate = new Date();
        if ("3month".equals(timeRange)) {
            startDate = MonthUtil.monthFAdd(new Date(), -2);
        } else if ("6month".equals(timeRange)) {
            startDate = MonthUtil.monthFAdd(new Date(), -5);
        } else if ("thisYear".equals(timeRange)) {
            startDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth());
        } else if ("lastYear".equals(timeRange)) {
            startDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth() - 12);
            endDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth());
        }
        String startStr = DateUtil.format((Date)startDate, (String)"yyyy-MM-dd");
        String endStr = DateUtil.format((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss");
        this.logger.info("startDate:" + startStr);
        this.logger.info("endDate:" + endStr);
        List<FinanceMonthVO> listReceive = ((PayContractMapper)this.baseMapper).getMonthReceiveMny(projectId, startStr, endStr);
        List<FinanceMonthVO> listOut = ((PayContractMapper)this.baseMapper).getMonthOutMny(projectId, startStr, endStr);
        Map map = listReceive.stream().collect(Collectors.toMap(FinanceMonthVO::getTerm, Function.identity()));
        if (ListUtil.isNotEmpty(listOut)) {
            listOut.forEach(financeMonthVO -> {
                if (map.containsKey(financeMonthVO.getTerm())) {
                    ((FinanceMonthVO)map.get(financeMonthVO.getTerm())).setSumOutMny(financeMonthVO.getSumOutMny());
                } else {
                    map.put(financeMonthVO.getTerm(), financeMonthVO);
                }
            });
        }
        List financeMonthVOList = map.entrySet().stream().map(et -> (FinanceMonthVO)et.getValue()).collect(Collectors.toList());
        for (FinanceMonthVO financeMonthVO2 : financeMonthVOList) {
            financeMonthVO2.setProfit(financeMonthVO2.getSumReceiveMny().subtract(financeMonthVO2.getSumOutMny()));
        }
        List bodys = financeMonthVOList.stream().filter(s -> !s.getSumOutMny().equals(BigDecimal.ZERO) || !s.getSumReceiveMny().equals(BigDecimal.ZERO)).collect(Collectors.toList());
        List collect = bodys.stream().sorted(Comparator.comparing(FinanceMonthVO::getTerm)).collect(Collectors.toList());
        HashMap<String, FinanceMonthVO> collectMap = new HashMap<String, FinanceMonthVO>();
        for (FinanceMonthVO vo : collect) {
            collectMap.put(vo.getTerm(), vo);
        }
        if ("lastYear".equals(timeRange)) {
            endDate = MonthUtil.monthFAdd(endDate, -1);
            endStr = DateUtil.format((Date)endDate, (String)"yyyy-MM-dd");
        }
        List<String> monthList = MonthUtil.getMonthList(startStr, endStr);
        ArrayList<FinanceMonthVO> newCollect = new ArrayList<FinanceMonthVO>();
        for (int i = 0; i < monthList.size(); ++i) {
            FinanceMonthVO financeMonthVO3 = (FinanceMonthVO)collectMap.get(monthList.get(i));
            if (null == financeMonthVO3) {
                FinanceMonthVO vo = new FinanceMonthVO();
                vo.setSumReceiveMny(BigDecimal.ZERO);
                vo.setProfit(BigDecimal.ZERO);
                vo.setSumOutMny(BigDecimal.ZERO);
                vo.setTerm(monthList.get(i));
                vo.setMonthTerm(monthList.get(i).substring(2, 7));
                newCollect.add(vo);
                continue;
            }
            newCollect.add(financeMonthVO3);
        }
        return newCollect;
    }

    @Override
    public List<FinanceCostVO> getCostInfo(Long projectId) {
        List<FinanceCostVO> listReceive = ((PayContractMapper)this.baseMapper).getCostInfo(projectId);
        return listReceive;
    }

    @Override
    public Map<String, BigDecimal> getSubSettlePay(PubContractSubQueryVO pubContractSubQueryVO) {
        Long thisMny = ((PayContractMapper)this.baseMapper).selectSubThisPay(pubContractSubQueryVO.getContractId(), pubContractSubQueryVO.getProjectId(), pubContractSubQueryVO.getSettleId());
        Long sumMny = ((PayContractMapper)this.baseMapper).selectSubSumPay(pubContractSubQueryVO.getContractId(), pubContractSubQueryVO.getProjectId(), pubContractSubQueryVO.getSettleDate(), pubContractSubQueryVO.getSettleIdList());
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("thisMny", thisMny != null ? BigDecimal.valueOf(thisMny) : BigDecimal.ZERO);
        map.put("sumMny", sumMny != null ? BigDecimal.valueOf(sumMny) : BigDecimal.ZERO);
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> getPayMnyByTenantIds(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, PayMnyWarnVO> map = new HashMap<String, PayMnyWarnVO>();
        List<PayMnyWarnVO> list = ((PayContractMapper)this.baseMapper).getPayMnyByTenantIds(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getOrgId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumPayMnyMap(List<Long> tenantIds) {
        HashMap<Long, PayAndReceiveMnyWarnVO> map = new HashMap<Long, PayAndReceiveMnyWarnVO>();
        this.transPayContractToMap(map, tenantIds);
        this.transPaySporadicToMap(map, tenantIds);
        this.transPayReimburseToMap(map, tenantIds);
        this.transLoadReimburseToMap(map, tenantIds);
        return map;
    }

    private void transPayContractToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PayContractEntity::getPayStatus, (Object)2);
        lambda.in(PayContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = super.list((Wrapper)lambda);
        for (PayContractEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumPayMny(entity.getPayMny());
                map.put(projectId, vo);
                continue;
            }
            vo = map.get(projectId);
            vo.setSumPayMny(MathUtil.safeAdd((BigDecimal)vo.getSumPayMny(), (BigDecimal)entity.getPayMny()));
        }
    }

    private void transPaySporadicToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PaySporadicEntity::getPayStatus, (Object)2);
        lambda.in(PaySporadicEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.sporadicService.list((Wrapper)lambda);
        for (PaySporadicEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumPayMny(entity.getPayMny());
                map.put(projectId, vo);
                continue;
            }
            vo = map.get(projectId);
            vo.setSumPayMny(MathUtil.safeAdd((BigDecimal)vo.getSumPayMny(), (BigDecimal)entity.getPayMny()));
        }
    }

    private void transPayReimburseToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PayReimburseEntity::getPayStatus, (Object)2);
        lambda.in(PayReimburseEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.reimburseService.list((Wrapper)lambda);
        for (PayReimburseEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumPayMny(entity.getPayMny());
                map.put(projectId, vo);
                continue;
            }
            vo = map.get(projectId);
            vo.setSumPayMny(MathUtil.safeAdd((BigDecimal)vo.getSumPayMny(), (BigDecimal)entity.getPayMny()));
        }
    }

    private void transLoadReimburseToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(LoadReimburseEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.loadReimburseService.list((Wrapper)lambda);
        for (LoadReimburseEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumPayMny(entity.getReimburseMny());
                map.put(projectId, vo);
                continue;
            }
            vo = map.get(projectId);
            vo.setSumPayMny(MathUtil.safeAdd((BigDecimal)vo.getSumPayMny(), (BigDecimal)entity.getReimburseMny()));
        }
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumReceiveMnyMap(List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(ReceiveEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.receiveService.list((Wrapper)lambda);
        HashMap<Long, PayAndReceiveMnyWarnVO> map = new HashMap<Long, PayAndReceiveMnyWarnVO>();
        for (ReceiveEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumReceiveMny(entity.getReceiveMny());
                map.put(projectId, vo);
                continue;
            }
            vo = (PayAndReceiveMnyWarnVO)map.get(projectId);
            vo.setSumReceiveMny(MathUtil.safeAdd((BigDecimal)vo.getSumReceiveMny(), (BigDecimal)entity.getReceiveMny()));
        }
        return map;
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumReimburseMnyMap(List<Long> tenantIds) {
        HashMap<Long, PayAndReceiveMnyWarnVO> map = new HashMap<Long, PayAndReceiveMnyWarnVO>();
        this.transPayReimburseToMap(map, tenantIds);
        this.transLoadReimburseToMap(map, tenantIds);
        return map;
    }

    @Override
    public List<Map<String, Object>> queryBondExpireWarn(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> upList = ((PayContractMapper)this.baseMapper).queryBondUpExpireWarn(sqlParamList);
        List<Map<String, Object>> downList = ((PayContractMapper)this.baseMapper).queryBondDownExpireWarn(sqlParamList);
        upList.addAll(downList);
        return upList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JSONObject projectProgress(Long projectId, Date startDate, Date endDate) {
        Integer lastDay = 29;
        ArrayList<String> label = new ArrayList<String>();
        ArrayList<BigDecimal> baseValue = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> outputValue = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> payment = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> cost = new ArrayList<BigDecimal>();
        JSONObject jsonObject = new JSONObject();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        String now = sf.format(new Date());
        String start = null;
        String end = null;
        ProjectReportVo sumVo = new ProjectReportVo();
        CommonResponse res = this.contractReportApi.projectMonth(projectId, lastDay);
        if (!res.isSuccess()) {
            this.logger.error("\u8d77\u59cb\u7ed3\u675f\u65e5\u671f\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u57fa\u51c6\u503c\u67e5\u8be2\u5931\u8d25");
        }
        sumVo = (ProjectReportVo)res.getData();
        if (sumVo.getContractCount() <= 0) {
            this.logger.debug("\u5408\u540c\u4e3a\u7a7a\u6216\u8d77\u59cb\u7ed3\u675f\u65e5\u671f\u67e5\u8be2\u4e3a\u7a7a");
            jsonObject.put("speedLineData", (Object)new ReportAppVo());
            return jsonObject;
        }
        if (StringUtils.isEmpty((String)sumVo.getStartDate())) {
            this.logger.debug("\u5408\u540c\u8d77\u59cb\u65e5\u671f\u4e3a\u7a7a");
            jsonObject.put("speedLineData", (Object)new ReportAppVo());
            return jsonObject;
        }
        if (MonthUtil.compareTime(sumVo.getStartDate(), now) > 0) {
            this.logger.debug("\u5408\u540c\u8d77\u59cb\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u65e5\u671f");
            jsonObject.put("speedLineData", (Object)new ReportAppVo());
            return jsonObject;
        }
        start = sumVo.getStartDate();
        if (StringUtils.isEmpty((String)sumVo.getEndDate())) {
            this.logger.debug("\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a");
            jsonObject.put("speedLineData", (Object)new ReportAppVo());
            return jsonObject;
        }
        end = sumVo.getEndDate();
        String lastMon = null;
        String maxmon = MonthUtil.monthAdd(sf, end, 6);
        lastMon = MonthUtil.compareTime(maxmon, now) >= 1 ? now : maxmon;
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        CommonResponse res1 = this.contractReportApi.sumContractMny(projectId);
        if (!res1.isSuccess()) {
            this.logger.error("\u5408\u540c\u91d1\u989d\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5408\u540c\u91d1\u989d\u67e5\u8be2\u5931\u8d25");
        }
        contractTaxMny = (BigDecimal)res1.getData();
        List productionList = new ArrayList();
        CommonResponse res2 = this.contractReportApi.getMonthProductionMny(projectId, lastDay);
        if (!res2.isSuccess()) {
            this.logger.error("\u4ea7\u503c\u91d1\u989d\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u4ea7\u503c\u91d1\u989d\u67e5\u8be2\u5931\u8d25");
        }
        productionList = (List)res2.getData();
        HashMap<String, Object> czMap1 = new HashMap<String, Object>();
        for (ProjectReportVo rv : productionList) {
            Object a;
            Object object = a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (czMap1.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = (BigDecimal)czMap1.get(rv.getFinishMonth());
                czMap1.put(rv.getFinishMonth(), mny.add((BigDecimal)a));
                continue;
            }
            czMap1.put(rv.getFinishMonth(), a);
        }
        List<ProjectAppVo> receiveList = ((PayContractMapper)this.baseMapper).getReceiveMny(projectId, lastDay);
        HashMap<String, BigDecimal> skMap1 = new HashMap<String, BigDecimal>();
        for (ProjectAppVo rv : receiveList) {
            BigDecimal a;
            BigDecimal bigDecimal = a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (skMap1.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = (BigDecimal)skMap1.get(rv.getFinishMonth());
                skMap1.put(rv.getFinishMonth(), mny.add(a));
                continue;
            }
            skMap1.put(rv.getFinishMonth(), a);
        }
        Map<String, BigDecimal> cbMap1 = this.getCostMonth(projectId, lastDay);
        ArrayList list1 = new ArrayList(czMap1.keySet());
        ArrayList list2 = new ArrayList(skMap1.keySet());
        ArrayList<String> list3 = new ArrayList<String>(cbMap1.keySet());
        ArrayList<String> bigmonthList = new ArrayList<String>();
        for (String s : list1) {
            bigmonthList.add(s);
        }
        for (String s : list2) {
            bigmonthList.add(s);
        }
        for (String s : list3) {
            bigmonthList.add(s);
        }
        String bigMonth = MonthUtil.mostDate(bigmonthList, 0);
        List<Object> monthList = new ArrayList();
        monthList = MonthUtil.compareTime(bigMonth, lastMon) >= 0 ? MonthUtil.getMonthList(start, bigMonth) : MonthUtil.getMonthList(start, lastMon);
        HashMap<Object, BigDecimal> czMap = new HashMap<Object, BigDecimal>();
        for (Object month : monthList) {
            BigDecimal a = BigDecimal.ZERO;
            for (Object m : czMap1.keySet()) {
                if (MonthUtil.compareTime((String)m, (String)month) > 0) continue;
                a = a.add((BigDecimal)czMap1.get(m));
            }
            czMap.put(month, a);
        }
        HashMap<Object, void> skMap = new HashMap<Object, void>();
        for (Object month : monthList) {
            void var37_40;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (Object m : skMap1.keySet()) {
                if (MonthUtil.compareTime((String)m, (String)month) > 0) continue;
                BigDecimal bigDecimal2 = var37_40.add((BigDecimal)skMap1.get(m));
            }
            skMap.put(month, var37_40);
        }
        HashMap<String, Object> cbMap = new HashMap<String, Object>();
        for (String string : monthList) {
            Object a = BigDecimal.ZERO;
            for (String m : cbMap1.keySet()) {
                if (MonthUtil.compareTime(m, string) > 0) continue;
                a = ((BigDecimal)a).add(cbMap1.get(m));
            }
            cbMap.put(string, a);
        }
        List<String> monthList1 = MonthUtil.getMonthList(start, lastMon);
        Integer n = MonthUtil.getSubMonth(start, end);
        for (String mon : monthList1) {
            BigDecimal cz = (BigDecimal)czMap.get(mon);
            BigDecimal sk = (BigDecimal)skMap.get(mon);
            BigDecimal cb = (BigDecimal)cbMap.get(mon);
            BigDecimal output = BigDecimal.ZERO;
            BigDecimal pay = BigDecimal.ZERO;
            BigDecimal costmny = BigDecimal.ZERO;
            if (contractTaxMny.compareTo(BigDecimal.ZERO) != 0) {
                output = cz == null ? BigDecimal.ZERO : cz.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100));
                pay = sk == null ? BigDecimal.ZERO : sk.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100));
                BigDecimal bigDecimal = costmny = cb == null ? BigDecimal.ZERO : cb.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100));
            }
            if (n == 0) {
                baseValue.add(new BigDecimal("100.00"));
            } else {
                Integer subMonth = MonthUtil.getSubMonth(start, mon);
                if ((double)subMonth.intValue() / ((double)n.intValue() * 1.0) >= 1.0) {
                    baseValue.add(new BigDecimal("100.00"));
                } else {
                    Double f = (double)subMonth.intValue() / ((double)n.intValue() * 1.0) * 100.0;
                    BigDecimal b = new BigDecimal(f);
                    BigDecimal bigDecimal = b.setScale(2, 4);
                    baseValue.add(bigDecimal);
                }
            }
            label.add(mon);
            outputValue.add(output.setScale(2, 4));
            payment.add(pay.setScale(2, 4));
            cost.add(costmny.setScale(2, 4));
        }
        ReportAppVo rvo = new ReportAppVo();
        rvo.setLabel(label);
        rvo.setBaseValue(baseValue);
        rvo.setOutputValue(outputValue);
        rvo.setPayment(payment);
        rvo.setCost(cost);
        jsonObject.put("speedLineData", (Object)rvo);
        return jsonObject;
    }

    @Override
    public JSONObject projectIncome(Long projectId) {
        IncomeReportMnyVo inVo = new IncomeReportMnyVo();
        CommonResponse res1 = this.contractReportApi.getIncomeMny(projectId);
        if (!res1.isSuccess()) {
            this.logger.error("\u6536\u5165\u6570\u636e\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u6536\u5165\u6570\u636e\u67e5\u8be2\u5931\u8d25");
        }
        inVo = (IncomeReportMnyVo)res1.getData();
        List pList = new ArrayList();
        CommonResponse res2 = this.contractReportApi.getMonthProduction(projectId);
        if (!res2.isSuccess()) {
            this.logger.error("\u6708\u5ea6\u4ea7\u503c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u6708\u5ea6\u4ea7\u503c\u67e5\u8be2\u5931\u8d25");
        }
        pList = (List)res2.getData();
        BigDecimal billingContract = BigDecimal.ZERO;
        CommonResponse res3 = this.invoiceApi.sumContractMny(projectId);
        if (!res3.isSuccess()) {
            this.logger.error("\u5408\u540c\u5f00\u7968\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5408\u540c\u5f00\u7968\u67e5\u8be2\u5931\u8d25");
        }
        billingContract = (BigDecimal)res3.getData();
        BigDecimal contractReceived = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ReceiveEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(ReceiveEntity::getBillState, billStatus);
        List quoteEntities = this.receiveService.list((Wrapper)lambda);
        for (ReceiveEntity ce : quoteEntities) {
            contractReceived = contractReceived.add(ce.getReceiveMny());
        }
        BigDecimal totalAmount = PayContractServiceImpl.roundTwoPre(inVo.getContractAmount()).add(PayContractServiceImpl.roundTwoPre(inVo.getVisaAmount()));
        HashMap<String, Number> inMap = new HashMap<String, Number>();
        inMap.put("contractQuantity", PayContractServiceImpl.roundTwoPre(inVo.getContractQuantity()));
        inMap.put("visasNumber", PayContractServiceImpl.roundTwoPre(inVo.getVisasNumber()));
        inMap.put("contractAmount", PayContractServiceImpl.roundTwoPre(inVo.getContractAmount()));
        inMap.put("visaAmount", PayContractServiceImpl.roundTwoPre(inVo.getVisaAmount()));
        inMap.put("totalAmount", PayContractServiceImpl.roundTwoPre(totalAmount));
        HashMap<String, Number> payMap = new HashMap<String, Number>();
        if (totalAmount.compareTo(BigDecimal.ZERO) == 0) {
            payMap.put("paymentProgress", 0.0);
        } else {
            payMap.put("paymentProgress", contractReceived.divide(totalAmount, 8, 4).multiply(new BigDecimal(100)));
        }
        payMap.put("contractReceived", PayContractServiceImpl.roundTwoPre(contractReceived));
        payMap.put("uncollectedContractVisa", totalAmount.subtract(contractReceived));
        payMap.put("outputAmount", PayContractServiceImpl.roundTwoPre(inVo.getOutputAmount()));
        payMap.put("batchAmount", PayContractServiceImpl.roundTwoPre(inVo.getBatchAmount()));
        payMap.put("billingContract", PayContractServiceImpl.roundTwoPre(billingContract));
        payMap.put("contractCollection", PayContractServiceImpl.roundTwoPre(contractReceived));
        HashMap monthValue = new HashMap();
        ArrayList<String> label = new ArrayList<String>();
        ArrayList<BigDecimal> value = new ArrayList<BigDecimal>();
        for (ProjectReportVo pr : pList) {
            label.add(pr.getFinishMonth());
            value.add(PayContractServiceImpl.roundTwoPre(pr.getMny()));
        }
        monthValue.put("label", label);
        monthValue.put("value", value);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("revenueManagement", inMap);
        jsonObject.put("paymentProgress", payMap);
        jsonObject.put("monthlyOutputValue", monthValue);
        return jsonObject;
    }

    @Override
    public JSONObject projectOut(Long projectId) {
        SubProjectReportVo sub = new SubProjectReportVo();
        CommonResponse res1 = this.subReportApi.getSubContract(projectId);
        if (!res1.isSuccess()) {
            this.logger.error("\u5206\u5305\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5206\u5305\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        sub = (SubProjectReportVo)res1.getData();
        MaterialReportVo material = new MaterialReportVo();
        CommonResponse res2 = this.materialContractApi.getMaterialContract(projectId);
        if (!res2.isSuccess()) {
            this.logger.error("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        material = (MaterialReportVo)res2.getData();
        List equipment = new ArrayList();
        CommonResponse res3 = this.equipmentApi.getEquipment(projectId);
        if (!res3.isSuccess()) {
            this.logger.error("\u8bbe\u5907\u79df\u8d41/\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u8bbe\u5907\u79df\u8d41/\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        equipment = (List)res3.getData();
        EquipmentReportVo cg = (EquipmentReportVo)equipment.get(0);
        EquipmentReportVo zl = (EquipmentReportVo)equipment.get(1);
        RmatProjectReportVo rmat = new RmatProjectReportVo();
        CommonResponse re5 = this.rmatContractApi.getRmatContract(projectId);
        if (!re5.isSuccess()) {
            this.logger.error("\u5468\u8f6c\u6750\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5468\u8f6c\u6750\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        rmat = (RmatProjectReportVo)re5.getData();
        OtherProjectReportVo other = new OtherProjectReportVo();
        CommonResponse re6 = this.otherContractApi.getOtherContract(projectId);
        if (!re6.isSuccess()) {
            this.logger.error("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        other = (OtherProjectReportVo)re6.getData();
        List taxInvoice = new ArrayList();
        CommonResponse res4 = this.invoiceApi.getTaxReceive(projectId);
        if (!res4.isSuccess()) {
            this.logger.error("\u5408\u540c\u6536\u7968\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5408\u540c\u6536\u7968\u67e5\u8be2\u5931\u8d25");
        }
        taxInvoice = (List)res4.getData();
        HashMap<String, BigDecimal> withMap = new HashMap<String, BigDecimal>();
        BigDecimal without = BigDecimal.ZERO;
        for (InvoiceReceiveVO pc : taxInvoice) {
            if (pc.getType() != null && pc.getType() == 1) {
                if (withMap.containsKey(pc.getContractType())) {
                    BigDecimal a = withMap.get(pc.getContractType()) == null ? BigDecimal.ZERO : (BigDecimal)withMap.get(pc.getContractType());
                    BigDecimal b = pc.getInvoiceTaxMny() == null ? BigDecimal.ZERO : pc.getInvoiceTaxMny();
                    BigDecimal payMny = a.add(b);
                    withMap.put(pc.getContractType(), payMny);
                } else {
                    withMap.put(pc.getContractType(), pc.getInvoiceTaxMny());
                }
            }
            if (pc.getType() == null || pc.getType() != 2) continue;
            BigDecimal b = pc.getInvoiceTaxMny() == null ? BigDecimal.ZERO : pc.getInvoiceTaxMny();
            without = without.add(b);
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(PayContractEntity::getPayStatus, (Object)2);
        lambda.in(PayContractEntity::getBillState, billStatus);
        List payContractEntities = super.list((Wrapper)lambda);
        HashMap<Long, BigDecimal> payMap = new HashMap<Long, BigDecimal>();
        BigDecimal cumulativePayment = BigDecimal.ZERO;
        for (PayContractEntity pc : payContractEntities) {
            if (payMap.containsKey(pc.getContractType())) {
                BigDecimal a = payMap.get(pc.getContractType()) == null ? BigDecimal.ZERO : (BigDecimal)payMap.get(pc.getContractType());
                BigDecimal b = pc.getPayMny() == null ? BigDecimal.ZERO : pc.getPayMny();
                BigDecimal payMny = a.add(b);
                payMap.put(pc.getContractType(), payMny);
            } else {
                payMap.put(pc.getContractType(), pc.getPayMny());
            }
            BigDecimal b = pc.getPayMny() == null ? BigDecimal.ZERO : pc.getPayMny();
            cumulativePayment = cumulativePayment.add(b);
        }
        BigDecimal projectCollection = ((PayContractMapper)this.baseMapper).projectCollection(projectId);
        HashMap<String, BigDecimal> target = new HashMap<String, BigDecimal>();
        BigDecimal c = sub.getMny() == null ? BigDecimal.ZERO : sub.getMny();
        BigDecimal d = material.getMny() == null ? BigDecimal.ZERO : material.getMny();
        BigDecimal e = cg.getMny() == null ? BigDecimal.ZERO : cg.getMny();
        BigDecimal f = zl.getMny() == null ? BigDecimal.ZERO : zl.getMny();
        BigDecimal g = sub.getSettleMny() == null ? BigDecimal.ZERO : sub.getSettleMny();
        BigDecimal h = material.getSettleMny() == null ? BigDecimal.ZERO : material.getSettleMny();
        BigDecimal k = cg.getSettleMny() == null ? BigDecimal.ZERO : cg.getSettleMny();
        BigDecimal l = zl.getSettleMny() == null ? BigDecimal.ZERO : zl.getSettleMny();
        BigDecimal m = projectCollection == null ? BigDecimal.ZERO : projectCollection;
        BigDecimal rmatMny = rmat.getMny() == null ? BigDecimal.ZERO : rmat.getMny();
        BigDecimal otherMny = other.getMny() == null ? BigDecimal.ZERO : other.getMny();
        BigDecimal rmatSettleMny = rmat.getSettleMny() == null ? BigDecimal.ZERO : rmat.getSettleMny();
        BigDecimal otherSettleMny = other.getSettleMny() == null ? BigDecimal.ZERO : other.getSettleMny();
        target.put("expenditureContractAmount", c.add(d).add(e).add(f).add(rmatMny).add(otherMny).setScale(2, 4));
        target.put("contractSettlementAmount", g.add(h).add(k).add(l).add(rmatSettleMny).add(otherSettleMny).setScale(2, 4));
        target.put("otherPayments", PayContractServiceImpl.roundTwoPre(projectCollection).setScale(2, 4));
        target.put("cumulativePayment", cumulativePayment.add(m).setScale(2, 4));
        HashMap<String, Number> subcontract = new HashMap<String, Number>();
        subcontract.put("number", PayContractServiceImpl.roundTwoPre(sub.getNum()));
        subcontract.put("contractAmount", PayContractServiceImpl.roundTwoPre(sub.getMny()));
        subcontract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(sub.getSettleMny()));
        subcontract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(1L)));
        subcontract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("1")));
        HashMap<String, Number> materialPurchaseContract = new HashMap<String, Number>();
        materialPurchaseContract.put("number", PayContractServiceImpl.roundTwoPre(material.getNum()));
        materialPurchaseContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(material.getMny()));
        materialPurchaseContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(material.getSettleMny()));
        materialPurchaseContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(4L)));
        materialPurchaseContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("4")));
        HashMap<String, Number> equipmentProcurementContract = new HashMap<String, Number>();
        equipmentProcurementContract.put("number", PayContractServiceImpl.roundTwoPre(cg.getNum()));
        equipmentProcurementContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(cg.getMny()));
        equipmentProcurementContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(cg.getSettleMny()));
        equipmentProcurementContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(2L)));
        equipmentProcurementContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("2")));
        HashMap<String, Number> equipmentLeasingContract = new HashMap<String, Number>();
        equipmentLeasingContract.put("number", PayContractServiceImpl.roundTwoPre(zl.getNum()));
        equipmentLeasingContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(zl.getMny()));
        equipmentLeasingContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(zl.getSettleMny()));
        equipmentLeasingContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(3L)));
        equipmentLeasingContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("3")));
        HashMap<String, Number> rmatLeasingContract = new HashMap<String, Number>();
        rmatLeasingContract.put("number", PayContractServiceImpl.roundTwoPre(rmat.getNum()));
        rmatLeasingContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(rmat.getMny()));
        rmatLeasingContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(rmat.getSettleMny()));
        rmatLeasingContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(5L)));
        rmatLeasingContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("5")));
        HashMap<String, Number> otherExpendContract = new HashMap<String, Number>();
        otherExpendContract.put("number", PayContractServiceImpl.roundTwoPre(other.getNum()));
        otherExpendContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(other.getMny()));
        otherExpendContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(other.getSettleMny()));
        otherExpendContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(6L)));
        otherExpendContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("6")));
        HashMap<String, BigDecimal> otherExpenses = new HashMap<String, BigDecimal>();
        otherExpenses.put("projectCollection", PayContractServiceImpl.roundTwoPre(projectCollection));
        otherExpenses.put("salesInvoice", PayContractServiceImpl.roundTwoPre(without));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("target", target);
        jsonObject.put("subcontract", subcontract);
        jsonObject.put("materialPurchaseContract", materialPurchaseContract);
        jsonObject.put("equipmentLeasingContract", equipmentLeasingContract);
        jsonObject.put("equipmentProcurementContract", equipmentProcurementContract);
        jsonObject.put("rmatLeasingContract", rmatLeasingContract);
        jsonObject.put("otherExpendContract", otherExpendContract);
        jsonObject.put("otherExpenses", otherExpenses);
        return jsonObject;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnPayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, PayMnyWarnVO> map = new HashMap<String, PayMnyWarnVO>();
        List<PayMnyWarnVO> list = ((PayContractMapper)this.baseMapper).warnPayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getOrgId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnMaterialPayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, PayMnyWarnVO> map = new HashMap<String, PayMnyWarnVO>();
        List<PayMnyWarnVO> list = ((PayContractMapper)this.baseMapper).warnMaterialPayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnMaterialPrePayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, PayMnyWarnVO> map = new HashMap<String, PayMnyWarnVO>();
        List<PayMnyWarnVO> list = ((PayContractMapper)this.baseMapper).warnMaterialPrePayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getPendingTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("payStatus", new Parameter("eq", (Object)1));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("approveTime", "desc");
        String SqlStr = " ((is_send_mbs = 0 ) OR (is_send_mbs = 1 AND (payment_method_name != '\u7f51\u94f6' OR a.id IN ( SELECT payapply_id FROM ejc_finance_pay_contract_settle WHERE settle_payment_method_name != '\u7f51\u94f6' AND dr = 0 )))) ";
        param.getParams().put("id", new Parameter("sql", (Object)SqlStr));
        this.transformReimburse(param);
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayApplyPubVO> list = ((PayContractMapper)this.baseMapper).queryPendingList(null, wrapper);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayApplyPubVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayApplyPubVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
            BigDecimal comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100L)));
            if (2 == purchaseType) {
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (sumPayWithThisMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u4ed8");
                paramsCheckDsVO.setWarnName("\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\uff1a").append(payMny.toString()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumPayWithThisMny.subtract(comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }

    @Override
    public List<PayContractVO> querySupplierPayMny(List<Long> orgIds, List<Long> supplierIds, Integer yearFlag) {
        if (CollectionUtils.isEmpty(supplierIds)) {
            return new ArrayList<PayContractVO>();
        }
        return this.payContractMapper.querySupplierPayMny(orgIds, supplierIds, yearFlag);
    }

    @Override
    public List<PayContractVO> querySupplierPayMnyByProject(Long projectId, Integer yearFlag, List<Integer> contractTypeList) {
        return this.payContractMapper.querySupplierPayMnyByProject(projectId, yearFlag, contractTypeList);
    }

    @Override
    public List<ContractVO> querySubContractMny(Long projectId, Integer yearFlag) {
        return ((PayContractMapper)this.baseMapper).querySubContractMny(projectId, yearFlag);
    }

    @Override
    public List<BlocKanBanVo> queryMaterialContractMny(Long projectId, Integer yearFlag) {
        return ((PayContractMapper)this.baseMapper).queryMaterialContractMny(projectId, yearFlag);
    }

    @Override
    public List<BlocKanBanVo> queryMaterialSettleMny(Long projectId, Integer yearFlag) {
        return ((PayContractMapper)this.baseMapper).queryMaterialSettleMny(projectId, yearFlag);
    }

    @Override
    public List<BlocKanBanVo> querySubOwedMny(Long projectId, Integer yearFlag) {
        return ((PayContractMapper)this.baseMapper).querySubOwedMny(projectId, yearFlag);
    }

    private Map<String, BigDecimal> getCostMonth(Long projectId, Integer lastDay) {
        BigDecimal mny;
        BigDecimal a;
        List subList = new ArrayList();
        CommonResponse res3 = this.subReportApi.getMonthSubMny(projectId, lastDay);
        if (!res3.isSuccess()) {
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
        }
        subList = (List)res3.getData();
        List materialList = new ArrayList();
        CommonResponse res4 = this.materialContractApi.getMonthMaterialMny(projectId, lastDay);
        if (!res4.isSuccess()) {
            this.logger.error("\u7269\u8d44\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u7269\u8d44\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
        }
        materialList = (List)res4.getData();
        List equipmentList = new ArrayList();
        CommonResponse res5 = this.equipmentApi.getMonthEquipmentMny(projectId, lastDay);
        if (!res5.isSuccess()) {
            this.logger.error("\u8bbe\u5907\u91c7\u8d2d\u79df\u8d41\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5b9e\u9645\u6210\u672c\u67e5\u8be2\u5931\u8d25");
        }
        equipmentList = (List)res5.getData();
        List otherList = new ArrayList();
        CommonResponse res6 = this.otherContractApi.getMonthOtherMny(projectId, lastDay);
        if (!res6.isSuccess()) {
            this.logger.error("\u5176\u4ed6\u5408\u540c\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5b9e\u9645\u6210\u672c\u67e5\u8be2\u5931\u8d25");
        }
        otherList = (List)res6.getData();
        List rmatList = new ArrayList();
        CommonResponse res7 = this.rmatContractApi.getMonthRmatMny(projectId, lastDay);
        if (!res7.isSuccess()) {
            this.logger.error("\u5468\u8f6c\u6750\u5408\u540c\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5b9e\u9645\u6210\u672c\u67e5\u8be2\u5931\u8d25");
        }
        rmatList = (List)res7.getData();
        List<ProjectAppVo> costList = ((PayContractMapper)this.baseMapper).getMonthCostMny(projectId, lastDay);
        HashMap<String, BigDecimal> cbMap = new HashMap<String, BigDecimal>();
        for (SubProjectReportVo subProjectReportVo : subList) {
            BigDecimal bigDecimal = a = subProjectReportVo.getMny() == null ? BigDecimal.ZERO : subProjectReportVo.getMny();
            if (cbMap.containsKey(subProjectReportVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(subProjectReportVo.getFinishMonth());
                cbMap.put(subProjectReportVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(subProjectReportVo.getFinishMonth(), a);
        }
        for (MaterialReportVo materialReportVo : materialList) {
            BigDecimal bigDecimal = a = materialReportVo.getMny() == null ? BigDecimal.ZERO : materialReportVo.getMny();
            if (cbMap.containsKey(materialReportVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(materialReportVo.getFinishMonth());
                cbMap.put(materialReportVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(materialReportVo.getFinishMonth(), a);
        }
        for (EquipmentReportVo equipmentReportVo : equipmentList) {
            BigDecimal bigDecimal = a = equipmentReportVo.getMny() == null ? BigDecimal.ZERO : equipmentReportVo.getMny();
            if (cbMap.containsKey(equipmentReportVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(equipmentReportVo.getFinishMonth());
                cbMap.put(equipmentReportVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(equipmentReportVo.getFinishMonth(), a);
        }
        for (OtherProjectReportVo otherProjectReportVo : otherList) {
            BigDecimal bigDecimal = a = otherProjectReportVo.getMny() == null ? BigDecimal.ZERO : otherProjectReportVo.getMny();
            if (cbMap.containsKey(otherProjectReportVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(otherProjectReportVo.getFinishMonth());
                cbMap.put(otherProjectReportVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(otherProjectReportVo.getFinishMonth(), a);
        }
        for (RmatProjectReportVo rmatProjectReportVo : rmatList) {
            BigDecimal bigDecimal = a = rmatProjectReportVo.getMny() == null ? BigDecimal.ZERO : rmatProjectReportVo.getMny();
            if (cbMap.containsKey(rmatProjectReportVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(rmatProjectReportVo.getFinishMonth());
                cbMap.put(rmatProjectReportVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(rmatProjectReportVo.getFinishMonth(), a);
        }
        for (ProjectAppVo projectAppVo : costList) {
            BigDecimal bigDecimal = a = projectAppVo.getMny() == null ? BigDecimal.ZERO : projectAppVo.getMny();
            if (cbMap.containsKey(projectAppVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(projectAppVo.getFinishMonth());
                cbMap.put(projectAppVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(projectAppVo.getFinishMonth(), a);
        }
        return cbMap;
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? new BigDecimal("0.00") : src.setScale(2, 6);
    }

    public static Integer roundTwoPre(Integer src) {
        return src == null ? 0 : src;
    }

    private void validateBeforeSave(PayContractEntity entity) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getContractId, (Object)entity.getContractId());
        lambda.eq(PayContractEntity::getOrgId, (Object)entity.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        lambda.notIn(PayContractEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u540c\u4e00\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e,\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
    }

    private boolean getWriteFlag(PayContractVO vo) {
        PayContractEntity data;
        Integer payStatus;
        boolean writeFlag = false;
        if (vo.getId() != null && (payStatus = (data = (PayContractEntity)((Object)super.selectById((Serializable)vo.getId()))).getPayStatus()) != vo.getPayStatus() && vo.getPayStatus() == 2) {
            writeFlag = true;
        }
        return writeFlag;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PayContractVO vo, Long id) {
        List voList = vo.getInvoiceVOList();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u6536\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()).booleanValue()) {
                    throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                invoiceVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayInvoiceVO.class);
        }
        List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        this.invoiceService.remove((Wrapper)wrapper, false);
        return voList;
    }

    private List<PayContractSettleVO> updateSettleVOS(PayContractVO vo, Long id) {
        List vos = vo.getSettleVOList();
        if (vos != null && !vos.isEmpty()) {
            String billTypeCode = BillTypeCodeEnum.getSettleBillTypeCode((Long)vo.getContractType());
            for (PayContractSettleVO settleVO : vos) {
                if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(settleVO.getSettleId()), (String)billTypeCode, (Integer)settleVO.getSettleVersion()).booleanValue()) {
                    throw new BusinessException("\u7ed3\u7b97\u5355\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                settleVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)vos, PayContractSettleEntity.class);
            this.settleService.saveOrUpdateBatch(entityList, entityList.size(), false);
            vos = BeanMapper.mapList((Iterable)entityList, PayContractSettleVO.class);
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        this.settleService.remove((Wrapper)wrapper, false);
        return vos;
    }

    @Override
    public boolean writeBackSumPayMny(Long billId, PayContractEntity entity, boolean flag) {
        BigDecimal payMny = flag ? entity.getPayMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)entity.getPayMny());
        BigDecimal prepayMny = entity.getFeeType() == 1L ? payMny : BigDecimal.ZERO;
        List settleEntityList = this.settleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        HashMap<Long, BigDecimal> settleApplyMnyMap = new HashMap<Long, BigDecimal>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)settleEntity.getBodyApplyMny());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
        }
        if (entity.getContractType() == 1L) {
            this.subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.subApi.updateSubSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            this.equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updatePurchaseSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 3L) {
            this.equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.materialApi.updateSettlementBillAlreadyPaidAmount(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 5L) {
            this.rmatContractApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.rmatContractApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 6L) {
            this.otherContractApi.updateOtherContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.otherContractApi.updateOtherSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        return true;
    }

    private void autoSetBillCode(PayContractEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }

    private static Date getTime(String limit) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, 0);
        if ("min".equals(limit)) {
            cal.set(cal.get(1), cal.get(2), cal.getActualMinimum(5), 0, 0, 0);
        } else if ("max".equals(limit)) {
            cal.set(cal.get(1), cal.get(2), cal.getActualMaximum(5), 23, 59, 59);
        }
        return cal.getTime();
    }

    private void transformReimburse(QueryParam param) {
        String value;
        Parameter feeType = (Parameter)param.getParams().get("feeType");
        if (!Objects.equals(feeType, null) && StringUtils.contains((String)(value = feeType.getValue().toString()), (String)"\u5176\u4ed6\u8d39\u7528-")) {
            CommonResponse listCommonResponse = this.defdocApi.getDefDocByDefId(Long.valueOf(324875125018329093L));
            List data = (List)listCommonResponse.getData();
            Object[] split = value.split(",");
            for (int i = 0; i < split.length; ++i) {
                String feeTypeName = split[i];
                if (!StringUtils.contains((String)feeTypeName, (String)"\u5176\u4ed6\u8d39\u7528-")) continue;
                List list = data.stream().filter(vo -> vo.getName().equals(feeTypeName.substring(5))).collect(Collectors.toList());
                split[i] = ((DefdocDetailVO)list.get(0)).getId().toString();
            }
            value = StringUtils.join((Object[])split, (String)",");
            feeType.setValue((Object)value);
        }
    }

    private void pushToNcAr(PayContractEntity payContractEntity) {
        List<Long> orgIds;
        PayBillVO vo = this.transferToNCVO(payContractEntity);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(payContractEntity.getProjectId())).get(0);
        StringBuffer sb = new StringBuffer();
        if (payContractEntity.getApplyOrgId().equals(payContractEntity.getActualOrgId())) {
            orgIds = this.ncUtil.validateInvoiceMainOrg(payContractEntity.getApplyOrgId(), project.getMainOrgId());
            for (Long orgId : orgIds) {
                vo.setPk_org(this.ncUtil.queryOrgById(orgId).getCode());
                String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append(sourceId).append(",");
            }
        } else {
            orgIds = this.ncUtil.validateInvoiceMainOrg(payContractEntity.getApplyOrgId(), project.getMainOrgId());
            for (Long orgId : orgIds) {
                vo.setPk_org(this.ncUtil.queryOrgById(orgId).getCode());
                String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append(sourceId).append(",");
            }
            PayBillDetailVO payBillDetailVO2 = (PayBillDetailVO)vo.getDetail().get(0);
            payBillDetailVO2.setBankaccount(payContractEntity.getAccountNum());
            List<Long> orgIds2 = this.ncUtil.validateInvoiceMainOrg(payContractEntity.getActualOrgId(), project.getMainOrgId());
            for (Long orgId : orgIds2) {
                vo.setPk_org(String.valueOf(orgId));
                String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                sb.append(sourceId).append(",");
            }
        }
        String sourceIds = sb.substring(0, sb.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(PayContractEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)payContractEntity.getId());
        super.update((Wrapper)wrapper);
    }

    private PayBillVO transferToNCVO(PayContractEntity payContractEntity) {
        Long projectId = payContractEntity.getProjectId();
        ProjectRegisterVO projects = this.ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
        String mbs = projects.getIsSendMbs();
        this.logger.info("----\u4ed8\u6b3e\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        PayBillVO ncVo = new PayBillVO();
        ncVo.setBusitype("paybill");
        if (payContractEntity.getContractType() == 1L) {
            ncVo.setTradetype("F3-Cxx-001");
        }
        if (payContractEntity.getContractType() == 2L) {
            ncVo.setTradetype("F3-Cxx-004");
        }
        if (payContractEntity.getContractType() == 3L) {
            ncVo.setTradetype("F3-Cxx-005");
        }
        if (payContractEntity.getContractType() == 4L) {
            ncVo.setTradetype("F3-Cxx-002");
        }
        if (payContractEntity.getContractType() == 5L) {
            ncVo.setTradetype("F3-Cxx-003");
        }
        if (payContractEntity.getContractType() == 6L) {
            ncVo.setTradetype("F3-Cxx-008");
        }
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(payContractEntity.getProjectId())).get(0);
        ncVo.setPk_project(String.valueOf(payContractEntity.getProjectId()));
        ncVo.setDef1(Boolean.valueOf(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate()));
        ncVo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        ncVo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        ncVo.setDef4(this.ncUtil.getDefDocById(project.getEngineeringType()).getCode());
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ncVo.setDef5(project.getAreaCode());
        ncVo.setDef12(String.valueOf(payContractEntity.getId()));
        ncVo.setPk_supplier(String.valueOf(payContractEntity.getReceiveUnitId()));
        SupplierVO supplierVO = this.ncUtil.querySupplierById(payContractEntity.getReceiveUnitId());
        ncVo.setSupname(supplierVO.getName());
        ncVo.setTaxpayerid(supplierVO.getSocialCreditCode());
        ncVo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
        ncVo.setDef19(payContractEntity.getBillCode());
        ncVo.setDef20(this.ncUtil.getWebSite("ejc-finance-frontend/#/manageList/contractCard?id=" + payContractEntity.getId()));
        ncVo.setDef21("BT200611000000017");
        ArrayList<PayBillDetailVO> detailVOS = new ArrayList<PayBillDetailVO>();
        List settleEntityList = new ArrayList();
        settleEntityList = mbs.equals("1") ? this.settleService.list((Wrapper)((QueryWrapper)new QueryWrapper().ne((Object)"settle_payment_method_name", (Object)"\u7f51\u94f6")).eq((Object)"payapply_id", (Object)payContractEntity.getId())) : this.settleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)payContractEntity.getId()));
        if (CollectionUtils.isNotEmpty(settleEntityList)) {
            for (PayContractSettleEntity settle : settleEntityList) {
                PayBillDetailVO detailVO = new PayBillDetailVO();
                detailVO.setPk_project(String.valueOf(payContractEntity.getProjectId()));
                detailVO.setBankaccount(payContractEntity.getAccountNum());
                detailVO.setBalatype(this.ncUtil.getDefDocById(settle.getSettlePaymentMethod()).getCode());
                detailVO.setLocal_mny(settle.getBodyApplyMny());
                detailVO.setCashitem(this.ncUtil.getDefDocById(payContractEntity.getCashItemId()).getCode());
                detailVOS.add(detailVO);
            }
        } else {
            PayBillDetailVO detailVO = new PayBillDetailVO();
            detailVO.setPk_project(String.valueOf(payContractEntity.getProjectId()));
            detailVO.setBalatype(this.ncUtil.getDefDocById(payContractEntity.getPaymentMethod()).getCode());
            detailVO.setLocal_mny(payContractEntity.getPayMny());
            detailVO.setCashitem(this.ncUtil.getDefDocById(payContractEntity.getCashItemId()).getCode());
            detailVOS.add(detailVO);
        }
        ncVo.setDetail(detailVOS);
        return ncVo;
    }
}

