/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.mapper.PayContractMapper;
import com.ejianc.business.finance.mapper.PayInfoMapper;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqDetail;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.business.finance.mbs.service.MbsService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.MbsUtils;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.PayApplyPubVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.qdsz.nc.vo.PayBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.PayBillVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payInfoService")
public class PayInfoServiceImpl
extends BaseServiceImpl<PayInfoMapper, PayInfoEntity>
implements IPayInfoService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PAY_INFO_CODE";
    private String URL = "http://58.56.155.202:8010/webservice/outService.ws";
    private String MD5 = "9601a2e927ec7225a2e65ed6ed942198";
    @Autowired
    private IPayInfoService payInfoService;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    @Autowired
    private PayContractMapper payContractMapper;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IPayForegiftService foregiftService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IPayContractSettleService consetservice;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private PayContractMapper conmapper;
    @Autowired
    private IPayContractSettleService settleService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MbsService mbsService;
    @Autowired
    private MbsUtils mbsUtils;
    @Autowired
    private ISubContractForPayApi subApi;
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IMaterialSettlementApi materialApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    private String BankTRANSCODE = "PBQB01";
    private String PayTRANSCODE = "PMSQ01";
    private String PayInfoTRANSCODE = "GETPAYINFO";
    private String MD5Key = "QDSZ123";
    @Autowired
    private NCUtil ncUtil;

    @Override
    public PayInfoVO insertOrUpdate(PayInfoVO saveOrUpdateVO) {
        PayInfoEntity entity = (PayInfoEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayInfoEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getBillCode() == null || "".equals(entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        PayInfoVO vo = (PayInfoVO)BeanMapper.map((Object)((Object)entity), PayInfoVO.class);
        return vo;
    }

    @Override
    public String batchConfirm(List<PayInfoVO> vos) {
        for (PayInfoVO vo : vos) {
            ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(vo.getProjectId())).get(0);
            if (!"1".equals(project.getIndustryIntegrationFlag())) continue;
            this.pushToNcAr(vo);
        }
        return "\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPendingPageJson(QueryParam param, boolean isEs) {
        Long parentid = null;
        ArrayList<Long> parentidlist = new ArrayList<Long>();
        QueryParam param2 = new QueryParam();
        param2.getParams().put("settlePaymentMethod", new Parameter("eq", (Object)"1460221804369940481"));
        param2.getParams().put("dr", new Parameter("eq", (Object)"0"));
        List page1 = this.consetservice.queryList(param2);
        for (PayContractSettleEntity conset : page1) {
            parentid = conset.getPayapplyId();
            if (parentidlist.contains(parentid) || parentid == null) continue;
            parentidlist.add(parentid);
        }
        String jsonString = JSONObject.toJSON(parentidlist).toString();
        String parent = jsonString.replace("[", "(").replace("]", ")");
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("payStatus", new Parameter("eq", (Object)1));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        if (page1.size() != 0) {
            param.getParams().put("id", new Parameter("sql", (Object)("project_id  in (select id from `ejc-market`.ejc_market_project where dr=0 and is_send_mbs =1) and (id in " + parent + " or  payment_method = 1460221804369940481)")));
        } else {
            param.getParams().put("id", new Parameter("sql", (Object)"project_id  in (select id from `ejc-market`.ejc_market_project where dr=0 and is_send_mbs =1) and payment_method = 1460221804369940481"));
        }
        param.getOrderMap().put("approveTime", "desc");
        this.transformReimburse(param);
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayInfoServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayApplyPubVO> list = this.conmapper.queryPendingList(pages, wrapper);
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(324875125018329093L);
        if (!list.isEmpty()) {
            for (PayApplyPubVO vo : list) {
                if (!"\u5176\u4ed6\u8d39\u7528".equals(vo.getApplyType()) || !defdocMap.containsKey(Long.valueOf(vo.getFeeType()))) continue;
                vo.setFeeType("\u5176\u4ed6\u8d39\u7528-" + defdocMap.get(Long.valueOf(vo.getFeeType())));
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    private void transformReimburse(QueryParam param) {
        String value;
        Parameter feeType = (Parameter)param.getParams().get("feeType");
        if (!Objects.equals(feeType, null) && StringUtils.contains((String)(value = feeType.getValue().toString()), (String)"\u5176\u4ed6\u8d39\u7528-")) {
            CommonResponse listCommonResponse = this.defdocApi.getDefDocByDefId(Long.valueOf(324875125018329093L));
            List data = (List)listCommonResponse.getData();
            Object[] split = value.split(",");
            for (int i = 0; i < split.length; ++i) {
                String feeTypeName = split[i];
                if (!StringUtils.contains((String)feeTypeName, (String)"\u5176\u4ed6\u8d39\u7528-")) continue;
                List list = data.stream().filter(vo -> vo.getName().equals(feeTypeName.substring(5))).collect(Collectors.toList());
                split[i] = ((DefdocDetailVO)list.get(0)).getId().toString();
            }
            value = StringUtils.join((Object[])split, (String)",");
            feeType.setValue((Object)value);
        }
    }

    @Override
    public String sendPayConfirmBtn(List<PayInfoVO> vos) {
        for (PayInfoVO vo : vos) {
            String result = vo.getResult();
            if (result.equals("\u652f\u4ed8\u5931\u8d25")) {
                BaseEntity entity;
                if ("HT".equals(vo.getPayInfoType())) {
                    entity = (PayContractEntity)((Object)this.payContractService.selectById(vo.getPayapplyId()));
                    this.logger.info("\u5f00\u59cb\u63a8\u9001\u4e1a\u8d44\u4e00\u4f53\u5316--- entity:" + entity.toString());
                    if (this.ContractbankPayInfo((PayContractEntity)entity)) continue;
                    return "\u7f51\u94f6\u7c7b\u4ed8\u6b3e\u63a8\u9001\u8d44\u91d1\u7cfb\u7edf\u5931\u8d25";
                }
                if ("LX".equals(vo.getPayInfoType())) {
                    entity = (PaySporadicEntity)((Object)this.sporadicService.selectById(vo.getPayapplyId()));
                    this.logger.info("\u5f00\u59cb\u63a8\u9001\u4e1a\u8d44\u4e00\u4f53\u5316--- entity:" + entity.toString());
                    if (this.SporadicbankPayInfo((PaySporadicEntity)entity)) continue;
                    return "\u7f51\u94f6\u7c7b\u4ed8\u6b3e\u63a8\u9001\u8d44\u91d1\u7cfb\u7edf\u5931\u8d25";
                }
                if (!"QT".equals(vo.getPayInfoType())) continue;
                entity = (PayReimburseEntity)((Object)this.reimburseService.selectById(vo.getPayapplyId()));
                this.logger.info("\u5f00\u59cb\u63a8\u9001\u4e1a\u8d44\u4e00\u4f53\u5316--- entity:" + entity.toString());
                if (this.ReimbursebankPayInfo((PayReimburseEntity)entity)) continue;
                return "\u7f51\u94f6\u7c7b\u4ed8\u6b3e\u63a8\u9001\u8d44\u91d1\u7cfb\u7edf\u5931\u8d25";
            }
            if (result.equals("\u5df2\u652f\u4ed8")) {
                throw new BusinessException("\u5df2\u652f\u4ed8\u6570\u636e\u65e0\u6cd5\u518d\u6b21\u63a8\u9001\u4e1a\u8d44\uff01");
            }
            throw new BusinessException("\u6570\u636e\u6b63\u5728\u652f\u4ed8\u4e2d\uff0c\u65e0\u6cd5\u518d\u6b21\u63a8\u9001\uff01");
        }
        return "\u63a8\u9001\u8d44\u91d1\u6210\u529f\uff01";
    }

    private static String md5String(String md5String, String md5Key) {
        String md5Value = PayInfoServiceImpl.MD5Encoder(md5String + md5Key);
        return md5Value;
    }

    public static final String MD5Encoder(String s) {
        return PayInfoServiceImpl.MD5Encoder(s, "utf-8");
    }

    private String splicingXmlRequest(String xml) {
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xml;
        xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:out=\"http://outsystem.ats.com.cn\"><soapenv:Header/><soapenv:Body><out:outSystemWS><out:in0><![CDATA[" + xml + "]]></out:in0></out:outSystemWS></soapenv:Body></soapenv:Envelope>";
        return xml;
    }

    private String splicingXmlResponse(String xml) {
        xml = StringEscapeUtils.unescapeXml((String)xml);
        int a = xml.indexOf("<MBS>");
        int b = xml.indexOf("</MBS>");
        xml = StringUtils.substring((String)xml, (int)a, (int)b) + "</MBS>";
        return xml;
    }

    public static final String MD5Encoder(String s, String charset) {
        try {
            byte[] btInput = s.getBytes(charset);
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < md.length; ++i) {
                int val = md[i] & 0xFF;
                if (val < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(val));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean ContractbankPayInfo(PayContractEntity entity) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)entity.getId()));
        List settleEntityList = this.settleService.queryList(queryParam, false);
        this.logger.info("\u5f00\u59cb\u751f\u6210\u5b9e\u9645\u652f\u4ed8\u5355\u636e");
        this.logger.info("entity\u5b9e\u4f53\u53c2\u6570---------" + entity.getId() + "\u662f\u5426\u7f51\u94f6" + entity.getPaymentMethodName() + entity.getPaymentMethod());
        if (settleEntityList.size() > 0) {
            for (PayContractSettleEntity payContractSettleEntity : settleEntityList) {
                if (!"\u7f51\u94f6".equals(entity.getPaymentMethodName())) continue;
                PayInfoEntity bankPayInfo = new PayInfoEntity();
                bankPayInfo.setBillState(0);
                bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
                bankPayInfo.setCreateTime(entity.getApproveTime());
                bankPayInfo.setDr(0);
                bankPayInfo.setTenantId(entity.getTenantId());
                bankPayInfo.setPayapplyId(entity.getId());
                bankPayInfo.setPayapplyCode(entity.getBillCode());
                bankPayInfo.setProjectName(entity.getProjectName());
                bankPayInfo.setProjectId(entity.getProjectId());
                bankPayInfo.setOrgId(entity.getOrgId());
                bankPayInfo.setOrgName(entity.getOrgName());
                bankPayInfo.setReceiveUnitId(entity.getReceiveUnitId());
                bankPayInfo.setReceiveUnitName(entity.getReceiveUnitName());
                bankPayInfo.setAccountBank(entity.getAccountBank());
                bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
                bankPayInfo.setAccountBankId(entity.getAccountBankId());
                bankPayInfo.setAccountNum(entity.getAccountNum());
                bankPayInfo.setAccountName(entity.getAccountName());
                bankPayInfo.setCollectionType(entity.getCollectionType());
                bankPayInfo.setIsBank("Y");
                bankPayInfo.setApplyUserName(entity.getApplyUserName());
                bankPayInfo.setApplyTime(entity.getApplyTime());
                bankPayInfo.setPayInfoType("HT");
                bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
                bankPayInfo.setSettlePaymentMethodName("\u7f51\u94f6");
                bankPayInfo.setApplyMny(payContractSettleEntity.getBodyApplyMny());
                bankPayInfo.setActualBankCode(entity.getActualBankCode());
                PayInfoVO payInfoVo = (PayInfoVO)BeanMapper.map((Object)((Object)bankPayInfo), PayInfoVO.class);
                this.logger.info("\u6253\u5370\u652f\u4ed8\u5355\u5b9e\u4f53----" + payInfoVo.toString());
                payInfoVo = this.payInfoService.insertOrUpdate(payInfoVo);
                PayReqDetail payReqDetail = this.makeMbs(payInfoVo, payContractSettleEntity);
                try {
                    PayMbsRespVo payMbsRespVo = this.mbsService.sendPay(payReqDetail, payInfoVo);
                    if ("0".equals(payMbsRespVo.getPub().getRESPCODE())) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        } else if ("\u7f51\u94f6".equals(entity.getPaymentMethodName())) {
            this.logger.info("\u5f00\u59cb\u751f\u6210\u9884\u4ed8\u6b3e\u7f51\u94f6\u7c7b\u5b9e\u9645\u652f\u4ed8\u5355\u636e");
            PayInfoEntity bankPayInfo = new PayInfoEntity();
            bankPayInfo.setBillState(0);
            bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
            bankPayInfo.setCreateTime(entity.getApproveTime());
            bankPayInfo.setDr(0);
            bankPayInfo.setTenantId(entity.getTenantId());
            bankPayInfo.setPayapplyId(entity.getId());
            bankPayInfo.setPayapplyCode(entity.getBillCode());
            bankPayInfo.setProjectName(entity.getProjectName());
            bankPayInfo.setProjectId(entity.getProjectId());
            bankPayInfo.setOrgId(entity.getOrgId());
            bankPayInfo.setOrgName(entity.getOrgName());
            bankPayInfo.setReceiveUnitId(entity.getReceiveUnitId());
            bankPayInfo.setReceiveUnitName(entity.getReceiveUnitName());
            bankPayInfo.setAccountBank(entity.getAccountBank());
            bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
            bankPayInfo.setAccountBankId(entity.getAccountBankId());
            bankPayInfo.setAccountNum(entity.getAccountNum());
            bankPayInfo.setAccountName(entity.getAccountName());
            bankPayInfo.setCollectionType(entity.getCollectionType());
            bankPayInfo.setIsBank("Y");
            bankPayInfo.setApplyUserName(entity.getApplyUserName());
            bankPayInfo.setApplyTime(entity.getApplyTime());
            bankPayInfo.setPayInfoType("HT");
            bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
            bankPayInfo.setSettlePaymentMethodName("\u7f51\u94f6");
            bankPayInfo.setApplyMny(entity.getApplyMny());
            bankPayInfo.setActualBankCode(entity.getActualBankCode());
            PayInfoVO payInfoVo = (PayInfoVO)BeanMapper.map((Object)((Object)bankPayInfo), PayInfoVO.class);
            this.logger.info("\u6253\u5370\u652f\u4ed8\u5355\u5b9e\u4f53----" + payInfoVo.toString());
            payInfoVo = this.payInfoService.insertOrUpdate(payInfoVo);
            PayReqDetail payReqDetail = this.makeMbs(payInfoVo, null);
            try {
                PayMbsRespVo payMbsRespVo = this.mbsService.sendPay(payReqDetail, payInfoVo);
                if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean ReimbursebankPayInfo(PayReimburseEntity entity) {
        this.logger.info("\u5f00\u59cb\u751f\u6210\u5b9e\u9645\u652f\u4ed8\u5355\u636e");
        this.logger.info("entity\u5b9e\u4f53\u53c2\u6570---------" + entity.getId() + "\u662f\u5426\u7f51\u94f6" + entity.getPaymentMethodName() + entity.getPaymentMethod());
        if ("\u7f51\u94f6".equals(entity.getPaymentMethodName())) {
            this.logger.info("\u5f00\u59cb\u751f\u6210\u9884\u4ed8\u6b3e\u7f51\u94f6\u7c7b\u5b9e\u9645\u652f\u4ed8\u5355\u636e");
            PayInfoEntity bankPayInfo = new PayInfoEntity();
            bankPayInfo.setBillState(0);
            bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
            bankPayInfo.setCreateTime(entity.getApproveTime());
            bankPayInfo.setDr(0);
            bankPayInfo.setTenantId(entity.getTenantId());
            bankPayInfo.setPayapplyId(entity.getId());
            bankPayInfo.setPayapplyCode(entity.getBillCode());
            bankPayInfo.setProjectName(entity.getProjectName());
            bankPayInfo.setProjectId(entity.getProjectId());
            bankPayInfo.setOrgId(entity.getOrgId());
            bankPayInfo.setOrgName(entity.getOrgName());
            bankPayInfo.setReceiveUnitId(5465813256496854L);
            bankPayInfo.setReceiveUnitName("\u96c6\u56e2\u901a\u7528\u4f9b\u5e94\u5546");
            bankPayInfo.setAccountBank(entity.getAccountBank());
            bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
            bankPayInfo.setAccountBankId(entity.getAccountBankId());
            bankPayInfo.setAccountNum(entity.getAccountNum());
            bankPayInfo.setAccountName(entity.getAccountName());
            bankPayInfo.setCollectionType(entity.getCollectionType());
            bankPayInfo.setIsBank("Y");
            bankPayInfo.setApplyUserName(entity.getApplyUserName());
            bankPayInfo.setApplyTime(entity.getApplyTime());
            bankPayInfo.setPayInfoType("QT");
            bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
            bankPayInfo.setSettlePaymentMethodName("\u7f51\u94f6");
            bankPayInfo.setApplyMny(entity.getApplyMny());
            bankPayInfo.setActualBankCode(entity.getActualBankCode());
            PayInfoVO payInfoVo = (PayInfoVO)BeanMapper.map((Object)((Object)bankPayInfo), PayInfoVO.class);
            this.logger.info("\u6253\u5370\u652f\u4ed8\u5355\u5b9e\u4f53----" + payInfoVo.toString());
            payInfoVo = this.payInfoService.insertOrUpdate(payInfoVo);
            PayReqDetail payReqDetail = this.makeMbs(payInfoVo, null);
            try {
                PayMbsRespVo payMbsRespVo = this.mbsService.sendPay(payReqDetail, payInfoVo);
                if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean SporadicbankPayInfo(PaySporadicEntity entity) {
        this.logger.info("\u5f00\u59cb\u751f\u6210\u5b9e\u9645\u652f\u4ed8\u5355\u636e");
        this.logger.info("entity\u5b9e\u4f53\u53c2\u6570---------" + entity.getId() + "\u662f\u5426\u7f51\u94f6" + entity.getPaymentMethodName() + entity.getPaymentMethod());
        if ("\u7f51\u94f6".equals(entity.getPaymentMethodName())) {
            this.logger.info("\u5f00\u59cb\u751f\u6210\u9884\u4ed8\u6b3e\u7f51\u94f6\u7c7b\u5b9e\u9645\u652f\u4ed8\u5355\u636e");
            PayInfoEntity bankPayInfo = new PayInfoEntity();
            bankPayInfo.setBillState(0);
            bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
            bankPayInfo.setCreateTime(entity.getApproveTime());
            bankPayInfo.setDr(0);
            bankPayInfo.setTenantId(entity.getTenantId());
            bankPayInfo.setPayapplyId(entity.getId());
            bankPayInfo.setPayapplyCode(entity.getBillCode());
            bankPayInfo.setProjectName(entity.getProjectName());
            bankPayInfo.setProjectId(entity.getProjectId());
            bankPayInfo.setOrgId(entity.getOrgId());
            bankPayInfo.setOrgName(entity.getOrgName());
            bankPayInfo.setReceiveUnitId(entity.getSupplierId());
            bankPayInfo.setReceiveUnitName(entity.getSupplierName());
            bankPayInfo.setAccountBank(entity.getAccountBank());
            bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
            bankPayInfo.setAccountBankId(entity.getAccountBankId());
            bankPayInfo.setAccountNum(entity.getAccountNum());
            bankPayInfo.setAccountName(entity.getAccountName());
            bankPayInfo.setCollectionType(entity.getCollectionType());
            bankPayInfo.setIsBank("Y");
            bankPayInfo.setApplyUserName(entity.getApplyUserName());
            bankPayInfo.setApplyTime(entity.getApplyTime());
            bankPayInfo.setPayInfoType("LX");
            bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
            bankPayInfo.setSettlePaymentMethodName("\u7f51\u94f6");
            bankPayInfo.setApplyMny(entity.getApplyMny());
            bankPayInfo.setActualBankCode(entity.getActualBankCode());
            PayInfoVO payInfoVo = (PayInfoVO)BeanMapper.map((Object)((Object)bankPayInfo), PayInfoVO.class);
            this.logger.info("\u6253\u5370\u652f\u4ed8\u5355\u5b9e\u4f53----" + payInfoVo.toString());
            payInfoVo = this.payInfoService.insertOrUpdate(payInfoVo);
            PayReqDetail payReqDetail = this.makeMbs(payInfoVo, null);
            try {
                PayMbsRespVo payMbsRespVo = this.mbsService.sendPay(payReqDetail, payInfoVo);
                if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public PayReqDetail makeMbs(PayInfoVO payInfoVo, PayContractSettleEntity payContractSettleEntity) {
        this.logger.info("\u5f00\u59cb\u751f\u6210\u63a8\u9001\u62a5\u6587\u5b9e\u4f53");
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(payInfoVo.getProjectId());
        List<ProjectRegisterVO> ProjectRegisterVOList = this.mbsUtils.queryProjectByIds(ids);
        ProjectRegisterVO projectRegisterVO = new ProjectRegisterVO();
        if (ProjectRegisterVOList != null && ProjectRegisterVOList.size() > 0) {
            projectRegisterVO = ProjectRegisterVOList.get(0);
        }
        PayReqDetail payDetail = new PayReqDetail();
        payDetail.setSRCSERIALNO(payInfoVo.getId().toString());
        payDetail.setSRCNOTECODE(payInfoVo.getBillCode());
        payDetail.setORGCODE(projectRegisterVO.getMbsDept());
        payDetail.setAPPLYORGCODE(projectRegisterVO.getMbsDept());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = dateFormat.format(new Date());
        payDetail.setPAYDATE(now);
        payDetail.setPAYTYPECODE("103");
        payDetail.setSETTLEMENTMODECODE("101");
        payDetail.setISURGENT("0");
        payDetail.setPURPOSE(payInfoVo.getMemo());
        payDetail.setOURORGCODE(projectRegisterVO.getMbsDept());
        payDetail.setOURBANKACCOUNTNUMBER(payInfoVo.getActualBankCode());
        payDetail.setOURCURCODE("CNY");
        payDetail.setOPPPRIVATEFLAG("2");
        if (payContractSettleEntity != null) {
            payDetail.setOURAMOUNT(payContractSettleEntity.getBodyApplyMny().setScale(4, RoundingMode.HALF_UP).toString());
        } else {
            payDetail.setOURAMOUNT(payInfoVo.getApplyMny().setScale(4, RoundingMode.HALF_UP).toString());
        }
        payDetail.setOPPOBJECTNAME(payInfoVo.getReceiveUnitName());
        payDetail.setOPPBANKLOCATIONCODE(payInfoVo.getAccountBankCode());
        payDetail.setOPPBANKACCOUNTNUMBER(payInfoVo.getAccountNum());
        payDetail.setOPPBANKACCOUNTNAME(payInfoVo.getAccountName());
        payDetail.setOPPDIRECTCURCODE("CNY");
        this.logger.info("\u6253\u5370\u63a8\u9001\u62a5\u6587\u5b9e\u4f53" + payDetail.toString());
        return payDetail;
    }

    private void pushToNcAr(PayInfoVO payInfoVo) {
        String endjson;
        PayBillVO vo = this.transferToNCVO(payInfoVo);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(payInfoVo.getProjectId())).get(0);
        StringBuffer sb = new StringBuffer();
        boolean orgType = false;
        List<Object> orgIds = new ArrayList();
        List<Object> orgIds2 = new ArrayList();
        String accountNum = null;
        String sourceIds = null;
        String feedetail = null;
        String carNoCode = null;
        String sourceId = null;
        if ("HT".equals(payInfoVo.getPayInfoType())) {
            PayContractVO payContractVO = this.payContractService.queryDetail(payInfoVo.getPayapplyId());
            if (payContractVO.getApplyOrgId().equals(payContractVO.getActualOrgId())) {
                orgType = true;
            }
            orgIds = this.ncUtil.validateInvoiceMainOrg(payContractVO.getApplyOrgId(), project.getMainOrgId());
            orgIds2 = this.ncUtil.validateInvoiceMainOrg(payContractVO.getActualOrgId(), project.getMainOrgId());
            accountNum = payContractVO.getAccountNum();
            sourceIds = payContractVO.getSourceId();
        } else if ("LX".equals(payInfoVo.getPayInfoType())) {
            PaySporadicVO paySporadicVO = this.sporadicService.queryDetail(payInfoVo.getPayapplyId());
            if (paySporadicVO.getApplyOrgId().equals(paySporadicVO.getActualOrgId())) {
                orgType = true;
            }
            orgIds = this.ncUtil.validateInvoiceMainOrg(paySporadicVO.getApplyOrgId(), project.getMainOrgId());
            orgIds2 = this.ncUtil.validateInvoiceMainOrg(paySporadicVO.getActualOrgId(), project.getMainOrgId());
            accountNum = paySporadicVO.getAccountNum();
            sourceIds = paySporadicVO.getSourceId();
        } else if ("QT".equals(payInfoVo.getPayInfoType())) {
            PayReimburseVO payReimburseVo = this.reimburseService.queryDetail(payInfoVo.getPayapplyId());
            Long feedtailid = payReimburseVo.getFeeType();
            Map<Long, String> map = this.getDefdocMap(feedtailid);
            feedetail = map.get(payReimburseVo.getFeeType());
            Long carNoCodes = payReimburseVo.getCarNo();
            Map<Long, String> defdocMapcar = this.getDefdocMap(carNoCodes);
            carNoCode = defdocMapcar.get(payReimburseVo.getCarNo());
        }
        if (orgType) {
            for (Object orgId : orgIds) {
                vo.setPk_org(this.ncUtil.queryOrgById((Long)orgId).getCode());
                if ("QT".equals(payInfoVo.getPayInfoType())) {
                    String string = JSONObject.toJSON((Object)vo).toString();
                    endjson = string.replace(":[{", ":[{\"feedetail\":\"" + feedetail + "\",");
                    if (carNoCode != null) {
                        endjson = endjson.replace(",\"detail", ",\"def30\":\"" + carNoCode + "\",\"detail");
                    }
                    sourceId = this.ncUtil.postByJson(endjson);
                } else {
                    sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                }
                sb.append(sourceId).append(",");
            }
        } else {
            for (Object orgId : orgIds) {
                vo.setPk_org(this.ncUtil.queryOrgById((Long)orgId).getCode());
                if ("QT".equals(payInfoVo.getPayInfoType())) {
                    String string = JSONObject.toJSON((Object)vo).toString();
                    endjson = string.replace(":[{", ":[{\"feedetail\":\"" + feedetail + "\",");
                    if (carNoCode != null) {
                        endjson = endjson.replace(",\"detail", ",\"def30\":\"" + carNoCode + "\",\"detail");
                    }
                    sourceId = this.ncUtil.postByJson(endjson);
                } else {
                    sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
                }
                sb.append(sourceId).append(",");
            }
        }
        PayBillDetailVO payBillDetailVO2 = (PayBillDetailVO)vo.getDetail().get(0);
        payBillDetailVO2.setBankaccount(accountNum);
        for (Long l : orgIds2) {
            vo.setPk_org(String.valueOf(l));
            if ("QT".equals(payInfoVo.getPayInfoType())) {
                String jsonString2 = JSONObject.toJSON((Object)vo).toString();
                String endjson2 = jsonString2.replace(":[{", ":[{\"feedetail\":\"" + feedetail + "\",");
                if (carNoCode != null) {
                    endjson2 = endjson2.replace(",\"detail", ",\"def30\":\"" + carNoCode + "\",\"detail");
                }
                sourceId = this.ncUtil.postByJson(endjson2);
            } else {
                sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            }
            sb.append(sourceId).append(",");
        }
        sourceIds = sourceIds != null && !"".equals(sourceIds) ? sourceIds + "," + sb.substring(0, sb.length() - 1) : sb.substring(0, sb.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(PayContractEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)payInfoVo.getId());
        payInfoVo.setResult("200");
        this.payInfoService.insertOrUpdate(payInfoVo);
        this.payContractService.update((Wrapper)wrapper);
    }

    private PayBillVO transferToNCVO(PayInfoVO payInfoVo) {
        Long projectId = payInfoVo.getProjectId();
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
        this.logger.info("----\u4ed8\u6b3e\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        PayBillVO ncVo = new PayBillVO();
        ncVo.setBusitype("paybill");
        ncVo.setPk_project(String.valueOf(payInfoVo.getProjectId()));
        ncVo.setDef1(Boolean.valueOf(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate()));
        ncVo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        ncVo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        ncVo.setDef4(this.ncUtil.getDefDocById(project.getEngineeringType()).getCode());
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ncVo.setDef5(project.getAreaCode());
        ncVo.setDef12(String.valueOf(payInfoVo.getId()));
        ArrayList<PayBillDetailVO> detailVOS = new ArrayList<PayBillDetailVO>();
        if ("HT".equals(payInfoVo.getPayInfoType())) {
            PayContractVO payContractVO = this.payContractService.queryDetail(payInfoVo.getPayapplyId());
            if (payContractVO.getContractType() == 1L) {
                ncVo.setTradetype("F3-Cxx-001");
            }
            if (payContractVO.getContractType() == 2L) {
                ncVo.setTradetype("F3-Cxx-004");
            }
            if (payContractVO.getContractType() == 3L) {
                ncVo.setTradetype("F3-Cxx-005");
            }
            if (payContractVO.getContractType() == 4L) {
                ncVo.setTradetype("F3-Cxx-002");
            }
            if (payContractVO.getContractType() == 5L) {
                ncVo.setTradetype("F3-Cxx-003");
            }
            if (payContractVO.getContractType() == 6L) {
                ncVo.setTradetype("F3-Cxx-008");
            }
            ncVo.setPk_supplier(String.valueOf(payContractVO.getReceiveUnitId()));
            SupplierVO supplierVO = this.ncUtil.querySupplierById(payContractVO.getReceiveUnitId());
            ncVo.setSupname(supplierVO.getName());
            ncVo.setTaxpayerid(supplierVO.getSocialCreditCode());
            ncVo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
            ncVo.setDef19(payContractVO.getBillCode());
            ncVo.setDef20(this.ncUtil.getWebSite("ejc-finance-frontend/#/manageList/contractCard?id=" + payContractVO.getId()));
            ncVo.setDef21("BT200611000000017");
            PayBillDetailVO detailVO = new PayBillDetailVO();
            detailVO.setPk_project(String.valueOf(payContractVO.getProjectId()));
            detailVO.setBalatype(this.ncUtil.getDefDocById(payContractVO.getPaymentMethod()).getCode());
            detailVO.setLocal_mny(payInfoVo.getPayMny());
            detailVO.setCashitem(this.ncUtil.getDefDocById(payContractVO.getCashItemId()).getCode());
            detailVOS.add(detailVO);
        } else if ("LX".equals(payInfoVo.getPayInfoType())) {
            PaySporadicVO paySporadicVO = this.sporadicService.queryDetail(payInfoVo.getPayapplyId());
            ncVo.setTradetype("F3-Cxx-022");
            ncVo.setPk_supplier(String.valueOf(paySporadicVO.getSupplierId()));
            SupplierVO supplierVO = this.ncUtil.querySupplierById(paySporadicVO.getSupplierId());
            ncVo.setSupname(supplierVO.getName());
            ncVo.setTaxpayerid(supplierVO.getSocialCreditCode());
            ncVo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
            ncVo.setBalatype(this.ncUtil.getDefDocById(paySporadicVO.getPaymentMethod()).getCode());
            ncVo.setDef19(paySporadicVO.getBillCode());
            ncVo.setDef20(this.ncUtil.getWebSite("ejc-finance-frontend/#/manageList/contractCard?id=" + paySporadicVO.getId()));
            ncVo.setDef21("BT200611000000017");
            PayBillDetailVO detailVO = new PayBillDetailVO();
            detailVO.setPk_project(String.valueOf(paySporadicVO.getProjectId()));
            detailVO.setBalatype(this.ncUtil.getDefDocById(paySporadicVO.getPaymentMethod()).getCode());
            detailVO.setLocal_mny(payInfoVo.getPayMny());
            detailVO.setCashitem(this.ncUtil.getDefDocById(paySporadicVO.getCashItemId()).getCode());
            detailVOS.add(detailVO);
        } else if ("QT".equals(payInfoVo.getPayInfoType())) {
            PayReimburseVO payReimburseVo = this.reimburseService.queryDetail(payInfoVo.getPayapplyId());
            ncVo.setTradetype("F3-Cxx-021");
            ncVo.setPk_supplier("5465813256496854");
            ncVo.setSupname("\u96c6\u56e2\u901a\u7528\u4f9b\u5e94\u5546");
            ncVo.setTaxpayerid("9999-000");
            ncVo.setDef6(Boolean.valueOf(false));
            ncVo.setBalatype(this.ncUtil.getDefDocById(payReimburseVo.getPaymentMethod()).getCode());
            ncVo.setDef19(payReimburseVo.getBillCode());
            ncVo.setDef20(this.ncUtil.getWebSite("ejc-finance-frontend/#/manageList/contractCard?id=" + payReimburseVo.getId()));
            ncVo.setDef21("BT200611000000017");
            PayBillDetailVO detailVO = new PayBillDetailVO();
            detailVO.setPk_project(String.valueOf(payReimburseVo.getProjectId()));
            detailVO.setBalatype(this.ncUtil.getDefDocById(payReimburseVo.getPaymentMethod()).getCode());
            detailVO.setLocal_mny(payReimburseVo.getPayMny());
            detailVO.setCashitem(this.ncUtil.getDefDocById(payReimburseVo.getCashItemId()).getCode());
            detailVOS.add(detailVO);
        }
        ncVo.setDetail(detailVOS);
        return ncVo;
    }

    public boolean writeBackSumPayMny(PayInfoVO payInfoVo, boolean flag) {
        PayContractVO payContractVO = this.payContractService.queryDetail(payInfoVo.getPayapplyId());
        BigDecimal payMny = flag ? payInfoVo.getPayMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)payContractVO.getPayMny());
        BigDecimal prepayMny = payContractVO.getFeeType() == 1L ? payMny : BigDecimal.ZERO;
        HashMap<Long, BigDecimal> settleApplyMnyMap = new HashMap<Long, BigDecimal>();
        BigDecimal applyMny = flag ? payInfoVo.getApplyMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)payInfoVo.getApplyMny());
        settleApplyMnyMap.put(payInfoVo.getSettleId(), applyMny);
        if (payContractVO.getContractType() == 1L) {
            this.subApi.updateSubContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);
            this.subApi.updateSubSettleSumPayMny(payInfoVo.getSettleId(), (BigDecimal)settleApplyMnyMap.get(payInfoVo.getSettleId()));
        }
        if (payContractVO.getContractType() == 2L) {
            this.equipmentApi.updatePurchaseContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);
            this.equipmentApi.updatePurchaseSettleSumPayMny(payInfoVo.getSettleId(), (BigDecimal)settleApplyMnyMap.get(payInfoVo.getSettleId()));
        }
        if (payContractVO.getContractType() == 3L) {
            this.equipmentApi.updateRentContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);
            this.equipmentApi.updateRentSettleSumPayMny(payInfoVo.getSettleId(), (BigDecimal)settleApplyMnyMap.get(payInfoVo.getSettleId()));
        }
        if (payContractVO.getContractType() == 4L) {
            this.materialApi.updateSettlementBillAlreadyPaidAmount(payInfoVo.getSettleId(), (BigDecimal)settleApplyMnyMap.get(payInfoVo.getSettleId()));
        }
        if (payContractVO.getContractType() == 5L) {
            this.rmatContractApi.updateRentContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);
            this.rmatContractApi.updateRentSettleSumPayMny(payInfoVo.getSettleId(), (BigDecimal)settleApplyMnyMap.get(payInfoVo.getSettleId()));
        }
        if (payContractVO.getContractType() == 6L) {
            this.otherContractApi.updateOtherContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);
            this.otherContractApi.updateOtherSettleSumPayMny(payInfoVo.getSettleId(), (BigDecimal)settleApplyMnyMap.get(payInfoVo.getSettleId()));
        }
        return true;
    }

    public Map<Long, String> getDefdocMap(Long id) {
        CommonResponse resp = this.defdocApi.getDefDocByDefId(id);
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            List list = (List)resp.getData();
            return list.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getCode));
        }
        return new HashMap<Long, String>();
    }
}

