/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqDetail;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.business.finance.mbs.service.MbsService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IPaySporadicStockService;
import com.ejianc.business.finance.utils.MbsUtils;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paySporadic")
public class PaySporadicBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPaySporadicService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private NCUtil ncUtil;
    @Autowired
    private IPaySporadicStockService stockService;
    @Autowired
    private IPayInfoService payInfoService;
    @Autowired
    private MbsUtils mbsUtils;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private MbsService mbsService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)this.service.selectById(billId));
        entity.setApproveTime(new Date());
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        Long projectId = entity.getProjectId();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(projectId);
        List<ProjectRegisterVO> ProjectRegisterVOList = this.mbsUtils.queryProjectByIds(ids);
        ProjectRegisterVO projectRegisterVO = new ProjectRegisterVO();
        if (ProjectRegisterVOList != null && ProjectRegisterVOList.size() > 0) {
            projectRegisterVO = ProjectRegisterVOList.get(0);
        }
        this.logger.info("\u6253\u5370\u9879\u76ee\u5c5e\u6027--- projectRegisterVO:" + projectRegisterVO.toString());
        if (projectRegisterVO != null && "1".equals(projectRegisterVO.getIsSendMbs())) {
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u4e1a\u8d44\u4e00\u4f53\u5316--- entity:" + ((Object)((Object)entity)).toString());
            if (!this.bankPayInfo(entity)) {
                return CommonResponse.error((String)"\u7f51\u94f6\u7c7b\u4ed8\u6b3e\u63a8\u9001\u8d44\u91d1\u7cfb\u7edf\u5931\u8d25");
            }
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)this.service.selectById(billId));
        if (StringUtils.isNotEmpty((String)entity.getSourceId())) {
            String[] split;
            for (String sourceId : split = entity.getSourceId().split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deletepaybill");
                json.put("pk_bill", (Object)sourceId);
                this.ncUtil.postByJson(json.toJSONString());
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(PaySporadicEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.service.update((Wrapper)wrapper);
        }
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        this.service.pullCost(billId);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public boolean bankPayInfo(PaySporadicEntity entity) {
        this.logger.info("\u5f00\u59cb\u751f\u6210\u5b9e\u9645\u652f\u4ed8\u5355\u636e");
        this.logger.info("entity\u5b9e\u4f53\u53c2\u6570---------" + entity.getId() + "\u662f\u5426\u7f51\u94f6" + entity.getPaymentMethodName() + entity.getPaymentMethod());
        if ("\u7f51\u94f6".equals(entity.getPaymentMethodName())) {
            this.logger.info("\u5f00\u59cb\u751f\u6210\u9884\u4ed8\u6b3e\u7f51\u94f6\u7c7b\u5b9e\u9645\u652f\u4ed8\u5355\u636e");
            PayInfoEntity bankPayInfo = new PayInfoEntity();
            bankPayInfo.setBillState(0);
            bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
            bankPayInfo.setCreateTime(entity.getApproveTime());
            bankPayInfo.setDr(0);
            bankPayInfo.setTenantId(entity.getTenantId());
            bankPayInfo.setPayapplyId(entity.getId());
            bankPayInfo.setPayapplyCode(entity.getBillCode());
            bankPayInfo.setProjectName(entity.getProjectName());
            bankPayInfo.setProjectId(entity.getProjectId());
            bankPayInfo.setOrgId(entity.getOrgId());
            bankPayInfo.setOrgName(entity.getOrgName());
            bankPayInfo.setReceiveUnitId(entity.getSupplierId());
            bankPayInfo.setReceiveUnitName(entity.getSupplierName());
            bankPayInfo.setAccountBank(entity.getAccountBank());
            bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
            bankPayInfo.setAccountBankId(entity.getAccountBankId());
            bankPayInfo.setAccountNum(entity.getAccountNum());
            bankPayInfo.setAccountName(entity.getAccountName());
            bankPayInfo.setCollectionType(entity.getCollectionType());
            bankPayInfo.setIsBank("Y");
            bankPayInfo.setApplyUserName(entity.getApplyUserName());
            bankPayInfo.setApplyTime(entity.getApplyTime());
            bankPayInfo.setPayInfoType("LX");
            bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
            bankPayInfo.setSettlePaymentMethodName("\u7f51\u94f6");
            bankPayInfo.setApplyMny(entity.getApplyMny());
            bankPayInfo.setActualBankCode(entity.getActualBankCode());
            bankPayInfo.setResult("0");
            PayInfoVO payInfoVo = (PayInfoVO)BeanMapper.map((Object)((Object)bankPayInfo), PayInfoVO.class);
            this.logger.info("\u6253\u5370\u652f\u4ed8\u5355\u5b9e\u4f53----" + payInfoVo.toString());
            payInfoVo = this.payInfoService.insertOrUpdate(payInfoVo);
            PayReqDetail payReqDetail = this.makeMbs(payInfoVo, null);
            try {
                PayMbsRespVo payMbsRespVo = this.mbsService.sendPay(payReqDetail, payInfoVo);
                if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public PayReqDetail makeMbs(PayInfoVO payInfoVo, PayContractSettleEntity payContractSettleEntity) {
        this.logger.info("\u5f00\u59cb\u751f\u6210\u63a8\u9001\u62a5\u6587\u5b9e\u4f53");
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(payInfoVo.getProjectId());
        List<ProjectRegisterVO> ProjectRegisterVOList = this.mbsUtils.queryProjectByIds(ids);
        ProjectRegisterVO projectRegisterVO = new ProjectRegisterVO();
        if (ProjectRegisterVOList != null && ProjectRegisterVOList.size() > 0) {
            projectRegisterVO = ProjectRegisterVOList.get(0);
        }
        PayReqDetail payDetail = new PayReqDetail();
        payDetail.setSRCSERIALNO(payInfoVo.getId().toString());
        payDetail.setSRCNOTECODE(payInfoVo.getBillCode());
        payDetail.setORGCODE(projectRegisterVO.getMbsDept());
        payDetail.setAPPLYORGCODE(projectRegisterVO.getMbsDept());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = dateFormat.format(new Date());
        payDetail.setPAYDATE(now);
        payDetail.setPAYTYPECODE("103");
        payDetail.setSETTLEMENTMODECODE(projectRegisterVO.getWySettleCode());
        payDetail.setISURGENT("0");
        payDetail.setPURPOSE(payInfoVo.getMemo());
        payDetail.setOURORGCODE(projectRegisterVO.getMbsDept());
        payDetail.setOURBANKACCOUNTNUMBER(payInfoVo.getActualBankCode());
        payDetail.setOURCURCODE("CNY");
        payDetail.setOPPPRIVATEFLAG("2");
        if (payContractSettleEntity != null) {
            payDetail.setOURAMOUNT(payContractSettleEntity.getBodyApplyMny().setScale(4, RoundingMode.HALF_UP).toString());
        } else {
            payDetail.setOURAMOUNT(payInfoVo.getApplyMny().setScale(4, RoundingMode.HALF_UP).toString());
        }
        payDetail.setOPPOBJECTNAME(payInfoVo.getReceiveUnitName());
        payDetail.setOPPBANKLOCATIONCODE(payInfoVo.getAccountBankCode());
        payDetail.setOPPBANKACCOUNTNUMBER(payInfoVo.getAccountNum());
        payDetail.setOPPBANKACCOUNTNAME(payInfoVo.getAccountName());
        payDetail.setOPPDIRECTCURCODE("CNY");
        this.logger.info("\u6253\u5370\u63a8\u9001\u62a5\u6587\u5b9e\u4f53" + payDetail.toString());
        return payDetail;
    }
}

