/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.utils;

import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MbsUtils {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ISupplierWebApi supplierWebApi;

    public OrgVO queryOrgById(Long id) {
        CommonResponse resp = this.orgApi.detailById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (OrgVO)resp.getData();
    }

    public OrgVO queryParentOrgById(Long id) {
        OrgVO org = this.queryOrgById(id);
        if (new Integer(5).equals(org.getOrgType())) {
            return this.queryOrgById(org.getParentId());
        }
        return org;
    }

    public Map<String, OrgVO> findOrgMap() {
        CommonResponse resp = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(2), null);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List list = (List)resp.getData();
        Map<String, Object> map = new HashMap<String, OrgVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            map = list.stream().collect(Collectors.toMap(OrgVO::getInnerCode, Function.identity()));
        }
        return map;
    }

    public List<ProjectRegisterVO> queryProjectByIds(List<Long> ids) {
        CommonResponse resp = this.projectApi.queryProjectByIds(ids);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    private Long getCorpOrgId(Long id) {
        OrgVO org = this.queryOrgById(id);
        if (new Integer(5).equals(org.getOrgType())) {
            Map<String, OrgVO> orgMap = this.findOrgMap();
            for (String key : orgMap.keySet()) {
                if (!org.getInnerCode().startsWith(key)) continue;
                id = orgMap.get(key).getId();
            }
        }
        return id;
    }

    public BankAccountVO queryDefaultBankAccountById(Long id, String type) {
        CommonResponse resp;
        if ("insideOrgId".equals(type)) {
            id = this.getCorpOrgId(id);
        }
        if (!(resp = this.supplierWebApi.queryDefaultBankAccountById(id, type)).isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)((BankAccountVO)resp.getData()).getBankCode())) {
            throw new BusinessException("\u5ba2\u5546\u94f6\u884c\u8d26\u6237\u4e3a\u7a7a\uff01");
        }
        return (BankAccountVO)resp.getData();
    }
}

