package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
public interface IPayReimburseService extends IBaseService<PayReimburseEntity> {

    PayReimburseVO insertOrUpdate(PayReimburseVO payReimburseVO);

    PayReimburseVO queryDetail(Long id);

    List<PayReimburseVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);

    /**
     * 统计匹配条件的报销申请付款金额总数
     *
     * @param tenantId 租户Id
     * @param projectIds 待过滤项目Id列表
     * @return
     */
    Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds);

    CommonResponse<PayReimburseVO> pushCost(PayReimburseVO paySporadicVO);

    void costPush(PayReimburseEntity payReimburseEntity);

    //成本改造
    void pullCost(Long id);

    TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs);
}
