package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IPaySporadicService extends IBaseService<PaySporadicEntity> {

    PaySporadicVO insertOrUpdate(PaySporadicVO paySporadicVO);

    PaySporadicVO queryDetail(Long id);

    List<PaySporadicVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);

    /**
     * 统计匹配的零星材料付款申请支付金额总数（属于项目的单据）
     *
     * @param tenantId 租户Id
     * @param projectIds 项目Id列表
     * @return
     */
    Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds);

    CommonResponse<PaySporadicVO> pushCost(PaySporadicVO paySporadicVO);

    void costPush(PaySporadicEntity loadReimburseEntity);

    //成本改造
    void pullCost(Long id);

    TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs);
}
