package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 * 对上保证金申请审批事件
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("bondUp")
public class BondUpBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBondUpDealService bondUpDealService;

    @Autowired
    private IBondUpBackService bondUpBackService;

    @Autowired
    private NCUtil ncUtil;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入弃审后回写--- billId:"+billId+"  state:"+state);
        BondUpEntity upEntity = bondUpService.selectById(billId);
        upEntity.setBondStatus("0");
        upEntity.setBackMny(BigDecimal.ZERO);
        upEntity.setPayMny(BigDecimal.ZERO);
        upEntity.setEmployeeId(null);
        upEntity.setEmployeeName(null);
        boolean res = bondUpService.saveOrUpdate(upEntity,false);
        QueryWrapper<BondUpDealEntity> dealWrapper = new QueryWrapper<>();
        dealWrapper.eq("bond_id", billId);
        bondUpDealService.remove(dealWrapper,false);

        QueryWrapper<BondUpBackEntity> backWrapper = new QueryWrapper<>();
        backWrapper.eq("bond_id", billId);
        bondUpBackService.remove(backWrapper,false);
        // 删除NC传付款单凭证
        if(StringUtils.isNotEmpty(upEntity.getSourceId())){
            String[] split = upEntity.getSourceId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deletepaybill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }
            LambdaUpdateWrapper<BondUpEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(BondUpEntity::getSourceId, null);// 保存来源主键
            wrapper.eq(BondUpEntity::getId, billId);
            bondUpService.update(wrapper);
        }
        if(StringUtils.isNotEmpty(upEntity.getSourceBackId())){
            String[] split = upEntity.getSourceBackId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deleterecbill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }
            LambdaUpdateWrapper<BondUpEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(BondUpEntity::getSourceId, null);// 保存来源主键
            wrapper.eq(BondUpEntity::getId, billId);
            bondUpService.update(wrapper);
        }
        if(res){
            return CommonResponse.success("回退成功!");
        }else{
            return CommonResponse.error("回退出现异常，请刷新后再试!");
        }
    }

}
