package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.mapper.LoadApplyMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadBackService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 借款申请
 * 
 * @author generator
 * 
 */
@Service
public class LoadApplyServiceImpl extends BaseServiceImpl<LoadApplyMapper, LoadApplyEntity> implements ILoadApplyService{
    private static final String BONDUP_BILL_CODE = "LOAD_APPLY";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ILoadReimburseService loadReimburseService;

    @Autowired
    private ILoadBackService loadBackService;
    @Override
    public LoadApplyVO insertOrUpdate(LoadApplyVO loadApplyVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(null!=loadApplyVO&&StringUtils.isEmpty(loadApplyVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                loadApplyVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //同一用户，组织下只能存在一条未生效的
        LambdaQueryWrapper<LoadApplyEntity> lambdachange = Wrappers.<LoadApplyEntity>lambdaQuery();
        lambdachange.eq(LoadApplyEntity::getTenantId, tenantId);
        lambdachange.eq(LoadApplyEntity::getApplyEmployeeId,InvocationInfoProxy.getEmployeeId());
        lambdachange.eq(LoadApplyEntity::getOrgId,loadApplyVO.getOrgId());
        if(null!=loadApplyVO.getId()&&loadApplyVO.getId()>0){
            lambdachange.ne(LoadApplyEntity::getId,loadApplyVO.getId());
        }
        lambdachange.ne(LoadApplyEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(LoadApplyEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<LoadApplyEntity> list = super.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("在该组织存在未生效的借款申请单,单据编号【"+list.get(0).getBillCode()+"】");
        }
        LoadApplyEntity entity = BeanMapper.map(loadApplyVO, LoadApplyEntity.class);
        BigDecimal surplusMny =  querySurplusMny(null,null,entity.getOrgId(),1,"");
        entity.setSurplusMny(surplusMny);
        super.saveOrUpdate(entity,false);
        return BeanMapper.map(entity, LoadApplyVO.class);
    }

    @Override
    public BigDecimal querySurplusMny(Long rebid,Long backid,Long orgId,int type,String applyEmployeeId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(applyEmployeeId)){
            applyEmployeeId = InvocationInfoProxy.getEmployeeId();
        }
        //根据当前登录人+orgId 查询申请单审批通过的申请金额
        List<LoadApplyEntity> listApplys = new ArrayList<>();
        List<LoadReimburseEntity> listReimburse = new ArrayList<>();
        List<LoadBackEntity> listBack = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        LambdaQueryWrapper<LoadApplyEntity> lambda = Wrappers.<LoadApplyEntity>lambdaQuery();
        lambda.eq(LoadApplyEntity::getTenantId, tenantId);
        lambda.eq(LoadApplyEntity::getOrgId, orgId);
        lambda.eq(LoadApplyEntity::getApplyEmployeeId,applyEmployeeId);
        lambda.in(LoadApplyEntity::getBillState,billstate);
        listApplys = super.list(lambda);
        BigDecimal sumApplyMny = listApplys.stream().map(LoadApplyEntity::getApplyMny).reduce(BigDecimal.ZERO,  (a, b) -> a.add(b));

        //根据当前登录人+orgId 查询申请单审批通过的报销金额
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
        queryParam.getParams().put("org_id", new Parameter(QueryParam.EQ,orgId));
        queryParam.getParams().put("apply_employee_id", new Parameter(QueryParam.EQ,applyEmployeeId));
        if(null!=rebid){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,rebid));
        }
        if(1==type){
            queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        }
        listReimburse = loadReimburseService.queryList(queryParam,false);
        BigDecimal sumReimburseMny = listReimburse.stream().map(LoadReimburseEntity::getReimburseMny).reduce(BigDecimal.ZERO,  (a, b) -> a.add(b));

        //根据当前登录人+orgId 查询申请单审批通过的报销金额
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
        queryParam2.getParams().put("org_id", new Parameter(QueryParam.EQ,orgId));
        queryParam2.getParams().put("apply_employee_id", new Parameter(QueryParam.EQ,applyEmployeeId));
        if(null!=backid){
            queryParam2.getParams().put("id", new Parameter(QueryParam.NE,backid));
        }
        if(1==type){
            queryParam2.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        }
        listBack = loadBackService.queryList(queryParam2,false);
        BigDecimal sumBackMny = listBack.stream().map(LoadBackEntity::getBackMny).reduce(BigDecimal.ZERO,  (a, b) -> a.add(b));

        BigDecimal ApplyMny = sumApplyMny==null?BigDecimal.ZERO:sumApplyMny;
        BigDecimal ReimburseMny = sumReimburseMny==null?BigDecimal.ZERO:sumReimburseMny;
        BigDecimal BackMny = sumBackMny==null?BigDecimal.ZERO:sumBackMny;
        return ApplyMny.subtract(ReimburseMny).subtract(BackMny);
    }

    @Override
    public List<LoadApplyVO> queryUserReport() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String userId = InvocationInfoProxy.getEmployeeId();
        List<LoadApplyVO> list = baseMapper.getUserReport(tenantId,userId);
        return list;
    }

    @Override
    public List<LoadApplyVO> queryAllReport(Page pages, QueryWrapper queryWrapper) {
        List<LoadApplyVO> listres = baseMapper.getReports(pages,queryWrapper);
        return listres;
    }
}
